/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.UserManagedPermissionUtil;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authorization.adapter.MapPermissionTicketAdapter;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.HasRealmId;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.utils.StreamsUtil;

public class MapPermissionTicketStore
implements PermissionTicketStore {
    private static final Logger LOG = Logger.getLogger(MapPermissionTicketStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<MapPermissionTicketEntity, PermissionTicket> tx;
    private final boolean txHasRealmId;

    public MapPermissionTicketStore(KeycloakSession session, MapStorage<MapPermissionTicketEntity, PermissionTicket> permissionTicketStore, AuthorizationProvider provider) {
        this.authorizationProvider = provider;
        this.tx = permissionTicketStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
        this.txHasRealmId = this.tx instanceof HasRealmId;
    }

    private Function<MapPermissionTicketEntity, PermissionTicket> entityToAdapterFunc(RealmModel realm, ResourceServer resourceServer) {
        return origEntity -> new MapPermissionTicketAdapter(realm, resourceServer, (MapPermissionTicketEntity)origEntity, this.authorizationProvider.getStoreFactory());
    }

    private MapKeycloakTransaction<MapPermissionTicketEntity, PermissionTicket> txInRealm(RealmModel realm) {
        if (this.txHasRealmId) {
            ((HasRealmId)((Object)this.tx)).setRealmId(realm == null ? null : realm.getId());
        }
        return this.tx;
    }

    private DefaultModelCriteria<PermissionTicket> forRealmAndResourceServer(RealmModel realm, ResourceServer resourceServer) {
        DefaultModelCriteria mcb = (DefaultModelCriteria)DefaultModelCriteria.criteria().compare(PermissionTicket.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        return resourceServer == null ? mcb : (DefaultModelCriteria)mcb.compare(PermissionTicket.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resourceServer.getId()});
    }

    public long count(ResourceServer resourceServer, Map<PermissionTicket.FilterOption, String> attributes) {
        DefaultModelCriteria mcb = (DefaultModelCriteria)this.forRealmAndResourceServer(resourceServer.getRealm(), resourceServer).and((DefaultModelCriteria[])attributes.entrySet().stream().map(this::filterEntryToDefaultModelCriteria).toArray(DefaultModelCriteria[]::new));
        RealmModel realm = resourceServer.getRealm();
        return this.txInRealm(realm).getCount(QueryParameters.withCriteria(mcb));
    }

    public PermissionTicket create(ResourceServer resourceServer, Resource resource, Scope scope, String requester) {
        LOG.tracef("create(%s, %s, %s, %s)%s", new Object[]{resource, scope, requester, resourceServer, StackUtil.getShortStackTrace()});
        RealmModel realm = resourceServer.getRealm();
        String owner = this.authorizationProvider.getStoreFactory().getResourceStore().findById(realm, resourceServer, resource.getId()).getOwner();
        DefaultModelCriteria mcb = (DefaultModelCriteria)((DefaultModelCriteria)((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(PermissionTicket.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{owner})).compare(PermissionTicket.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resource.getId()})).compare(PermissionTicket.SearchableFields.REQUESTER, ModelCriteriaBuilder.Operator.EQ, new Object[]{requester});
        if (scope != null) {
            mcb = (DefaultModelCriteria)mcb.compare(PermissionTicket.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{scope.getId()});
        }
        if (this.txInRealm(realm).exists(QueryParameters.withCriteria(mcb))) {
            throw new ModelDuplicateException("Permission ticket for resource server: '" + resourceServer.getId() + ", Resource: " + resource + ", owner: " + owner + ", scopeId: " + scope + " already exists.");
        }
        MapPermissionTicketEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapPermissionTicketEntity.class);
        entity.setResourceId(resource.getId());
        entity.setRequester(requester);
        entity.setCreatedTimestamp(Time.currentTimeMillis());
        if (scope != null) {
            entity.setScopeId(scope.getId());
        }
        entity.setOwner(owner);
        entity.setResourceServerId(resourceServer.getId());
        entity.setRealmId(realm.getId());
        entity = this.txInRealm(realm).create(entity);
        return entity == null ? null : this.entityToAdapterFunc(realm, resourceServer).apply(entity);
    }

    public void delete(RealmModel realm, String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        PermissionTicket permissionTicket = this.findById(realm, null, id);
        if (permissionTicket == null) {
            return;
        }
        this.txInRealm(realm).delete(id);
        UserManagedPermissionUtil.removePolicy((PermissionTicket)permissionTicket, (StoreFactory)this.authorizationProvider.getStoreFactory());
    }

    public PermissionTicket findById(RealmModel realm, ResourceServer resourceServer, String id) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServer, StackUtil.getShortStackTrace());
        if (id == null) {
            return null;
        }
        return this.txInRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(PermissionTicket.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{id}))).findFirst().map(this.entityToAdapterFunc(realm, resourceServer)).orElse(null);
    }

    public List<PermissionTicket> findByResource(ResourceServer resourceServer, Resource resource) {
        LOG.tracef("findByResource(%s, %s)%s", (Object)resource, (Object)resourceServer, StackUtil.getShortStackTrace());
        RealmModel realm = resourceServer.getRealm();
        return this.txInRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(PermissionTicket.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{resource.getId()}))).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    public List<PermissionTicket> findByScope(ResourceServer resourceServer, Scope scope) {
        LOG.tracef("findByScope(%s, %s)%s", (Object)scope, (Object)resourceServer, StackUtil.getShortStackTrace());
        RealmModel realm = resourceServer.getRealm();
        return this.txInRealm(realm).read(QueryParameters.withCriteria((DefaultModelCriteria)this.forRealmAndResourceServer(realm, resourceServer).compare(PermissionTicket.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{scope.getId()}))).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    public List<PermissionTicket> find(RealmModel realm, ResourceServer resourceServer, Map<PermissionTicket.FilterOption, String> attributes, Integer firstResult, Integer maxResult) {
        DefaultModelCriteria mcb = this.forRealmAndResourceServer(realm, resourceServer);
        if (attributes.containsKey(PermissionTicket.FilterOption.RESOURCE_NAME)) {
            String expectedResourceName = attributes.remove(PermissionTicket.FilterOption.RESOURCE_NAME);
            EnumMap<Resource.FilterOption, String[]> filterOptionStringMap = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
            filterOptionStringMap.put(Resource.FilterOption.EXACT_NAME, new String[]{expectedResourceName});
            List r = this.authorizationProvider.getStoreFactory().getResourceStore().find(realm, resourceServer, filterOptionStringMap, null, null);
            if (r == null || r.isEmpty()) {
                return Collections.emptyList();
            }
            mcb = (DefaultModelCriteria)mcb.compare(PermissionTicket.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.IN, new Object[]{r.stream().map(Resource::getId)});
        }
        mcb = (DefaultModelCriteria)mcb.and((DefaultModelCriteria[])attributes.entrySet().stream().map(this::filterEntryToDefaultModelCriteria).toArray(DefaultModelCriteria[]::new));
        return this.txInRealm(realm).read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResult, PermissionTicket.SearchableFields.ID)).map(this.entityToAdapterFunc(realm, resourceServer)).collect(Collectors.toList());
    }

    private DefaultModelCriteria<PermissionTicket> filterEntryToDefaultModelCriteria(Map.Entry<PermissionTicket.FilterOption, String> entry) {
        PermissionTicket.FilterOption name = entry.getKey();
        String value = entry.getValue();
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        switch (name) {
            case ID: 
            case SCOPE_ID: 
            case RESOURCE_ID: 
            case OWNER: 
            case REQUESTER: 
            case POLICY_ID: {
                return (DefaultModelCriteria)mcb.compare(name.getSearchableModelField(), ModelCriteriaBuilder.Operator.EQ, new Object[]{value});
            }
            case SCOPE_IS_NULL: 
            case GRANTED: 
            case REQUESTER_IS_NULL: {
                ModelCriteriaBuilder.Operator op = ModelCriteriaBuilder.Operator.NOT_EXISTS;
                if (Boolean.parseBoolean(value)) {
                    op = ModelCriteriaBuilder.Operator.EXISTS;
                }
                return (DefaultModelCriteria)mcb.compare(name.getSearchableModelField(), op, new Object[0]);
            }
            case POLICY_IS_NOT_NULL: {
                return (DefaultModelCriteria)mcb.compare(PermissionTicket.SearchableFields.REQUESTER, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
            }
        }
        throw new IllegalArgumentException("Unsupported filter [" + name + "]");
    }

    public List<PermissionTicket> findGranted(ResourceServer resourceServer, String userId) {
        EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
        filters.put(PermissionTicket.FilterOption.GRANTED, Boolean.TRUE.toString());
        filters.put(PermissionTicket.FilterOption.REQUESTER, userId);
        return this.find(resourceServer.getRealm(), resourceServer, filters, null, null);
    }

    public List<PermissionTicket> findGranted(ResourceServer resourceServer, String resourceName, String userId) {
        EnumMap<PermissionTicket.FilterOption, String> filters = new EnumMap<PermissionTicket.FilterOption, String>(PermissionTicket.FilterOption.class);
        filters.put(PermissionTicket.FilterOption.RESOURCE_NAME, resourceName);
        filters.put(PermissionTicket.FilterOption.GRANTED, Boolean.TRUE.toString());
        filters.put(PermissionTicket.FilterOption.REQUESTER, userId);
        return this.find(resourceServer.getRealm(), resourceServer, filters, null, null);
    }

    public List<Resource> findGrantedResources(RealmModel realm, String requester, String name, Integer first, Integer max) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(PermissionTicket.SearchableFields.REQUESTER, ModelCriteriaBuilder.Operator.EQ, new Object[]{requester})).compare(PermissionTicket.SearchableFields.GRANTED_TIMESTAMP, ModelCriteriaBuilder.Operator.EXISTS, new Object[0])).compare(PermissionTicket.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        ResourceStore resourceStore = this.authorizationProvider.getStoreFactory().getResourceStore();
        ResourceServerStore resourceServerStore = this.authorizationProvider.getStoreFactory().getResourceServerStore();
        Function<MapPermissionTicketEntity, Resource> ticketResourceMapper = name != null ? ticket -> {
            EnumMap<Resource.FilterOption, String[]> filterOptionMap = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
            filterOptionMap.put(Resource.FilterOption.ID, new String[]{ticket.getResourceId()});
            filterOptionMap.put(Resource.FilterOption.NAME, new String[]{name});
            List resource = resourceStore.find(realm, resourceServerStore.findById(realm, ticket.getResourceServerId()), filterOptionMap, Integer.valueOf(-1), Integer.valueOf(1));
            return resource.isEmpty() ? null : (Resource)resource.get(0);
        } : ticket -> resourceStore.findById(realm, resourceServerStore.findById(realm, ticket.getResourceServerId()), ticket.getResourceId());
        return StreamsUtil.paginatedStream(this.txInRealm(realm).read(QueryParameters.withCriteria(mcb).orderBy(PermissionTicket.SearchableFields.RESOURCE_ID, QueryParameters.Order.ASCENDING)).filter(StreamsUtil.distinctByKey(MapPermissionTicketEntity::getResourceId)).map(ticketResourceMapper).filter(Objects::nonNull), (Integer)first, (Integer)max).collect(Collectors.toList());
    }

    public List<Resource> findGrantedOwnerResources(RealmModel realm, String owner, Integer firstResult, Integer maxResults) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(PermissionTicket.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, new Object[]{owner})).compare(PermissionTicket.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        ResourceStore resourceStore = this.authorizationProvider.getStoreFactory().getResourceStore();
        ResourceServerStore resourceServerStore = this.authorizationProvider.getStoreFactory().getResourceServerStore();
        return StreamsUtil.paginatedStream(this.txInRealm(realm).read(QueryParameters.withCriteria(mcb).orderBy(PermissionTicket.SearchableFields.RESOURCE_ID, QueryParameters.Order.ASCENDING)).filter(StreamsUtil.distinctByKey(MapPermissionTicketEntity::getResourceId)), (Integer)firstResult, (Integer)maxResults).map(ticket -> resourceStore.findById(realm, resourceServerStore.findById(realm, ticket.getResourceServerId()), ticket.getResourceId())).collect(Collectors.toList());
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(PermissionTicket.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.txInRealm(realm).delete(QueryParameters.withCriteria(mcb));
    }

    public void preRemove(RealmModel realm, ResourceServer resourceServer) {
        LOG.tracef("preRemove(%s, %s)%s", (Object)realm, (Object)resourceServer, StackUtil.getShortStackTrace());
        this.txInRealm(realm).delete(QueryParameters.withCriteria(this.forRealmAndResourceServer(resourceServer.getRealm(), resourceServer)));
    }
}

