/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.role;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.HasRealmId;
import org.keycloak.models.map.role.MapRoleAdapter;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.provider.InvalidationHandler;

public class MapRoleProvider
implements RoleProvider {
    private static final Logger LOG = Logger.getLogger(MapRoleProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<MapRoleEntity, RoleModel> tx;
    private final boolean txHasRealmId;

    public MapRoleProvider(KeycloakSession session, MapStorage<MapRoleEntity, RoleModel> roleStore) {
        this.session = session;
        this.tx = roleStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
        this.txHasRealmId = this.tx instanceof HasRealmId;
    }

    private Function<MapRoleEntity, RoleModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapRoleAdapter(this.session, realm, (MapRoleEntity)origEntity);
    }

    private MapKeycloakTransaction<MapRoleEntity, RoleModel> txInRealm(RealmModel realm) {
        if (this.txHasRealmId) {
            ((HasRealmId)((Object)this.tx)).setRealmId(realm == null ? null : realm.getId());
        }
        return this.tx;
    }

    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        if (this.getRealmRole(realm, name) != null) {
            throw new ModelDuplicateException("Role with the same name exists: " + name + " for realm " + realm.getName());
        }
        LOG.tracef("addRealmRole(%s, %s, %s)%s", new Object[]{realm, id, name, StackUtil.getShortStackTrace()});
        MapRoleEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapRoleEntity.class);
        entity.setId(id);
        entity.setRealmId(realm.getId());
        entity.setName(name);
        if (entity.getId() != null && this.txInRealm(realm).exists(entity.getId())) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        entity = this.txInRealm(realm).create(entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm, Integer first, Integer max) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        return this.txInRealm(realm).read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<RoleModel> getRolesStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        LOG.tracef("getRolesStream(%s, %s, %s, %d, %d)%s", new Object[]{realm, ids, search, first, max, StackUtil.getShortStackTrace()});
        if (ids == null) {
            return Stream.empty();
        }
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.IN, new Object[]{ids})).compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (search != null) {
            mcb = (DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"});
        }
        return this.txInRealm(realm).read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        return this.txInRealm(realm).read(QueryParameters.withCriteria(mcb).orderBy(RoleModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(realm));
    }

    public RoleModel addClientRole(ClientModel client, String id, String name) {
        if (this.getClientRole(client, name) != null) {
            throw new ModelDuplicateException("Role with the same name exists: " + name + " for client " + client.getClientId());
        }
        LOG.tracef("addClientRole(%s, %s, %s)%s", new Object[]{client, id, name, StackUtil.getShortStackTrace()});
        MapRoleEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapRoleEntity.class);
        RealmModel realm = client.getRealm();
        entity.setId(id);
        entity.setRealmId(realm.getId());
        entity.setName(name);
        entity.setClientId(client.getId());
        if (entity.getId() != null && this.txInRealm(realm).exists(entity.getId())) {
            throw new ModelDuplicateException("Role exists: " + id);
        }
        entity = this.txInRealm(realm).create(entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client, Integer first, Integer max) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        RealmModel realm = client.getRealm();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        return this.txInRealm(realm).read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        RealmModel realm = client.getRealm();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        return this.txInRealm(realm).read(QueryParameters.withCriteria(mcb).orderBy(RoleModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(realm));
    }

    public boolean removeRole(RoleModel role) {
        LOG.tracef("removeRole(%s)%s", (Object)role, StackUtil.getShortStackTrace());
        RealmModel realm = role.isClientRole() ? ((ClientModel)role.getContainer()).getRealm() : (RealmModel)role.getContainer();
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.ROLE_BEFORE_REMOVE, new Object[]{realm, role});
        this.txInRealm(realm).delete(role.getId());
        this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.ROLE_AFTER_REMOVE, new Object[]{realm, role});
        return true;
    }

    public void removeRoles(RealmModel realm) {
        this.getRealmRolesStream(realm).forEach(this::removeRole);
    }

    public void removeRoles(ClientModel client) {
        this.getClientRolesStream(client).forEach(this::removeRole);
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getRealmRole(%s, %s)%s", (Object)realm, (Object)name, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0])).compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name});
        return this.txInRealm(realm).read(QueryParameters.withCriteria(mcb)).map(this.entityToAdapterFunc(realm)).findFirst().orElse(null);
    }

    public RoleModel getClientRole(ClientModel client, String name) {
        if (name == null) {
            return null;
        }
        LOG.tracef("getClientRole(%s, %s)%s", (Object)client, (Object)name, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        RealmModel realm = client.getRealm();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()})).compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{name});
        return this.txInRealm(realm).read(QueryParameters.withCriteria(mcb)).map(this.entityToAdapterFunc(realm)).findFirst().orElse(null);
    }

    public RoleModel getRoleById(RealmModel realm, String id) {
        if (id == null || realm == null || realm.getId() == null) {
            return null;
        }
        LOG.tracef("getRoleById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        MapRoleEntity entity = this.txInRealm(realm).read(id);
        String realmId = realm.getId();
        return entity == null || entity.getRealmId() != null && !Objects.equals(realmId, entity.getRealmId()) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public Stream<RoleModel> searchForRolesStream(RealmModel realm, String search, Integer first, Integer max) {
        if (search == null) {
            return Stream.empty();
        }
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0])).or(new DefaultModelCriteria[]{(DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"}), (DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.DESCRIPTION, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"})});
        return this.txInRealm(realm).read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<RoleModel> searchForClientRolesStream(ClientModel client, String search, Integer first, Integer max) {
        if (search == null) {
            return Stream.empty();
        }
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        RealmModel realm = client.getRealm();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()})).or(new DefaultModelCriteria[]{(DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"}), (DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.DESCRIPTION, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%" + search + "%"})});
        return this.txInRealm(realm).read(QueryParameters.withCriteria(mcb).pagination(first, max, RoleModel.SearchableFields.NAME)).map(this.entityToAdapterFunc(realm));
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.txInRealm(realm).delete(QueryParameters.withCriteria(mcb));
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        mcb = (DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(RoleModel.SearchableFields.COMPOSITE_ROLE, ModelCriteriaBuilder.Operator.EQ, new Object[]{role.getId()});
        this.txInRealm(realm).read(QueryParameters.withCriteria(mcb)).forEach(mapRoleEntity -> mapRoleEntity.removeCompositeRole(role.getId()));
    }

    public void close() {
    }
}

