/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.restclient.IClient;
import com.openshift.restclient.api.models.ITypeMeta;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeRegistry.class);
    private static final String RESOURCE_NAME = "k8stypes.properties";
    private static TypeRegistry instance;
    private Map<String, Class<?>> registeredTypes = new HashMap();

    public static final TypeRegistry getInstance() {
        if (instance == null) {
            instance = new TypeRegistry();
        }
        return instance;
    }

    private TypeRegistry() {
        this.load();
    }

    private void load() {
        try {
            Enumeration<URL> urls = TypeRegistry.class.getClassLoader().getResources(RESOURCE_NAME);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try {
                    InputStream is = url.openStream();
                    try {
                        this.load(is);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Can't load resource from " + url, (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Can't load resources from k8stypes.properties", (Throwable)e);
        }
    }

    private void load(InputStream stream) throws IOException {
        Properties p = new Properties();
        p.load(stream);
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            try {
                String className = (String)entry.getKey();
                Class<?> clazz = Class.forName(className);
                if (!this.check(clazz)) continue;
                String types = (String)entry.getValue();
                for (String type : types.split(",")) {
                    this.registeredTypes.put(type, clazz);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Can't load class", (Throwable)e);
            }
        }
    }

    private boolean check(Class<?> clazz) {
        boolean valid = false;
        if (IResource.class.isAssignableFrom(clazz)) {
            try {
                clazz.getConstructor(ModelNode.class, IClient.class, Map.class);
                valid = true;
            }
            catch (NoSuchMethodException | SecurityException e) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
        } else if (ITypeMeta.class.isAssignableFrom(clazz)) {
            try {
                clazz.getConstructor(ModelNode.class, Map.class);
                valid = true;
            }
            catch (NoSuchMethodException | SecurityException e) {
                LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return valid;
    }

    public Class<?> getRegisteredType(String kind) {
        return this.registeredTypes.get(kind);
    }
}

