/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient.utils;

import java.security.AlgorithmParameterGenerator;
import java.security.InvalidParameterException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SSLUtils {
    private static final String SSL_CONTEXT_NAME = "SSL";
    public static final String CIPHER_DHE_REGEX = ".*_DHE_.*";
    private static final String CIPHER_DHE_NAME = "DiffieHellman";
    private static final int CIPHER_DHE_MINSIZE = 512;
    private static final int CIPHER_DHE_MAXSIZE = 16384;
    private static final int CIPHER_DHE_MODULO = 64;

    private SSLUtils() {
    }

    public static boolean supportsDHECipherKeysOf(int length) {
        try {
            return SSLUtils.isMaxKeysize(length, 512, 16384, 64, AlgorithmParameterGenerator.getInstance(CIPHER_DHE_NAME));
        }
        catch (NoSuchAlgorithmException e1) {
            return false;
        }
    }

    private static boolean isMaxKeysize(int length, int minSize, int maxSize, int modulo, AlgorithmParameterGenerator algorithmParamGen) {
        int maxLength = 0;
        for (int i = minSize; i <= maxSize; i += modulo) {
            try {
                algorithmParamGen.init(i);
            }
            catch (InvalidParameterException e) {
                break;
            }
            maxLength = i;
        }
        return maxLength >= length;
    }

    public static final String[] filterCiphers(String excludedCipherRegex, String[] ciphers) {
        if (excludedCipherRegex == null || ciphers == null) {
            return ciphers;
        }
        ArrayList<String> filteredCiphers = new ArrayList<String>();
        for (String cipher : ciphers) {
            if (cipher.matches(excludedCipherRegex)) continue;
            filteredCiphers.add(cipher);
        }
        return filteredCiphers.toArray(new String[filteredCiphers.size()]);
    }

    public static SSLContext getSSLContext(TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustManagers = null;
        if (trustManager != null) {
            trustManagers = new TrustManager[]{trustManager};
        }
        SSLContext sslContext = SSLContext.getInstance(SSL_CONTEXT_NAME);
        sslContext.init(null, trustManagers, null);
        return sslContext;
    }
}

