/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.federated;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.Provider;
import org.keycloak.storage.federated.UserAttributeFederatedStorage;
import org.keycloak.storage.federated.UserBrokerLinkFederatedStorage;
import org.keycloak.storage.federated.UserConsentFederatedStorage;
import org.keycloak.storage.federated.UserFederatedUserCredentialStore;
import org.keycloak.storage.federated.UserGroupMembershipFederatedStorage;
import org.keycloak.storage.federated.UserNotBeforeFederatedStorage;
import org.keycloak.storage.federated.UserRequiredActionsFederatedStorage;
import org.keycloak.storage.federated.UserRoleMappingsFederatedStorage;

public interface UserFederatedStorageProvider
extends Provider,
UserAttributeFederatedStorage,
UserBrokerLinkFederatedStorage,
UserConsentFederatedStorage,
UserNotBeforeFederatedStorage,
UserGroupMembershipFederatedStorage,
UserRequiredActionsFederatedStorage,
UserRoleMappingsFederatedStorage,
UserFederatedUserCredentialStore {
    @Deprecated
    public List<String> getStoredUsers(RealmModel var1, int var2, int var3);

    default public Stream<String> getStoredUsersStream(RealmModel realm, Integer first, Integer max) {
        List<String> value = this.getStoredUsers(realm, first, max);
        return value != null ? value.stream() : Stream.empty();
    }

    public int getStoredUsersCount(RealmModel var1);

    public void preRemove(RealmModel var1);

    public void preRemove(RealmModel var1, GroupModel var2);

    public void preRemove(RealmModel var1, RoleModel var2);

    public void preRemove(RealmModel var1, ClientModel var2);

    public void preRemove(ProtocolMapperModel var1);

    public void preRemove(ClientScopeModel var1);

    public void preRemove(RealmModel var1, UserModel var2);

    public void preRemove(RealmModel var1, ComponentModel var2);

    public static interface Streams
    extends UserFederatedStorageProvider,
    UserAttributeFederatedStorage.Streams,
    UserBrokerLinkFederatedStorage.Streams,
    UserConsentFederatedStorage.Streams,
    UserFederatedUserCredentialStore.Streams,
    UserGroupMembershipFederatedStorage.Streams,
    UserRequiredActionsFederatedStorage.Streams,
    UserRoleMappingsFederatedStorage.Streams {
        @Override
        default public List<String> getStoredUsers(RealmModel realm, int first, int max) {
            return this.getStoredUsersStream(realm, first, max).collect(Collectors.toList());
        }

        @Override
        public Stream<String> getStoredUsersStream(RealmModel var1, Integer var2, Integer var3);
    }
}

