/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.export;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.export.JsonMeterRegistryProvider;
import io.quarkus.micrometer.runtime.export.JsonRecorder;
import io.quarkus.micrometer.runtime.registry.json.JsonMeterRegistry;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.vertx.core.Handler;
import java.util.function.BooleanSupplier;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={JsonRegistryEnabled.class})
public class JsonRegistryProcessor {
    private static final Logger log = Logger.getLogger(JsonRegistryProcessor.class);

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void initializeJsonRegistry(MicrometerConfig config, BuildProducer<MicrometerRegistryProviderBuildItem> registryProviders, BuildProducer<RouteBuildItem> routes, BuildProducer<AdditionalBeanBuildItem> additionalBeans, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, JsonRecorder recorder) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(JsonMeterRegistryProvider.class).setUnremovable().build());
        registryProviders.produce((BuildItem)new MicrometerRegistryProviderBuildItem(JsonMeterRegistry.class));
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().routeFunction(config.export.json.path, recorder.route()).routeConfigKey("quarkus.micrometer.export.json.path").handler((Handler)recorder.getHandler()).blockingRoute().build());
        log.debug((Object)("Initialized a JSON meter registry on path=" + nonApplicationRootPathBuildItem.resolvePath(config.export.json.path)));
    }

    public static class JsonRegistryEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        @Override
        public boolean getAsBoolean() {
            return this.mConfig.checkRegistryEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.export.json);
        }
    }
}

