/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.Transformation;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public interface AnnotationsTransformer
extends BuildExtension {
    default public boolean appliesTo(AnnotationTarget.Kind kind) {
        return true;
    }

    public void transform(TransformationContext var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int priority = 1000;
        private Predicate<AnnotationTarget.Kind> appliesTo;
        private Predicate<TransformationContext> predicate;

        private Builder() {
        }

        public Builder appliesTo(AnnotationTarget.Kind appliesToKind) {
            return this.appliesTo((AnnotationTarget.Kind kind) -> kind == appliesToKind);
        }

        public Builder appliesTo(Predicate<AnnotationTarget.Kind> appliesTo) {
            this.appliesTo = appliesTo;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder whenContainsAll(List<DotName> annotationNames) {
            return this.when(context -> {
                for (DotName annotationName : annotationNames) {
                    if (Annotations.contains(context.getAnnotations(), annotationName)) continue;
                    return false;
                }
                return true;
            });
        }

        public Builder whenContainsAll(DotName ... annotationNames) {
            return this.whenContainsAll(List.of(annotationNames));
        }

        @SafeVarargs
        public final Builder whenContainsAll(Class<? extends Annotation> ... annotationNames) {
            return this.whenContainsAll(Arrays.stream(annotationNames).map(a -> DotName.createSimple((String)a.getName())).collect(Collectors.toList()));
        }

        public Builder whenContainsAny(List<DotName> annotationNames) {
            return this.when(context -> Annotations.containsAny(context.getAnnotations(), annotationNames));
        }

        public Builder whenContainsAny(DotName ... annotationNames) {
            return this.whenContainsAny(List.of(annotationNames));
        }

        @SafeVarargs
        public final Builder whenContainsAny(Class<? extends Annotation> ... annotationNames) {
            return this.whenContainsAny(Arrays.stream(annotationNames).map(a -> DotName.createSimple((String)a.getName())).collect(Collectors.toList()));
        }

        public Builder whenContainsNone(List<DotName> annotationNames) {
            return this.when(context -> !Annotations.containsAny(context.getAnnotations(), annotationNames));
        }

        public Builder whenContainsNone(DotName ... annotationNames) {
            return this.whenContainsNone(List.of(annotationNames));
        }

        @SafeVarargs
        public final Builder whenContainsNone(Class<? extends Annotation> ... annotationNames) {
            return this.whenContainsNone(Arrays.stream(annotationNames).map(a -> DotName.createSimple((String)a.getName())).collect(Collectors.toList()));
        }

        public Builder when(Predicate<TransformationContext> when) {
            this.predicate = this.predicate == null ? when : this.predicate.and(when);
            return this;
        }

        public AnnotationsTransformer transform(Consumer<TransformationContext> consumer) {
            final Predicate<AnnotationTarget.Kind> appliesTo = this.appliesTo;
            final int priority = this.priority;
            final Consumer<TransformationContext> transform = Objects.requireNonNull(consumer);
            final Predicate<TransformationContext> predicate = this.predicate;
            return new AnnotationsTransformer(){

                @Override
                public int getPriority() {
                    return priority;
                }

                @Override
                public boolean appliesTo(AnnotationTarget.Kind kind) {
                    return appliesTo != null ? appliesTo.test(kind) : true;
                }

                @Override
                public void transform(TransformationContext context) {
                    if (predicate == null || predicate.test(context)) {
                        transform.accept(context);
                    }
                }
            };
        }
    }

    public static interface TransformationContext
    extends BuildExtension.BuildContext {
        public AnnotationTarget getTarget();

        public Collection<AnnotationInstance> getAnnotations();

        public Transformation transform();

        default public boolean isClass() {
            return this.getTarget().kind() == AnnotationTarget.Kind.CLASS;
        }

        default public boolean isField() {
            return this.getTarget().kind() == AnnotationTarget.Kind.FIELD;
        }

        default public boolean isMethod() {
            return this.getTarget().kind() == AnnotationTarget.Kind.METHOD;
        }
    }
}

