/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration;

import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.security.cert.X509Certificate;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.services.HttpRequestImpl;

public class QuarkusHttpRequest
extends HttpRequestImpl {
    public <R> QuarkusHttpRequest(HttpRequest delegate) {
        super(delegate);
    }

    public X509Certificate[] getClientCertificateChain() {
        Instance instances = CDI.current().select(RoutingContext.class, new Annotation[0]);
        if (instances.isResolvable()) {
            RoutingContext context = (RoutingContext)instances.get();
            try {
                SSLSession sslSession = context.request().sslSession();
                if (sslSession == null) {
                    return null;
                }
                return (X509Certificate[])sslSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return null;
    }
}

