/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.traces;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.InstrumentationScopeMarshaller;
import io.opentelemetry.exporter.internal.otlp.ResourceMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.InstrumentationScopeSpansMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanMarshaler;
import io.opentelemetry.proto.trace.v1.internal.ResourceSpans;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ResourceSpansMarshaler
extends MarshalerWithSize {
    private final ResourceMarshaler resourceMarshaler;
    private final byte[] schemaUrlUtf8;
    private final InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalers;

    public static ResourceSpansMarshaler[] create(Collection<SpanData> spanDataList) {
        Map<Resource, Map<InstrumentationScopeInfo, List<SpanMarshaler>>> resourceAndScopeMap = ResourceSpansMarshaler.groupByResourceAndScope(spanDataList);
        ResourceSpansMarshaler[] resourceSpansMarshalers = new ResourceSpansMarshaler[resourceAndScopeMap.size()];
        int posResource = 0;
        for (Map.Entry<Resource, Map<InstrumentationScopeInfo, List<SpanMarshaler>>> entry : resourceAndScopeMap.entrySet()) {
            InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalers = new InstrumentationScopeSpansMarshaler[entry.getValue().size()];
            int posInstrumentation = 0;
            for (Map.Entry<InstrumentationScopeInfo, List<SpanMarshaler>> entryIs : entry.getValue().entrySet()) {
                instrumentationScopeSpansMarshalers[posInstrumentation++] = new InstrumentationScopeSpansMarshaler(InstrumentationScopeMarshaller.create(entryIs.getKey()), MarshalerUtil.toBytes((String)entryIs.getKey().getSchemaUrl()), entryIs.getValue());
            }
            resourceSpansMarshalers[posResource++] = new ResourceSpansMarshaler(ResourceMarshaler.create(entry.getKey()), MarshalerUtil.toBytes((String)entry.getKey().getSchemaUrl()), instrumentationScopeSpansMarshalers);
        }
        return resourceSpansMarshalers;
    }

    ResourceSpansMarshaler(ResourceMarshaler resourceMarshaler, byte[] schemaUrlUtf8, InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalers) {
        super(ResourceSpansMarshaler.calculateSize(resourceMarshaler, schemaUrlUtf8, instrumentationScopeSpansMarshalers));
        this.resourceMarshaler = resourceMarshaler;
        this.schemaUrlUtf8 = schemaUrlUtf8;
        this.instrumentationScopeSpansMarshalers = instrumentationScopeSpansMarshalers;
    }

    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(ResourceSpans.RESOURCE, (Marshaler)this.resourceMarshaler);
        output.serializeRepeatedMessage(ResourceSpans.SCOPE_SPANS, (Marshaler[])this.instrumentationScopeSpansMarshalers);
        output.serializeString(ResourceSpans.SCHEMA_URL, this.schemaUrlUtf8);
    }

    private static int calculateSize(ResourceMarshaler resourceMarshaler, byte[] schemaUrlUtf8, InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage((ProtoFieldInfo)ResourceSpans.RESOURCE, (Marshaler)resourceMarshaler);
        size += MarshalerUtil.sizeBytes((ProtoFieldInfo)ResourceSpans.SCHEMA_URL, (byte[])schemaUrlUtf8);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ResourceSpans.SCOPE_SPANS, (Marshaler[])instrumentationScopeSpansMarshalers);
    }

    private static Map<Resource, Map<InstrumentationScopeInfo, List<SpanMarshaler>>> groupByResourceAndScope(Collection<SpanData> spanDataList) {
        return MarshalerUtil.groupByResourceAndScope(spanDataList, SpanData::getResource, SpanData::getInstrumentationScopeInfo, SpanMarshaler::create);
    }
}

