/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.marshall.core.Ids;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.util.logging.Log;
import org.jgroups.util.UUID;

public class SyncConsistentHashFactory
implements ConsistentHashFactory<DefaultConsistentHash> {
    @Override
    public DefaultConsistentHash create(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        this.checkCapacityFactors(members, capacityFactors);
        Builder builder = this.createBuilder(numOwners, numSegments, members, capacityFactors);
        builder.populateOwners();
        return new DefaultConsistentHash(numOwners, numSegments, members, capacityFactors, builder.segmentOwners);
    }

    @Override
    public DefaultConsistentHash fromPersistentState(ScopedPersistentState state) {
        String consistentHashClass = state.getProperty("consistentHash");
        if (!DefaultConsistentHash.class.getName().equals(consistentHashClass)) {
            throw Log.CONTAINER.persistentConsistentHashMismatch(this.getClass().getName(), consistentHashClass);
        }
        return new DefaultConsistentHash(state);
    }

    Builder createBuilder(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        return new Builder(numOwners, numSegments, members, capacityFactors);
    }

    void checkCapacityFactors(List<Address> members, Map<Address, Float> capacityFactors) {
        if (capacityFactors != null) {
            float totalCapacity = 0.0f;
            for (Address node : members) {
                Float capacityFactor = capacityFactors.get(node);
                if (capacityFactor == null || capacityFactor.floatValue() < 0.0f) {
                    throw new IllegalArgumentException("Invalid capacity factor for node " + node + ": " + capacityFactor);
                }
                totalCapacity += capacityFactor.floatValue();
            }
            if (totalCapacity == 0.0f) {
                throw new IllegalArgumentException("There must be at least one node with a non-zero capacity factor");
            }
        }
    }

    @Override
    public DefaultConsistentHash updateMembers(DefaultConsistentHash baseCH, List<Address> newMembers, Map<Address, Float> actualCapacityFactors) {
        boolean sameCapacityFactors;
        this.checkCapacityFactors(newMembers, actualCapacityFactors);
        boolean bl = actualCapacityFactors == null ? baseCH.getCapacityFactors() == null : (sameCapacityFactors = actualCapacityFactors.equals(baseCH.getCapacityFactors()));
        if (newMembers.equals(baseCH.getMembers()) && sameCapacityFactors) {
            return baseCH;
        }
        int numSegments = baseCH.getNumSegments();
        int numOwners = baseCH.getNumOwners();
        HashSet<Address> leavers = new HashSet<Address>(baseCH.getMembers());
        leavers.removeAll(newMembers);
        ConsistentHash rebalancedCH = null;
        List[] newSegmentOwners = new List[numSegments];
        for (int s = 0; s < numSegments; ++s) {
            ArrayList<Address> owners = new ArrayList<Address>(baseCH.locateOwnersForSegment(s));
            owners.removeAll(leavers);
            if (!owners.isEmpty()) {
                newSegmentOwners[s] = owners;
                continue;
            }
            if (rebalancedCH == null) {
                rebalancedCH = this.create(numOwners, numSegments, (List)newMembers, (Map)actualCapacityFactors);
            }
            newSegmentOwners[s] = rebalancedCH.locateOwnersForSegment(s);
        }
        return new DefaultConsistentHash(numOwners, numSegments, newMembers, actualCapacityFactors, newSegmentOwners);
    }

    @Override
    public DefaultConsistentHash rebalance(DefaultConsistentHash baseCH) {
        ConsistentHash rebalancedCH = this.create(baseCH.getNumOwners(), baseCH.getNumSegments(), (List)baseCH.getMembers(), (Map)baseCH.getCapacityFactors());
        if (((DefaultConsistentHash)rebalancedCH).equals(baseCH)) {
            return baseCH;
        }
        return rebalancedCH;
    }

    @Override
    public DefaultConsistentHash union(DefaultConsistentHash ch1, DefaultConsistentHash ch2) {
        return ch1.union(ch2);
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass();
    }

    public int hashCode() {
        return -10007;
    }

    public static class Externalizer
    extends AbstractExternalizer<SyncConsistentHashFactory> {
        public void writeObject(ObjectOutput output, SyncConsistentHashFactory chf) {
        }

        public SyncConsistentHashFactory readObject(ObjectInput unmarshaller) {
            return new SyncConsistentHashFactory();
        }

        public Integer getId() {
            return Ids.SYNC_CONSISTENT_HASH_FACTORY;
        }

        public Set<Class<? extends SyncConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(SyncConsistentHashFactory.class);
        }
    }

    static class Builder {
        static final int NO_NODE = -1;
        final int numOwners;
        final int numSegments;
        final List<Address>[] segmentOwners;
        final int[][] ownerIndices;
        final List<Address> sortedMembers;
        final int numNodes;
        final float[] sortedCapacityFactors;
        final float[] distanceFactors;
        final float totalCapacity;
        final int actualNumOwners;
        final int numNodeHashes;
        final long segmentSize;
        final long[] segmentHashes;
        final long[][] nodeHashes;
        int nodeDistanceUpdates;
        final OwnershipStatistics stats;

        Builder(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
            this.numSegments = numSegments;
            this.numOwners = numOwners;
            this.sortedMembers = this.sortMembersByCapacity(members, capacityFactors);
            this.sortedCapacityFactors = this.capacityFactorsToArray(this.sortedMembers, capacityFactors);
            this.totalCapacity = this.computeTotalCapacity();
            this.numNodes = this.sortedMembers.size();
            this.actualNumOwners = Math.min(numOwners, this.numNodes);
            this.distanceFactors = this.capacityFactorsToDistanceFactors();
            this.segmentOwners = new List[numSegments];
            this.ownerIndices = new int[numSegments][];
            for (int s = 0; s < numSegments; ++s) {
                this.segmentOwners[s] = new ArrayList<Address>(this.actualNumOwners);
                this.ownerIndices[s] = new int[this.actualNumOwners];
            }
            this.segmentSize = Long.MAX_VALUE / (long)numSegments;
            this.segmentHashes = this.computeSegmentHashes(numSegments);
            this.numNodeHashes = 32 - Integer.numberOfLeadingZeros(numSegments);
            this.nodeHashes = this.computeNodeHashes();
            this.stats = new OwnershipStatistics(this.sortedMembers);
        }

        private float[] capacityFactorsToDistanceFactors() {
            float minCapacity = this.sortedCapacityFactors[this.numNodes - 1];
            float[] distanceFactors = new float[this.numNodes];
            for (int n = 0; n < this.numNodes; ++n) {
                distanceFactors[n] = minCapacity / this.sortedCapacityFactors[n];
            }
            return distanceFactors;
        }

        private float[] capacityFactorsToArray(List<Address> sortedMembers, Map<Address, Float> capacityFactors) {
            float[] capacityFactorsArray = new float[sortedMembers.size()];
            for (int n = 0; n < sortedMembers.size(); ++n) {
                capacityFactorsArray[n] = capacityFactors != null ? capacityFactors.get(sortedMembers.get(n)).floatValue() : 1.0f;
            }
            return capacityFactorsArray;
        }

        private List<Address> sortMembersByCapacity(List<Address> members, Map<Address, Float> capacityFactors) {
            if (capacityFactors == null) {
                return members;
            }
            ArrayList<Address> sortedMembers = new ArrayList<Address>();
            for (Address member : members) {
                if (capacityFactors.get(member).equals(Float.valueOf(0.0f))) continue;
                sortedMembers.add(member);
            }
            sortedMembers.sort((a1, a2) -> Float.compare(((Float)capacityFactors.get(a2)).floatValue(), ((Float)capacityFactors.get(a1)).floatValue()));
            return sortedMembers;
        }

        int[] computeExpectedSegments(int expectedOwners, float totalCapacity, int iteration) {
            int[] expected = new int[this.numNodes];
            float remainingCapacity = totalCapacity;
            int remainingCopies = expectedOwners * this.numSegments;
            float averageSegments = (float)remainingCopies / (float)this.numNodes;
            for (int n = 0; n < this.numNodes; ++n) {
                float idealOwnedSegments;
                float capacityFactor = this.sortedCapacityFactors[n];
                if (capacityFactor == 0.0f) {
                    expected[n] = 0;
                }
                if ((idealOwnedSegments = (float)remainingCopies * capacityFactor / remainingCapacity) > (float)this.numSegments) {
                    remainingCapacity -= capacityFactor;
                    remainingCopies -= this.numSegments;
                    expected[n] = this.numSegments;
                    continue;
                }
                expected[n] = Builder.fudgeExpectedSegments(idealOwnedSegments, averageSegments, iteration);
            }
            return expected;
        }

        static int fudgeExpectedSegments(float idealOwnedSegments, float averageSegments, int iteration) {
            float step = Math.max(Math.min(averageSegments * 0.05f, idealOwnedSegments * 0.15f), 1.0f);
            return Math.max((int)(idealOwnedSegments + ((float)iteration - 2.5f) * step), 0);
        }

        private long[] computeSegmentHashes(int numSegments) {
            assert (this.segmentSize != 0L);
            long[] segmentHashes = new long[numSegments];
            long currentSegmentHash = this.segmentSize >> 1;
            for (int s = 0; s < numSegments; ++s) {
                segmentHashes[s] = currentSegmentHash;
                currentSegmentHash += this.segmentSize;
            }
            return segmentHashes;
        }

        private long[][] computeNodeHashes() {
            long[][] nodeHashes = new long[this.numNodes][];
            for (int n = 0; n < this.numNodes; ++n) {
                nodeHashes[n] = new long[this.numNodeHashes];
                for (int h = 0; h < this.numNodeHashes; ++h) {
                    nodeHashes[n][h] = this.nodeHash(this.sortedMembers.get(n), h);
                }
                Arrays.sort(nodeHashes[n]);
            }
            return nodeHashes;
        }

        float computeTotalCapacity() {
            if (this.sortedCapacityFactors == null) {
                return this.sortedMembers.size();
            }
            float totalCapacity = 0.0f;
            for (float sortedCapacityFactor : this.sortedCapacityFactors) {
                totalCapacity += sortedCapacityFactor;
            }
            return totalCapacity;
        }

        long nodeHash(Address address, int virtualNode) {
            long[] key = new long[2];
            if (address instanceof JGroupsAddress) {
                org.jgroups.Address jGroupsAddress = ((JGroupsAddress)address).getJGroupsAddress();
                if (jGroupsAddress instanceof UUID) {
                    key[0] = ((UUID)jGroupsAddress).getLeastSignificantBits();
                    key[1] = ((UUID)jGroupsAddress).getMostSignificantBits();
                } else {
                    key[0] = address.hashCode();
                }
            } else if (address instanceof PersistentUUID) {
                key[0] = ((PersistentUUID)address).getLeastSignificantBits();
                key[1] = ((PersistentUUID)address).getMostSignificantBits();
            } else {
                key[0] = address.hashCode();
            }
            return MurmurHash3.MurmurHash3_x64_64((long[])key, (int)virtualNode) & Long.MAX_VALUE;
        }

        long distance(long a, long b) {
            long distance;
            long l = distance = a < b ? b - a : a - b;
            if ((distance & 0x4000000000000000L) != 0L) {
                distance = -distance - Long.MIN_VALUE;
            }
            return distance;
        }

        void populateOwners() {
            PriorityQueue[] segmentQueues = new PriorityQueue[Math.max(1, this.actualNumOwners)];
            for (int i = 0; i < segmentQueues.length; ++i) {
                segmentQueues[i] = new PriorityQueue(this.numSegments);
            }
            PriorityQueue<SegmentInfo> temporaryQueue = new PriorityQueue<SegmentInfo>(this.numNodes);
            this.assignSegments(1, this.totalCapacity, 1, segmentQueues, temporaryQueue);
            assert (this.stats.sumPrimaryOwned() == this.numSegments);
            this.assignSegments(this.actualNumOwners, this.totalCapacity, this.actualNumOwners - 1, segmentQueues, temporaryQueue);
            assert (this.stats.sumOwned() == this.actualNumOwners * this.numSegments);
        }

        private void assignSegments(int currentNumOwners, float totalCapacity, int queuesCount, PriorityQueue<SegmentInfo>[] segmentQueues, PriorityQueue<SegmentInfo> temporaryQueue) {
            int totalCopies = currentNumOwners * this.numSegments;
            int loadIteration = 0;
            while (this.stats.sumOwned() < totalCopies) {
                int[] nodeSegmentsToAdd = this.computeExpectedSegments(currentNumOwners, totalCapacity, loadIteration);
                int iterationCopies = 0;
                for (int n = 0; n < this.numNodes; ++n) {
                    iterationCopies += nodeSegmentsToAdd[n];
                    int n2 = n;
                    nodeSegmentsToAdd[n2] = nodeSegmentsToAdd[n2] - this.stats.getOwned(n);
                }
                iterationCopies = Math.max(iterationCopies, totalCopies);
                for (int distanceIteration = 0; distanceIteration < this.numNodes && this.stats.sumOwned() < iterationCopies; ++distanceIteration) {
                    this.populateQueues(currentNumOwners, nodeSegmentsToAdd, queuesCount, segmentQueues, temporaryQueue);
                    if (!this.assignQueuedOwners(currentNumOwners, nodeSegmentsToAdd, queuesCount, iterationCopies, segmentQueues)) break;
                }
                ++loadIteration;
            }
        }

        private BitSet[] computeAvailableSegmentsPerNode(int currentNumOwners) {
            BitSet[] nodeSegmentsAvailable = new BitSet[this.numNodes];
            for (int s = 0; s < this.numSegments; ++s) {
                if (!this.segmentIsAvailable(s, currentNumOwners)) continue;
                for (int n = 0; n < this.numNodes; ++n) {
                    if (!this.nodeCanOwnSegment(s, this.segmentOwners[s].size(), n)) continue;
                    if (nodeSegmentsAvailable[n] == null) {
                        nodeSegmentsAvailable[n] = new BitSet();
                    }
                    nodeSegmentsAvailable[n].set(s);
                }
            }
            return nodeSegmentsAvailable;
        }

        private boolean assignQueuedOwners(int currentNumOwners, int[] nodeSegmentsToAdd, int queuesCount, int iterationCopies, PriorityQueue<SegmentInfo>[] segmentQueues) {
            boolean assigned = false;
            for (int i = 0; i < queuesCount; ++i) {
                SegmentInfo si;
                while ((si = segmentQueues[i].poll()) != null) {
                    int ownerPosition = this.segmentOwners[si.segment].size();
                    if (nodeSegmentsToAdd[si.nodeIndex] <= 0) continue;
                    if (i == 0 || this.segmentIsAvailable(si.segment, currentNumOwners) && this.nodeCanOwnSegment(si.segment, ownerPosition, si.nodeIndex)) {
                        this.assignOwner(si.segment, ownerPosition, si.nodeIndex, nodeSegmentsToAdd);
                        assigned = true;
                    }
                    if (this.stats.sumOwned() < iterationCopies) continue;
                    return assigned;
                }
                segmentQueues[i].clear();
            }
            return assigned;
        }

        private void populateQueues(int currentNumOwners, int[] nodeSegmentsToAdd, int queueCount, PriorityQueue<SegmentInfo>[] segmentQueues, PriorityQueue<SegmentInfo> temporaryQueue) {
            SegmentInfo best = null;
            for (int s = 0; s < this.numSegments; ++s) {
                if (!this.segmentIsAvailable(s, currentNumOwners)) continue;
                for (int n = 0; n < this.numNodes; ++n) {
                    if (nodeSegmentsToAdd[n] <= 0 || !this.nodeCanOwnSegment(s, this.segmentOwners[s].size(), n)) continue;
                    long scaledDistance = this.nodeSegmentDistance(n, this.segmentHashes[s]);
                    if (queueCount > 1) {
                        SegmentInfo si = new SegmentInfo(s, n, scaledDistance);
                        temporaryQueue.add(si);
                        continue;
                    }
                    if (best == null) {
                        best = new SegmentInfo(s, n, scaledDistance);
                        continue;
                    }
                    if (scaledDistance >= best.distance) continue;
                    best.update(n, scaledDistance);
                }
                if (queueCount > 1) {
                    for (int i = 0; i < queueCount && !temporaryQueue.isEmpty(); ++i) {
                        segmentQueues[i].add((SegmentInfo)temporaryQueue.remove());
                    }
                    temporaryQueue.clear();
                    continue;
                }
                if (best != null) {
                    segmentQueues[0].add(best);
                }
                best = null;
            }
        }

        private boolean segmentIsAvailable(int segment, int currentNumOwners) {
            return this.segmentOwners[segment].size() < currentNumOwners;
        }

        private long nodeSegmentDistance(int nodeIndex, long segmentHash) {
            long scaledDistance;
            ++this.nodeDistanceUpdates;
            long[] currentNodeHashes = this.nodeHashes[nodeIndex];
            int hashIndex = Arrays.binarySearch(currentNodeHashes, segmentHash);
            if (hashIndex > 0) {
                scaledDistance = 0L;
            } else {
                long hashBefore = (hashIndex = -(hashIndex + 1)) > 0 ? currentNodeHashes[hashIndex - 1] : currentNodeHashes[this.numNodeHashes - 1];
                long hashAfter = hashIndex < this.numNodeHashes ? currentNodeHashes[hashIndex] : currentNodeHashes[0];
                long distance = Math.min(this.distance(hashBefore, segmentHash), this.distance(hashAfter, segmentHash));
                scaledDistance = (long)((float)distance * this.distanceFactors[nodeIndex]);
            }
            return scaledDistance;
        }

        protected void assignOwner(int segment, int ownerPosition, int nodeIndex, int[] nodeSegmentsWanted) {
            assert (nodeSegmentsWanted[nodeIndex] > 0);
            int n = nodeIndex;
            nodeSegmentsWanted[n] = nodeSegmentsWanted[n] - 1;
            assert (this.segmentOwners[segment].size() == ownerPosition);
            this.segmentOwners[segment].add(this.sortedMembers.get(nodeIndex));
            this.ownerIndices[segment][ownerPosition] = nodeIndex;
            this.stats.incOwned(nodeIndex, ownerPosition == 0);
        }

        boolean nodeCanOwnSegment(int segment, int ownerPosition, int nodeIndex) {
            return !this.intArrayContains(this.ownerIndices[segment], ownerPosition, nodeIndex);
        }

        boolean intArrayContains(int[] array, int end, int value) {
            for (int i = 0; i < end; ++i) {
                if (array[i] != value) continue;
                return true;
            }
            return false;
        }

        static class SegmentInfo
        implements Comparable<SegmentInfo> {
            static final int NO_AVAILABLE_OWNERS = -2;
            final int segment;
            int nodeIndex;
            long distance;

            SegmentInfo(int segment) {
                this.segment = segment;
                this.reset();
            }

            public SegmentInfo(int segment, int nodeIndex, long distance) {
                this.segment = segment;
                this.nodeIndex = nodeIndex;
                this.distance = distance;
            }

            void update(int closestNode, long minDistance) {
                this.nodeIndex = closestNode;
                this.distance = minDistance;
            }

            boolean isValid() {
                return this.nodeIndex >= 0;
            }

            void reset() {
                this.update(-1, Long.MAX_VALUE);
            }

            boolean hasNoAvailableOwners() {
                return this.nodeIndex == -2;
            }

            void markNoPotentialOwners() {
                this.update(-2, Long.MAX_VALUE);
            }

            @Override
            public int compareTo(SegmentInfo o) {
                return Long.compare(this.distance, o.distance);
            }

            public String toString() {
                if (this.nodeIndex >= 0) {
                    return String.format("SegmentInfo#%d{n=%d, distance=%016x}", this.segment, this.nodeIndex, this.distance);
                }
                return String.format("SegmentInfo#%d{%s}", this.segment, this.segmentDescription());
            }

            private String segmentDescription() {
                switch (this.nodeIndex) {
                    case -1: {
                        return "NO_NODE";
                    }
                    case -2: {
                        return "NO_AVAILABLE_OWNERS";
                    }
                }
                return String.valueOf(this.segment);
            }
        }
    }
}

