/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.health.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheAction;
import org.infinispan.security.actions.GetCacheDistributionManagerAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static DistributionManager getDistributionManager(Cache<?, ?> cache) {
        GetCacheDistributionManagerAction action = new GetCacheDistributionManagerAction(cache.getAdvancedCache());
        return SecurityActions.doPrivileged(action);
    }

    static Cache<?, ?> getCache(EmbeddedCacheManager cacheManager, String cacheName) {
        return (Cache)SecurityActions.doPrivileged(new GetCacheAction(cacheManager, cacheName));
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        return SecurityActions.doPrivileged(new GetGlobalComponentRegistryAction(cacheManager));
    }
}

