/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.webauthn4j.converter.AttestedCredentialDataConverter;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.jackson.deserializer.cbor.AuthenticationExtensionsAuthenticatorOutputsEnvelope;
import com.webauthn4j.converter.jackson.deserializer.cbor.COSEKeyEnvelope;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticatorDataConverter {
    private static final int RPID_HASH_LENGTH = 32;
    private static final int FLAGS_LENGTH = 1;
    private static final int COUNTER_LENGTH = 4;
    private static final int AAGUID_LENGTH = 16;
    private static final int L_LENGTH = 2;
    private static final int COUNTER_INDEX = 33;
    private static final int ATTESTED_CREDENTIAL_DATA_INDEX = 37;
    private static final int L_INDEX = 53;
    private static final int CREDENTIAL_ID_INDEX = 55;
    private final CborConverter cborConverter;
    private final AttestedCredentialDataConverter attestedCredentialDataConverter;

    public AuthenticatorDataConverter(@NonNull ObjectConverter objectConverter) {
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.cborConverter = objectConverter.getCborConverter();
        this.attestedCredentialDataConverter = new AttestedCredentialDataConverter(objectConverter);
    }

    public <T extends ExtensionAuthenticatorOutput> @NonNull byte[] convert(@NonNull AuthenticatorData<T> source) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] rpIdHash = source.getRpIdHash();
            byteArrayOutputStream.write(rpIdHash);
            byteArrayOutputStream.write(new byte[]{source.getFlags()});
            byteArrayOutputStream.write(UnsignedNumberUtil.toBytes((long)source.getSignCount()));
            if (source.getAttestedCredentialData() != null) {
                byteArrayOutputStream.write(this.attestedCredentialDataConverter.convert(source.getAttestedCredentialData()));
            }
            byteArrayOutputStream.write(this.convert(source.getExtensions()));
            return byteArrayOutputStream.toByteArray();
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T extends ExtensionAuthenticatorOutput> @NonNull AuthenticatorData<T> convert(@NonNull byte[] source) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(source);
            byte[] rpIdHash = new byte[32];
            byteBuffer.get(rpIdHash, 0, 32);
            byte flags = byteBuffer.get();
            long counter = UnsignedNumberUtil.getUnsignedInt((ByteBuffer)byteBuffer);
            AttestedCredentialData attestedCredentialData = AuthenticatorData.checkFlagAT(flags) ? (byteBuffer.hasRemaining() ? this.attestedCredentialDataConverter.convert(byteBuffer) : null) : null;
            AuthenticationExtensionsAuthenticatorOutputs<T> extensions = AuthenticatorData.checkFlagED(flags) ? this.convertToExtensions(byteBuffer) : new AuthenticationExtensionsAuthenticatorOutputs();
            if (byteBuffer.hasRemaining()) {
                throw new DataConversionException("provided data does not have proper byte layout");
            }
            return new AuthenticatorData<T>(rpIdHash, flags, counter, attestedCredentialData, extensions);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
        catch (BufferUnderflowException e) {
            throw new DataConversionException("provided data does not have proper byte layout", e);
        }
    }

    public @NonNull byte[] extractAttestedCredentialData(@NonNull byte[] authenticatorData) {
        byte[] lengthBytes = Arrays.copyOfRange(authenticatorData, 53, 55);
        int credentialIdLength = UnsignedNumberUtil.getUnsignedShort((byte[])lengthBytes);
        int credentialPublicKeyIndex = 55 + credentialIdLength;
        byte[] attestedCredentialDataBytes = Arrays.copyOfRange(authenticatorData, credentialPublicKeyIndex, authenticatorData.length);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(attestedCredentialDataBytes);
        COSEKeyEnvelope coseKeyEnvelope = this.attestedCredentialDataConverter.convertToCredentialPublicKey(byteArrayInputStream);
        int credentialPublicKeyLength = coseKeyEnvelope.getLength();
        int attestedCredentialDataLength = 18 + credentialIdLength + credentialPublicKeyLength;
        return Arrays.copyOfRange(authenticatorData, 37, 37 + attestedCredentialDataLength);
    }

    public long extractSignCount(@NonNull byte[] authenticatorData) {
        byte[] counterBytes = Arrays.copyOfRange(authenticatorData, 33, 37);
        return UnsignedNumberUtil.getUnsignedInt((byte[])counterBytes);
    }

    <T extends ExtensionAuthenticatorOutput> @NonNull byte[] convert(@Nullable AuthenticationExtensionsAuthenticatorOutputs<T> extensions) {
        if (extensions == null || extensions.getKeys().isEmpty()) {
            return new byte[0];
        }
        return this.cborConverter.writeValueAsBytes(extensions);
    }

    <T extends ExtensionAuthenticatorOutput> @Nullable AuthenticationExtensionsAuthenticatorOutputs<T> convertToExtensions(@NonNull ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() == 0) {
            return new AuthenticationExtensionsAuthenticatorOutputs();
        }
        byte[] remaining = new byte[byteBuffer.remaining()];
        byteBuffer.get(remaining);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(remaining);
        AuthenticationExtensionsAuthenticatorOutputsEnvelope envelope = (AuthenticationExtensionsAuthenticatorOutputsEnvelope)this.cborConverter.readValue((InputStream)byteArrayInputStream, new TypeReference<AuthenticationExtensionsAuthenticatorOutputsEnvelope<T>>(){});
        if (envelope == null) {
            return null;
        }
        int leftoverLength = remaining.length - envelope.getLength();
        byteBuffer.position(byteBuffer.position() - leftoverLength);
        return envelope.getAuthenticationExtensionsAuthenticatorOutputs();
    }
}

