/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import lombok.NonNull;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class VncRecordingContainer
extends GenericContainer<VncRecordingContainer> {
    private static final String ORIGINAL_RECORDING_FILE_NAME = "/screen.flv";
    public static final String DEFAULT_VNC_PASSWORD = "secret";
    public static final int DEFAULT_VNC_PORT = 5900;
    static final VncRecordingFormat DEFAULT_RECORDING_FORMAT = VncRecordingFormat.FLV;
    private final String targetNetworkAlias;
    private String vncPassword = "secret";
    private VncRecordingFormat videoFormat = DEFAULT_RECORDING_FORMAT;
    private int vncPort = 5900;
    private int frameRate = 30;

    public VncRecordingContainer(@NonNull GenericContainer<?> targetContainer) {
        this(targetContainer.getNetwork(), (String)targetContainer.getNetworkAliases().stream().findFirst().orElseThrow(() -> new IllegalStateException("Target container must have a network alias")));
        if (targetContainer == null) {
            throw new NullPointerException("targetContainer is marked non-null but is null");
        }
    }

    public VncRecordingContainer(@NonNull Network network, @NonNull String targetNetworkAlias) throws IllegalStateException {
        super(DockerImageName.parse("testcontainers/vnc-recorder:1.2.0"));
        if (network == null) {
            throw new NullPointerException("network is marked non-null but is null");
        }
        if (targetNetworkAlias == null) {
            throw new NullPointerException("targetNetworkAlias is marked non-null but is null");
        }
        this.targetNetworkAlias = targetNetworkAlias;
        this.withNetwork(network);
        this.waitingFor(new LogMessageWaitStrategy().withRegEx(".*Connected.*").withStartupTimeout(Duration.of(15L, ChronoUnit.SECONDS)));
    }

    public VncRecordingContainer withVncPassword(@NonNull String vncPassword) {
        if (vncPassword == null) {
            throw new NullPointerException("vncPassword is marked non-null but is null");
        }
        this.vncPassword = vncPassword;
        return this;
    }

    public VncRecordingContainer withVncPort(int vncPort) {
        this.vncPort = vncPort;
        return this;
    }

    public VncRecordingContainer withVideoFormat(VncRecordingFormat videoFormat) {
        if (videoFormat != null) {
            this.videoFormat = videoFormat;
        }
        return this;
    }

    public VncRecordingContainer withFrameRate(int frameRate) {
        this.frameRate = frameRate;
        return this;
    }

    @Override
    protected void configure() {
        this.withCreateContainerCmdModifier(it -> it.withEntrypoint(new String[]{"/bin/sh"}));
        String encodedPassword = Base64.getEncoder().encodeToString(this.vncPassword.getBytes());
        this.setCommand("-c", "echo '" + encodedPassword + "' | base64 -d > /vnc_password && flvrec.py -o " + ORIGINAL_RECORDING_FILE_NAME + " -d -r " + this.frameRate + " -P /vnc_password " + this.targetNetworkAlias + " " + this.vncPort);
    }

    public InputStream streamRecording() {
        String newRecordingFileName = this.videoFormat.reencodeRecording(this, ORIGINAL_RECORDING_FILE_NAME);
        TarArchiveInputStream archiveInputStream = new TarArchiveInputStream(this.dockerClient.copyArchiveFromContainerCmd(this.getContainerId(), newRecordingFileName).exec());
        archiveInputStream.getNextEntry();
        return archiveInputStream;
    }

    public void saveRecordingToFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (InputStream inputStream = this.streamRecording();){
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public String getTargetNetworkAlias() {
        return this.targetNetworkAlias;
    }

    public String getVncPassword() {
        return this.vncPassword;
    }

    public VncRecordingFormat getVideoFormat() {
        return this.videoFormat;
    }

    public int getVncPort() {
        return this.vncPort;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    @Override
    public String toString() {
        return "VncRecordingContainer(targetNetworkAlias=" + this.getTargetNetworkAlias() + ", vncPassword=" + this.getVncPassword() + ", videoFormat=" + (Object)((Object)this.getVideoFormat()) + ", vncPort=" + this.getVncPort() + ", frameRate=" + this.getFrameRate() + ")";
    }

    public static enum VncRecordingFormat {
        FLV("flv"){

            @Override
            String reencodeRecording(@NonNull VncRecordingContainer container, @NonNull String source) throws IOException, InterruptedException {
                if (container == null) {
                    throw new NullPointerException("container is marked non-null but is null");
                }
                if (source == null) {
                    throw new NullPointerException("source is marked non-null but is null");
                }
                String newFileOutput = "/newScreen.flv";
                container.execInContainer(new String[]{"ffmpeg", "-i", source, "-vcodec", "libx264", newFileOutput});
                return newFileOutput;
            }
        }
        ,
        MP4("mp4"){

            @Override
            String reencodeRecording(@NonNull VncRecordingContainer container, @NonNull String source) throws IOException, InterruptedException {
                if (container == null) {
                    throw new NullPointerException("container is marked non-null but is null");
                }
                if (source == null) {
                    throw new NullPointerException("source is marked non-null but is null");
                }
                String newFileOutput = "/newScreen.mp4";
                container.execInContainer(new String[]{"ffmpeg", "-i", source, "-vcodec", "libx264", "-movflags", "faststart", "-pix_fmt", "yuv420p", newFileOutput});
                return newFileOutput;
            }
        };

        private final String filenameExtension;

        abstract String reencodeRecording(VncRecordingContainer var1, String var2) throws IOException, InterruptedException;

        private VncRecordingFormat(String filenameExtension) {
            this.filenameExtension = filenameExtension;
        }

        public String getFilenameExtension() {
            return this.filenameExtension;
        }
    }
}

