/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.internal;

import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ExecInContainerPattern;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public class InternalCommandPortListeningCheck
implements Callable<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(InternalCommandPortListeningCheck.class);
    private final WaitStrategyTarget waitStrategyTarget;
    private final Set<Integer> internalPorts;

    @Override
    public Boolean call() {
        StringBuilder command = new StringBuilder("while true; do ( true ");
        for (int internalPort : this.internalPorts) {
            command.append(" && ");
            command.append(" (");
            command.append(String.format("grep -i ':0*%x' /proc/net/tcp*", internalPort));
            command.append(" || ");
            command.append(String.format("nc -vz -w 1 localhost %d", internalPort));
            command.append(" || ");
            command.append(String.format("/bin/bash -c '</dev/tcp/localhost/%d'", internalPort));
            command.append(")");
        }
        command.append(" ) && exit 0 || sleep 0.1; done");
        Instant before = Instant.now();
        try {
            Container.ExecResult result = ExecInContainerPattern.execInContainer(this.waitStrategyTarget.getDockerClient(), this.waitStrategyTarget.getContainerInfo(), "/bin/sh", "-c", command.toString());
            log.trace("Check for {} took {}. Result code '{}', stdout message: '{}'", new Object[]{this.internalPorts, Duration.between(before, Instant.now()), result.getExitCode(), result.getStdout()});
            int exitCode = result.getExitCode();
            if (exitCode != 0 && exitCode != 1) {
                log.warn("An exception while executing the internal check: {}", (Object)result);
            }
            return exitCode == 0;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public InternalCommandPortListeningCheck(WaitStrategyTarget waitStrategyTarget, Set<Integer> internalPorts) {
        this.waitStrategyTarget = waitStrategyTarget;
        this.internalPorts = internalPorts;
    }
}

