/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.model.Frame;
import java.io.InputStream;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AbstrAsyncDockerCmd;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

public class ExecStartCmdImpl
extends AbstrAsyncDockerCmd<ExecStartCmd, Frame>
implements ExecStartCmd {
    @JsonIgnore
    private String execId;
    @JsonProperty(value="Detach")
    private Boolean detach;
    @JsonProperty(value="Tty")
    private Boolean tty;
    @JsonIgnore
    private InputStream stdin;

    public ExecStartCmdImpl(ExecStartCmd.Exec exec, String execId) {
        super(exec);
        this.withExecId(execId);
    }

    public String getExecId() {
        return this.execId;
    }

    public ExecStartCmd withExecId(String execId) {
        Preconditions.checkNotNull(execId, "execId was not specified");
        this.execId = execId;
        return this;
    }

    public Boolean hasDetachEnabled() {
        return this.detach;
    }

    public Boolean hasTtyEnabled() {
        return this.tty;
    }

    @JsonIgnore
    public InputStream getStdin() {
        return this.stdin;
    }

    public ExecStartCmd withDetach(Boolean detach) {
        this.detach = detach;
        return this;
    }

    public ExecStartCmd withTty(Boolean tty) {
        this.tty = tty;
        return this;
    }

    public ExecStartCmd withStdIn(InputStream stdin) {
        this.stdin = stdin;
        return this;
    }

    @Override
    public <T extends ResultCallback<Frame>> T exec(T resultCallback) {
        return super.exec(resultCallback);
    }
}

