/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.TagImageCmd;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AbstrDockerCmd;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

public class TagImageCmdImpl
extends AbstrDockerCmd<TagImageCmd, Void>
implements TagImageCmd {
    private String imageId;
    private String repository;
    private String tag;
    private Boolean force;

    public TagImageCmdImpl(TagImageCmd.Exec exec, String imageId, String repository, String tag) {
        super(exec);
        this.withImageId(imageId);
        this.withRepository(repository);
        this.withTag(tag);
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public Boolean hasForceEnabled() {
        return this.force;
    }

    public TagImageCmd withImageId(String imageId) {
        Preconditions.checkNotNull(imageId, "imageId was not specified");
        this.imageId = imageId;
        return this;
    }

    public TagImageCmd withRepository(String repository) {
        Preconditions.checkNotNull(repository, "repository was not specified");
        this.repository = repository;
        return this;
    }

    public TagImageCmd withTag(String tag) {
        Preconditions.checkNotNull(tag, "tag was not specified");
        this.tag = tag;
        return this;
    }

    public TagImageCmd withForce() {
        return this.withForce(true);
    }

    public TagImageCmd withForce(Boolean force) {
        this.force = force;
        return this;
    }
}

