/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.zeroturnaround.exec.close;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.org.zeroturnaround.exec.close.StandardProcessCloser;
import org.testcontainers.shaded.org.zeroturnaround.exec.stream.ExecuteStreamHandler;
import org.testcontainers.shaded.org.zeroturnaround.exec.stream.PumpStreamHandler;

public class TimeoutProcessCloser
extends StandardProcessCloser {
    private static final Logger log = LoggerFactory.getLogger(TimeoutProcessCloser.class);
    private final long timeout;
    private final TimeUnit unit;

    public TimeoutProcessCloser(ExecuteStreamHandler streams, long timeout, TimeUnit unit) {
        super(streams);
        this.timeout = timeout;
        this.unit = unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(final Process process) throws IOException, InterruptedException {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        Future<Void> future = service.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TimeoutProcessCloser.this.doClose(process);
                return null;
            }
        });
        service.shutdown();
        try {
            future.get(this.timeout, this.unit);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Could not close streams of " + process, e.getCause());
        }
        catch (TimeoutException e) {
            log.warn("Could not close streams of {} in {} {}", new Object[]{process, this.timeout, TimeoutProcessCloser.getUnitsAsString(this.timeout, this.unit)});
        }
        finally {
            if (this.streams instanceof PumpStreamHandler) {
                ((PumpStreamHandler)this.streams).flush();
            }
        }
    }

    protected void doClose(Process process) throws IOException, InterruptedException {
        super.close(process);
    }

    private static String getUnitsAsString(long d, TimeUnit unit) {
        String result = unit.toString().toLowerCase();
        if (d == 1L) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

