/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.util;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLEncryptionUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String DS_KEY_INFO = "ds:KeyInfo";
    private static final String RSA_ENCRYPTION_SCHEME;

    private static EncryptedKey encryptKey(Document document, SecretKey keyToBeEncrypted, PublicKey keyUsedToEncryptSecretKey, int keySize, String encryptionUrlForKeyUnwrap) throws ProcessingException {
        try {
            XMLCipher keyCipher = XMLCipher.getInstance((String)encryptionUrlForKeyUnwrap);
            keyCipher.init(3, (Key)keyUsedToEncryptSecretKey);
            return keyCipher.encryptKey(document, (Key)keyToBeEncrypted);
        }
        catch (XMLEncryptionException e) {
            throw logger.processingError(e);
        }
    }

    public static void encryptElement(QName elementQName, Document document, PublicKey publicKey, SecretKey secretKey, int keySize, QName wrappingElementQName, boolean addEncryptedKeyInKeyInfo) throws ProcessingException {
        XMLEncryptionUtil.encryptElement(elementQName, document, publicKey, secretKey, keySize, wrappingElementQName, addEncryptedKeyInKeyInfo, XMLEncryptionUtil.getXMLEncryptionURLForKeyUnwrap(publicKey.getAlgorithm(), keySize));
    }

    public static void encryptElement(QName elementQName, Document document, PublicKey publicKey, SecretKey secretKey, int keySize, QName wrappingElementQName, boolean addEncryptedKeyInKeyInfo, String encryptionUrlForKeyUnwrap) throws ProcessingException {
        NodeList cipherElements;
        Document encryptedDoc;
        if (elementQName == null) {
            throw logger.nullArgumentError("elementQName");
        }
        if (document == null) {
            throw logger.nullArgumentError("document");
        }
        String wrappingElementPrefix = wrappingElementQName.getPrefix();
        if (wrappingElementPrefix == null || "".equals(wrappingElementPrefix)) {
            throw logger.wrongTypeError("Wrapping element prefix invalid");
        }
        Element documentElement = DocumentUtil.getElement(document, elementQName);
        if (documentElement == null) {
            throw logger.domMissingDocElementError(elementQName.toString());
        }
        XMLCipher cipher = null;
        EncryptedKey encryptedKey = XMLEncryptionUtil.encryptKey(document, secretKey, publicKey, keySize, encryptionUrlForKeyUnwrap);
        String encryptionAlgorithm = XMLEncryptionUtil.getXMLEncryptionURL(secretKey.getAlgorithm(), keySize);
        try {
            cipher = XMLCipher.getInstance((String)encryptionAlgorithm);
            cipher.init(1, (Key)secretKey);
        }
        catch (XMLEncryptionException e1) {
            throw logger.processingError(e1);
        }
        try {
            encryptedDoc = cipher.doFinal(document, documentElement);
        }
        catch (Exception e) {
            throw logger.processingError(e);
        }
        Element encryptedKeyElement = cipher.martial(document, encryptedKey);
        String wrappingElementName = StringUtil.isNullOrEmpty(wrappingElementPrefix) ? wrappingElementQName.getLocalPart() : wrappingElementPrefix + ":" + wrappingElementQName.getLocalPart();
        Element wrappingElement = encryptedDoc.createElementNS(wrappingElementQName.getNamespaceURI(), wrappingElementName);
        if (!StringUtil.isNullOrEmpty(wrappingElementPrefix)) {
            wrappingElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + wrappingElementPrefix, wrappingElementQName.getNamespaceURI());
        }
        if ((cipherElements = encryptedDoc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData")) == null || cipherElements.getLength() == 0) {
            throw logger.domMissingElementError("xenc:EncryptedData");
        }
        Element encryptedDataElement = (Element)cipherElements.item(0);
        Node parentOfEncNode = encryptedDataElement.getParentNode();
        parentOfEncNode.replaceChild(wrappingElement, encryptedDataElement);
        wrappingElement.appendChild(encryptedDataElement);
        if (addEncryptedKeyInKeyInfo) {
            Element sigElement = encryptedDoc.createElementNS("http://www.w3.org/2000/09/xmldsig#", DS_KEY_INFO);
            sigElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
            sigElement.appendChild(encryptedKeyElement);
            NodeList nodeList = encryptedDoc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherData");
            if (nodeList == null || nodeList.getLength() == 0) {
                throw logger.domMissingElementError("xenc:CipherData");
            }
            Element cipherDataElement = (Element)nodeList.item(0);
            Node cipherParent = cipherDataElement.getParentNode();
            cipherParent.insertBefore(sigElement, cipherDataElement);
        } else {
            wrappingElement.appendChild(encryptedKeyElement);
        }
    }

    public static Element decryptElementInDocument(Document documentWithEncryptedElement, DecryptionKeyLocator decryptionKeyLocator) throws ProcessingException {
        EncryptedKey encryptedKey;
        EncryptedData encryptedData;
        XMLCipher cipher;
        if (documentWithEncryptedElement == null) {
            throw logger.nullArgumentError("Input document is null");
        }
        Element documentRoot = documentWithEncryptedElement.getDocumentElement();
        Element encDataElement = XMLEncryptionUtil.getNextElementNode(documentRoot.getFirstChild());
        if (encDataElement == null) {
            throw logger.domMissingElementError("No element representing the encrypted data found");
        }
        Element encKeyElement = XMLEncryptionUtil.getNextElementNode(encDataElement.getNextSibling());
        if (encKeyElement == null) {
            NodeList nodeList = encDataElement.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
            if (nodeList == null || nodeList.getLength() == 0) {
                throw logger.nullValueError("Encrypted Key not found in the enc data");
            }
            encKeyElement = (Element)nodeList.item(0);
        }
        try {
            cipher = XMLCipher.getInstance();
            cipher.init(2, null);
            encryptedData = cipher.loadEncryptedData(documentWithEncryptedElement, encDataElement);
            encryptedKey = cipher.loadEncryptedKey(documentWithEncryptedElement, encKeyElement);
        }
        catch (XMLEncryptionException e1) {
            throw logger.processingError(e1);
        }
        Document decryptedDoc = null;
        if (encryptedData != null && encryptedKey != null) {
            boolean success = false;
            RuntimeException enclosingThrowable = new RuntimeException("Cannot decrypt element in document");
            List<PrivateKey> encryptionKeys = decryptionKeyLocator.getKeys(encryptedData);
            if (encryptionKeys == null || encryptionKeys.isEmpty()) {
                throw logger.nullValueError("Key for EncryptedData not found.");
            }
            for (PrivateKey privateKey : encryptionKeys) {
                try {
                    String encAlgoURL = encryptedData.getEncryptionMethod().getAlgorithm();
                    XMLCipher keyCipher = XMLCipher.getInstance();
                    keyCipher.init(4, (Key)privateKey);
                    Key encryptionKey = keyCipher.decryptKey(encryptedKey, encAlgoURL);
                    cipher = XMLCipher.getInstance();
                    cipher.init(2, encryptionKey);
                    decryptedDoc = cipher.doFinal(documentWithEncryptedElement, encDataElement);
                    success = true;
                    break;
                }
                catch (Exception e) {
                    enclosingThrowable.addSuppressed(e);
                }
            }
            if (!success) {
                throw logger.processingError(enclosingThrowable);
            }
        }
        if (decryptedDoc == null) {
            throw logger.nullValueError("decryptedDoc");
        }
        Element decryptedRoot = decryptedDoc.getDocumentElement();
        Element dataElement = XMLEncryptionUtil.getNextElementNode(decryptedRoot.getFirstChild());
        if (dataElement == null) {
            throw logger.nullValueError("Data Element after encryption is null");
        }
        decryptedRoot.removeChild(dataElement);
        decryptedDoc.replaceChild(dataElement, decryptedRoot);
        return decryptedDoc.getDocumentElement();
    }

    private static String getXMLEncryptionURLForKeyUnwrap(String publicKeyAlgo, int keySize) {
        if ("AES".equals(publicKeyAlgo)) {
            switch (keySize) {
                case 192: {
                    return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
                }
                case 256: {
                    return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
                }
            }
            return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        }
        if (publicKeyAlgo.contains("RSA")) {
            return RSA_ENCRYPTION_SCHEME;
        }
        throw logger.unsupportedType("unsupported publicKey Algo:" + publicKeyAlgo);
    }

    private static String getXMLEncryptionURL(String algo, int keySize) {
        if ("AES".equals(algo)) {
            switch (keySize) {
                case 192: {
                    return "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
                }
                case 256: {
                    return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
                }
            }
            return "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        }
        if (algo.contains("RSA")) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
        throw logger.unsupportedType("Secret Key with unsupported algo:" + algo);
    }

    private static Element getNextElementNode(Node node) {
        while (node != null) {
            if (1 == node.getNodeType()) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    static {
        Init.init();
        RSA_ENCRYPTION_SCHEME = Objects.equals(System.getProperty("keycloak.saml.key_trans.rsa_v1.5"), "true") ? "http://www.w3.org/2001/04/xmlenc#rsa-1_5" : "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    }

    public static interface DecryptionKeyLocator {
        public List<PrivateKey> getKeys(EncryptedData var1);
    }
}

