/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.datastore;

import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.UserCache;
import org.keycloak.storage.ClientScopeStorageManager;
import org.keycloak.storage.ClientStorageManager;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.ExportImportManager;
import org.keycloak.storage.GroupStorageManager;
import org.keycloak.storage.LegacyStoreManagers;
import org.keycloak.storage.MigrationManager;
import org.keycloak.storage.RoleStorageManager;
import org.keycloak.storage.UserStorageManager;
import org.keycloak.storage.datastore.LegacyDatastoreProviderFactory;
import org.keycloak.storage.datastore.LegacyExportImportManager;
import org.keycloak.storage.datastore.LegacyMigrationManager;
import org.keycloak.storage.federated.UserFederatedStorageProvider;

public class LegacyDatastoreProvider
implements DatastoreProvider,
LegacyStoreManagers {
    private final LegacyDatastoreProviderFactory factory;
    private final KeycloakSession session;
    private ClientProvider clientProvider;
    private ClientScopeProvider clientScopeProvider;
    private GroupProvider groupProvider;
    private RealmProvider realmProvider;
    private RoleProvider roleProvider;
    private UserProvider userProvider;
    private ClientScopeStorageManager clientScopeStorageManager;
    private RoleStorageManager roleStorageManager;
    private GroupStorageManager groupStorageManager;
    private ClientStorageManager clientStorageManager;
    private UserProvider userStorageManager;
    private UserFederatedStorageProvider userFederatedStorageProvider;

    public LegacyDatastoreProvider(LegacyDatastoreProviderFactory factory, KeycloakSession session) {
        this.factory = factory;
        this.session = session;
    }

    public void close() {
    }

    public ClientProvider clientStorageManager() {
        if (this.clientStorageManager == null) {
            this.clientStorageManager = new ClientStorageManager(this.session, this.factory.getClientStorageProviderTimeout());
        }
        return this.clientStorageManager;
    }

    public ClientScopeProvider clientScopeStorageManager() {
        if (this.clientScopeStorageManager == null) {
            this.clientScopeStorageManager = new ClientScopeStorageManager(this.session);
        }
        return this.clientScopeStorageManager;
    }

    public RoleProvider roleStorageManager() {
        if (this.roleStorageManager == null) {
            this.roleStorageManager = new RoleStorageManager(this.session, this.factory.getRoleStorageProviderTimeout());
        }
        return this.roleStorageManager;
    }

    public GroupProvider groupStorageManager() {
        if (this.groupStorageManager == null) {
            this.groupStorageManager = new GroupStorageManager(this.session);
        }
        return this.groupStorageManager;
    }

    public UserProvider userStorageManager() {
        if (this.userStorageManager == null) {
            this.userStorageManager = new UserStorageManager(this.session);
        }
        return this.userStorageManager;
    }

    public UserProvider userLocalStorage() {
        return (UserProvider)this.session.getProvider(UserProvider.class);
    }

    public UserFederatedStorageProvider userFederatedStorage() {
        if (this.userFederatedStorageProvider == null) {
            this.userFederatedStorageProvider = (UserFederatedStorageProvider)this.session.getProvider(UserFederatedStorageProvider.class);
        }
        return this.userFederatedStorageProvider;
    }

    private ClientProvider getClientProvider() {
        ClientProvider cache = (ClientProvider)this.session.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.clientStorageManager();
    }

    private ClientScopeProvider getClientScopeProvider() {
        ClientScopeProvider cache = (ClientScopeProvider)this.session.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.clientScopeStorageManager();
    }

    private GroupProvider getGroupProvider() {
        GroupProvider cache = (GroupProvider)this.session.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.groupStorageManager();
    }

    private RealmProvider getRealmProvider() {
        CacheRealmProvider cache = (CacheRealmProvider)this.session.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return (RealmProvider)this.session.getProvider(RealmProvider.class);
    }

    private RoleProvider getRoleProvider() {
        RoleProvider cache = (RoleProvider)this.session.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.roleStorageManager();
    }

    private UserProvider getUserProvider() {
        UserCache cache = (UserCache)this.session.getProvider(UserCache.class);
        if (cache != null) {
            return cache;
        }
        return this.userStorageManager();
    }

    public ClientProvider clients() {
        if (this.clientProvider == null) {
            this.clientProvider = this.getClientProvider();
        }
        return this.clientProvider;
    }

    public ClientScopeProvider clientScopes() {
        if (this.clientScopeProvider == null) {
            this.clientScopeProvider = this.getClientScopeProvider();
        }
        return this.clientScopeProvider;
    }

    public GroupProvider groups() {
        if (this.groupProvider == null) {
            this.groupProvider = this.getGroupProvider();
        }
        return this.groupProvider;
    }

    public RealmProvider realms() {
        if (this.realmProvider == null) {
            this.realmProvider = this.getRealmProvider();
        }
        return this.realmProvider;
    }

    public RoleProvider roles() {
        if (this.roleProvider == null) {
            this.roleProvider = this.getRoleProvider();
        }
        return this.roleProvider;
    }

    public UserProvider users() {
        if (this.userProvider == null) {
            this.userProvider = this.getUserProvider();
        }
        return this.userProvider;
    }

    public ExportImportManager getExportImportManager() {
        return new LegacyExportImportManager(this.session);
    }

    public MigrationManager getMigrationManager() {
        return new LegacyMigrationManager(this.session);
    }
}

