/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import org.jboss.byteman.agent.AccessEnabler;
import org.jboss.byteman.agent.DefaultAccessEnabler;
import org.jboss.byteman.rule.helper.Helper;

public class AccessManager {
    public static AccessEnabler init(Instrumentation inst) {
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        try {
            systemLoader.loadClass("java.lang.Module");
        }
        catch (ClassNotFoundException ce) {
            return AccessManager.initDefault();
        }
        try {
            Class<?> jigsawAccessManagerClazz = systemLoader.loadClass("org.jboss.byteman.agent.JigsawAccessManager");
            try {
                Method initMethod = jigsawAccessManagerClazz.getDeclaredMethod("init", Instrumentation.class);
                AccessEnabler accessEnabler = (AccessEnabler)initMethod.invoke(null, inst);
                return accessEnabler;
            }
            catch (Exception e) {
                Helper.err("AccessManager:init unexpected error initialising JigsawAccessManager");
                Helper.errTraceException(e);
                return AccessManager.initDefault();
            }
        }
        catch (ClassNotFoundException e) {
            Helper.verbose("AccessManager:init hmm, JigsawAccessManager not present in Jigsaw runtime!");
            return AccessManager.initDefault();
        }
    }

    private static AccessEnabler initDefault() {
        Helper.verbose("AccessManager:init Initialising default AccessManager");
        return new DefaultAccessEnabler();
    }
}

