/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.BooleanExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class LogicalExpression
extends BooleanExpression {
    public LogicalExpression(Rule rule, int oper, ParseNode token, Expression left, Expression right) {
        super(rule, oper, token, left, right);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Type type1 = this.getOperand(0).typeCheck(Type.Z);
        Type type2 = this.getOperand(1).typeCheck(Type.Z);
        this.type = Type.Z;
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("LogicalExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        Boolean value = (Boolean)this.getOperand(0).interpret(helper);
        if (this.oper == 131137) {
            return value != false && (Boolean)this.getOperand(1).interpret(helper) != false;
        }
        return value != false || (Boolean)this.getOperand(1).interpret(helper) != false;
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        Expression oper0 = this.getOperand(0);
        Expression oper1 = this.getOperand(1);
        int currentStack = compileContext.getStackCount();
        oper0.compile(mv, compileContext);
        if (oper0.getType() == Type.BOOLEAN) {
            compileContext.compileBooleanConversion(Type.BOOLEAN, Type.Z);
        }
        Label nextLabel = new Label();
        Label endLabel = new Label();
        if (this.oper == 131137) {
            mv.visitJumpInsn(154, nextLabel);
            mv.visitLdcInsn(false);
            mv.visitJumpInsn(167, endLabel);
        } else {
            mv.visitJumpInsn(153, nextLabel);
            mv.visitLdcInsn(true);
            mv.visitJumpInsn(167, endLabel);
        }
        compileContext.addStackCount(-1);
        mv.visitLabel(nextLabel);
        oper1.compile(mv, compileContext);
        if (oper0.getType() == Type.BOOLEAN) {
            compileContext.compileBooleanConversion(Type.BOOLEAN, Type.Z);
        }
        mv.visitLabel(endLabel);
        if (compileContext.getStackCount() != currentStack + 1) {
            throw new CompileException("LogicalExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + 1));
        }
    }
}

