/*
 * Decompiled with CFR 0.152.
 */
package circlet.pipelines.api;

import circlet.client.api.automation.JobExecutionDisplayStatus;
import circlet.pipelines.api.ContainerStepDTO;
import circlet.pipelines.api.ExitCode;
import circlet.pipelines.api.FailureConditionDTO;
import circlet.pipelines.api.JobExecutionWithProblems;
import circlet.pipelines.api.ResourcesStatus;
import circlet.pipelines.common.api.ActionExecutionStatus;
import circlet.pipelines.common.api.ActionExecutionStatusKt;
import circlet.pipelines.common.api.ExecutionStatus;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a$\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\u001a\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a,\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\u001a\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\"\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\u0016\u0010\u0019\u001a\u00020\u0006*\u00020\u00182\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\u0014\u0010\u0019\u001a\u00020\u0006*\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001a"}, d2={"AwaitingExecutionStatuses", "", "Lcirclet/pipelines/common/api/ExecutionStatus;", "getAwaitingExecutionStatuses", "()Ljava/util/List;", "getActionStatusPresentationEnum", "Lcirclet/client/api/automation/JobExecutionDisplayStatus;", "status", "Lcirclet/pipelines/common/api/ActionExecutionStatus;", "exitCode", "Lcirclet/pipelines/api/ExitCode;", "getExecutionDisplayStatus", "failedBySomeReason", "", "resourcesStatus", "Lcirclet/pipelines/api/ResourcesStatus;", "getJobStatusPresentationEnum", "execution", "Lcirclet/pipelines/api/JobExecutionWithProblems;", "failureConditions", "", "Lcirclet/pipelines/api/FailureConditionDTO;", "getStepStatusPresentationEnum", "step", "Lcirclet/pipelines/api/ContainerStepDTO;", "displayStatus", "pipelines-api"})
public final class ExecutionStatusPresentationKt {
    @NotNull
    private static final List<ExecutionStatus> AwaitingExecutionStatuses;

    @NotNull
    public static final List<ExecutionStatus> getAwaitingExecutionStatuses() {
        return AwaitingExecutionStatuses;
    }

    @NotNull
    public static final JobExecutionDisplayStatus getExecutionDisplayStatus(@NotNull ExecutionStatus status2, boolean failedBySomeReason, @Nullable ResourcesStatus resourcesStatus) {
        JobExecutionDisplayStatus jobExecutionDisplayStatus;
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        if (failedBySomeReason) {
            return JobExecutionDisplayStatus.Failed;
        }
        ResourcesStatus resourcesStatus2 = resourcesStatus;
        switch (resourcesStatus2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[resourcesStatus2.ordinal()]) {
            case 1: {
                return JobExecutionDisplayStatus.NoSuitableWorkers;
            }
            case 2: {
                return JobExecutionDisplayStatus.WaitingForWorkers;
            }
            case 3: {
                return JobExecutionDisplayStatus.WaitingForWorkers;
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$1[status2.ordinal()]) {
            case 1: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Awaiting;
                break;
            }
            case 2: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Awaiting;
                break;
            }
            case 3: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Awaiting;
                break;
            }
            case 4: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Running;
                break;
            }
            case 5: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Restarting;
                break;
            }
            case 6: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Finishing;
                break;
            }
            case 7: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Succeeded;
                break;
            }
            case 8: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Failed;
                break;
            }
            case 9: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Stopped;
                break;
            }
            case 10: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Stopped;
                break;
            }
            case 11: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Finishing;
                break;
            }
            case 12: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Succeeded;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jobExecutionDisplayStatus;
    }

    public static /* synthetic */ JobExecutionDisplayStatus getExecutionDisplayStatus$default(ExecutionStatus executionStatus, boolean bl, ResourcesStatus resourcesStatus, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            resourcesStatus = null;
        }
        return ExecutionStatusPresentationKt.getExecutionDisplayStatus(executionStatus, bl, resourcesStatus);
    }

    @NotNull
    public static final JobExecutionDisplayStatus getJobStatusPresentationEnum(@NotNull ExecutionStatus status2, @Nullable Collection<? extends FailureConditionDTO> failureConditions, @Nullable ResourcesStatus resourcesStatus) {
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        Collection<? extends FailureConditionDTO> collection = failureConditions;
        return ExecutionStatusPresentationKt.getExecutionDisplayStatus(status2, collection == null ? false : !collection.isEmpty(), resourcesStatus);
    }

    public static /* synthetic */ JobExecutionDisplayStatus getJobStatusPresentationEnum$default(ExecutionStatus executionStatus, Collection collection, ResourcesStatus resourcesStatus, int n, Object object) {
        if ((n & 2) != 0) {
            collection = null;
        }
        if ((n & 4) != 0) {
            resourcesStatus = null;
        }
        return ExecutionStatusPresentationKt.getJobStatusPresentationEnum(executionStatus, collection, resourcesStatus);
    }

    @NotNull
    public static final JobExecutionDisplayStatus getJobStatusPresentationEnum(@NotNull JobExecutionWithProblems execution, @Nullable ResourcesStatus resourcesStatus) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        return ExecutionStatusPresentationKt.getJobStatusPresentationEnum(execution.getStatus(), execution.getFailureConditions(), resourcesStatus);
    }

    public static /* synthetic */ JobExecutionDisplayStatus getJobStatusPresentationEnum$default(JobExecutionWithProblems jobExecutionWithProblems, ResourcesStatus resourcesStatus, int n, Object object) {
        if ((n & 2) != 0) {
            resourcesStatus = null;
        }
        return ExecutionStatusPresentationKt.getJobStatusPresentationEnum(jobExecutionWithProblems, resourcesStatus);
    }

    @NotNull
    public static final JobExecutionDisplayStatus displayStatus(@NotNull JobExecutionWithProblems $this$displayStatus, @Nullable ResourcesStatus resourcesStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$displayStatus, (String)"<this>");
        return ExecutionStatusPresentationKt.getJobStatusPresentationEnum($this$displayStatus, resourcesStatus);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final JobExecutionDisplayStatus getStepStatusPresentationEnum(@NotNull ExecutionStatus status2, @NotNull ExitCode exitCode, @Nullable ResourcesStatus resourcesStatus) {
        boolean bl;
        Integer exitCodeValue;
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        Intrinsics.checkNotNullParameter((Object)exitCode, (String)"exitCode");
        ExitCode.Available available = exitCode instanceof ExitCode.Available ? (ExitCode.Available)exitCode : null;
        Integer n = exitCodeValue = available == null ? null : Integer.valueOf(available.getExitCode());
        if (exitCodeValue != null) {
            boolean bl2 = false;
            if (exitCodeValue != 0) {
                bl = true;
                return ExecutionStatusPresentationKt.getExecutionDisplayStatus(status2, bl, resourcesStatus);
            }
        }
        bl = false;
        return ExecutionStatusPresentationKt.getExecutionDisplayStatus(status2, bl, resourcesStatus);
    }

    public static /* synthetic */ JobExecutionDisplayStatus getStepStatusPresentationEnum$default(ExecutionStatus executionStatus, ExitCode exitCode, ResourcesStatus resourcesStatus, int n, Object object) {
        if ((n & 4) != 0) {
            resourcesStatus = null;
        }
        return ExecutionStatusPresentationKt.getStepStatusPresentationEnum(executionStatus, exitCode, resourcesStatus);
    }

    @NotNull
    public static final JobExecutionDisplayStatus getStepStatusPresentationEnum(@NotNull ContainerStepDTO step, @Nullable ResourcesStatus resourcesStatus) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        return ExecutionStatusPresentationKt.getStepStatusPresentationEnum(step.getStatus(), step.getFinishDTO().getExitCode(), resourcesStatus);
    }

    public static /* synthetic */ JobExecutionDisplayStatus getStepStatusPresentationEnum$default(ContainerStepDTO containerStepDTO, ResourcesStatus resourcesStatus, int n, Object object) {
        if ((n & 2) != 0) {
            resourcesStatus = null;
        }
        return ExecutionStatusPresentationKt.getStepStatusPresentationEnum(containerStepDTO, resourcesStatus);
    }

    @NotNull
    public static final JobExecutionDisplayStatus displayStatus(@NotNull ContainerStepDTO $this$displayStatus, @Nullable ResourcesStatus resourcesStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$displayStatus, (String)"<this>");
        return ExecutionStatusPresentationKt.getStepStatusPresentationEnum($this$displayStatus, resourcesStatus);
    }

    public static /* synthetic */ JobExecutionDisplayStatus displayStatus$default(ContainerStepDTO containerStepDTO, ResourcesStatus resourcesStatus, int n, Object object) {
        if ((n & 1) != 0) {
            resourcesStatus = null;
        }
        return ExecutionStatusPresentationKt.displayStatus(containerStepDTO, resourcesStatus);
    }

    @NotNull
    public static final JobExecutionDisplayStatus getActionStatusPresentationEnum(@NotNull ActionExecutionStatus status2, @NotNull ExitCode exitCode) {
        JobExecutionDisplayStatus jobExecutionDisplayStatus;
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        Intrinsics.checkNotNullParameter((Object)exitCode, (String)"exitCode");
        if (ActionExecutionStatusKt.isFinished(status2) && (!(exitCode instanceof ExitCode.Available) || ((ExitCode.Available)exitCode).getExitCode() != 0)) {
            return JobExecutionDisplayStatus.Failed;
        }
        switch (WhenMappings.$EnumSwitchMapping$2[status2.ordinal()]) {
            case 1: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Awaiting;
                break;
            }
            case 2: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Running;
                break;
            }
            case 3: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Succeeded;
                break;
            }
            case 4: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Stopped;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jobExecutionDisplayStatus;
    }

    static {
        Object[] objectArray = new ExecutionStatus[]{ExecutionStatus.SCHEDULED, ExecutionStatus.READY_TO_START, ExecutionStatus.PENDING};
        AwaitingExecutionStatuses = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ResourcesStatus.values().length];
            nArray[ResourcesStatus.NO_SUITABLE_WORKERS.ordinal()] = 1;
            nArray[ResourcesStatus.SUITABLE_WORKERS_BUSY.ordinal()] = 2;
            nArray[ResourcesStatus.LIMITS_REACHED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ExecutionStatus.values().length];
            nArray[ExecutionStatus.SCHEDULED.ordinal()] = 1;
            nArray[ExecutionStatus.READY_TO_START.ordinal()] = 2;
            nArray[ExecutionStatus.PENDING.ordinal()] = 3;
            nArray[ExecutionStatus.RUNNING.ordinal()] = 4;
            nArray[ExecutionStatus.RESTARTING.ordinal()] = 5;
            nArray[ExecutionStatus.FINISHING.ordinal()] = 6;
            nArray[ExecutionStatus.FINISHED.ordinal()] = 7;
            nArray[ExecutionStatus.FAILED.ordinal()] = 8;
            nArray[ExecutionStatus.TERMINATING.ordinal()] = 9;
            nArray[ExecutionStatus.TERMINATED.ordinal()] = 10;
            nArray[ExecutionStatus.HIBERNATING.ordinal()] = 11;
            nArray[ExecutionStatus.HIBERNATED.ordinal()] = 12;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ActionExecutionStatus.values().length];
            nArray[ActionExecutionStatus.PENDING.ordinal()] = 1;
            nArray[ActionExecutionStatus.RUNNING.ordinal()] = 2;
            nArray[ActionExecutionStatus.FINISHED.ordinal()] = 3;
            nArray[ActionExecutionStatus.TERMINATED.ordinal()] = 4;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

