/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api.oauth;

import circlet.platform.api.KDateTime;
import circlet.platform.api.PrimitivesExKt;
import circlet.platform.api.oauth.TokenSource;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J5\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u0010\u0010\u0018\u001a\u00020\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u0000H\u0016J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\u0011\u0010\u001e\u001a\u00020\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lcirclet/platform/api/oauth/TokenInfo;", "Lcirclet/platform/api/oauth/TokenSource;", "accessToken", "", "expires", "Lcirclet/platform/api/KDateTime;", "refreshToken", "logoutUrl", "(Ljava/lang/String;Lcirclet/platform/api/KDateTime;Ljava/lang/String;Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "getExpires", "()Lcirclet/platform/api/KDateTime;", "getLogoutUrl", "getRefreshToken", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "expired", "gapSeconds", "", "hashCode", "lastToken", "toString", "token", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "platform-api"})
public final class TokenInfo
implements TokenSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accessToken;
    @Nullable
    private final KDateTime expires;
    @Nullable
    private final String refreshToken;
    @NotNull
    private final String logoutUrl;
    @NotNull
    private static final TokenInfo NoToken = new TokenInfo("", null, null, "");

    public TokenInfo(@NotNull String accessToken, @Nullable KDateTime expires, @Nullable String refreshToken2, @NotNull String logoutUrl) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)logoutUrl, (String)"logoutUrl");
        this.accessToken = accessToken;
        this.expires = expires;
        this.refreshToken = refreshToken2;
        this.logoutUrl = logoutUrl;
    }

    @NotNull
    public final String getAccessToken() {
        return this.accessToken;
    }

    @Nullable
    public final KDateTime getExpires() {
        return this.expires;
    }

    @Nullable
    public final String getRefreshToken() {
        return this.refreshToken;
    }

    @NotNull
    public final String getLogoutUrl() {
        return this.logoutUrl;
    }

    @Override
    @Nullable
    public Object token(@NotNull Continuation<? super TokenInfo> $completion) {
        return this;
    }

    @Override
    @NotNull
    public TokenInfo lastToken() {
        return this;
    }

    public final boolean expired(int gapSeconds) {
        return this.expires != null ? PrimitivesExKt.isAfter(PrimitivesExKt.addSeconds(PrimitivesExKt.getNow(), gapSeconds), this.expires) : false;
    }

    public static /* synthetic */ boolean expired$default(TokenInfo tokenInfo2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 5;
        }
        return tokenInfo2.expired(n);
    }

    @NotNull
    public final String component1() {
        return this.accessToken;
    }

    @Nullable
    public final KDateTime component2() {
        return this.expires;
    }

    @Nullable
    public final String component3() {
        return this.refreshToken;
    }

    @NotNull
    public final String component4() {
        return this.logoutUrl;
    }

    @NotNull
    public final TokenInfo copy(@NotNull String accessToken, @Nullable KDateTime expires, @Nullable String refreshToken2, @NotNull String logoutUrl) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)logoutUrl, (String)"logoutUrl");
        return new TokenInfo(accessToken, expires, refreshToken2, logoutUrl);
    }

    public static /* synthetic */ TokenInfo copy$default(TokenInfo tokenInfo2, String string2, KDateTime kDateTime, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = tokenInfo2.accessToken;
        }
        if ((n & 2) != 0) {
            kDateTime = tokenInfo2.expires;
        }
        if ((n & 4) != 0) {
            string3 = tokenInfo2.refreshToken;
        }
        if ((n & 8) != 0) {
            string4 = tokenInfo2.logoutUrl;
        }
        return tokenInfo2.copy(string2, kDateTime, string3, string4);
    }

    @NotNull
    public String toString() {
        return "TokenInfo(accessToken=" + this.accessToken + ", expires=" + this.expires + ", refreshToken=" + this.refreshToken + ", logoutUrl=" + this.logoutUrl + ')';
    }

    public int hashCode() {
        int result2 = this.accessToken.hashCode();
        result2 = result2 * 31 + (this.expires == null ? 0 : this.expires.hashCode());
        result2 = result2 * 31 + (this.refreshToken == null ? 0 : this.refreshToken.hashCode());
        result2 = result2 * 31 + this.logoutUrl.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TokenInfo)) {
            return false;
        }
        TokenInfo tokenInfo2 = (TokenInfo)other;
        if (!Intrinsics.areEqual((Object)this.accessToken, (Object)tokenInfo2.accessToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.expires, (Object)tokenInfo2.expires)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.refreshToken, (Object)tokenInfo2.refreshToken)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.logoutUrl, (Object)tokenInfo2.logoutUrl);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcirclet/platform/api/oauth/TokenInfo$Companion;", "", "()V", "NoToken", "Lcirclet/platform/api/oauth/TokenInfo;", "getNoToken", "()Lcirclet/platform/api/oauth/TokenInfo;", "platform-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TokenInfo getNoToken() {
            return NoToken;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

