/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.JBHiDPIScaledImage;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/space/gateway/ui/ImageLoader;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "loadImage", "Ljava/awt/Image;", "path", "", "width", "", "height", "intellij.space.gateway"})
final class ImageLoader {
    private static final Logger LOG;
    @NotNull
    public static final ImageLoader INSTANCE;

    @Nullable
    public final Image loadImage(@NotNull String path2, int width, int height) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path2));
            Image image2 = img;
            BufferedImage bufferedImage = img;
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"img");
            image = (Image)new JBHiDPIScaledImage(image2, width, height, bufferedImage.getType());
        }
        catch (Exception e) {
            LOG.error((Object)new Function0<String>(path2){
                final /* synthetic */ String $path;

                @NotNull
                public final String invoke() {
                    return "Image " + this.$path + " is not loaded";
                }
                {
                    this.$path = string2;
                    super(0);
                }
            });
            image = null;
        }
        return image;
    }

    private ImageLoader() {
    }

    static {
        ImageLoader imageLoader;
        INSTANCE = imageLoader = new ImageLoader();
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(ImageLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        LOG = logger2;
    }
}

