/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.util.extendable.UnmodifiableExtendableItem;

public class ModuleRevisionId
extends UnmodifiableExtendableItem {
    private static final String ENCODE_SEPARATOR = ":#@#:";
    private static final String ENCODE_PREFIX = "+";
    private static final String NULL_ENCODE = "@#:NULL:#@";
    static final String STRICT_CHARS_PATTERN = "[a-zA-Z0-9\\-/\\._+=]";
    private static final String REV_STRICT_CHARS_PATTERN = "[a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]";
    private static final Map<ModuleRevisionId, WeakReference<ModuleRevisionId>> CACHE = new WeakHashMap<ModuleRevisionId, WeakReference<ModuleRevisionId>>();
    public static final Pattern MRID_PATTERN = Pattern.compile("([a-zA-Z0-9\\-/\\._+=]*)#([a-zA-Z0-9\\-/\\._+=]+)(?:#([a-zA-Z0-9\\-/\\._+=]+))?;([a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]+)");
    public static final Pattern NON_CAPTURING_PATTERN = Pattern.compile("(?:[a-zA-Z0-9\\-/\\._+=]*)#(?:[a-zA-Z0-9\\-/\\._+=]+)(?:#(?:[a-zA-Z0-9\\-/\\._+=]+))?;(?:[a-zA-Z0-9\\-/\\._+=,\\[\\]\\{\\}\\(\\):@]+)");
    private final ModuleId moduleId;
    private final String branch;
    private final String revision;
    private int hash;

    public static ModuleRevisionId parse(String mrid) {
        Matcher m2 = MRID_PATTERN.matcher(mrid.trim());
        if (!m2.matches()) {
            throw new IllegalArgumentException("module revision text representation do not match expected pattern. given mrid='" + mrid + "' expected form=" + MRID_PATTERN.pattern());
        }
        return ModuleRevisionId.newInstance(m2.group(1), m2.group(2), m2.group(3), m2.group(4));
    }

    public static ModuleRevisionId newInstance(String organisation, String name2, String revision) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name2), revision));
    }

    public static ModuleRevisionId newInstance(String organisation, String name2, String revision, Map<String, String> extraAttributes) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name2), revision, extraAttributes));
    }

    public static ModuleRevisionId newInstance(String organisation, String name2, String branch2, String revision) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name2), branch2, revision));
    }

    public static ModuleRevisionId newInstance(String organisation, String name2, String branch2, String revision, Map<String, String> extraAttributes) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name2), branch2, revision, extraAttributes));
    }

    public static ModuleRevisionId newInstance(String organisation, String name2, String branch2, String revision, Map<String, String> extraAttributes, boolean replaceNullBranchWithDefault) {
        return ModuleRevisionId.intern(new ModuleRevisionId(ModuleId.newInstance(organisation, name2), branch2, revision, extraAttributes, replaceNullBranchWithDefault));
    }

    public static ModuleRevisionId newInstance(ModuleRevisionId mrid, String rev) {
        return ModuleRevisionId.intern(new ModuleRevisionId(mrid.getModuleId(), mrid.getBranch(), rev, mrid.getQualifiedExtraAttributes()));
    }

    public static ModuleRevisionId newInstance(ModuleRevisionId mrid, String branch2, String rev) {
        return ModuleRevisionId.intern(new ModuleRevisionId(mrid.getModuleId(), branch2, rev, mrid.getQualifiedExtraAttributes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleRevisionId intern(ModuleRevisionId moduleRevisionId) {
        ModuleRevisionId r = null;
        Map<ModuleRevisionId, WeakReference<ModuleRevisionId>> map2 = CACHE;
        synchronized (map2) {
            WeakReference<ModuleRevisionId> ref2 = CACHE.get(moduleRevisionId);
            if (ref2 != null) {
                r = (ModuleRevisionId)ref2.get();
            }
            if (r == null) {
                r = moduleRevisionId;
                CACHE.put(r, new WeakReference<ModuleRevisionId>(r));
            }
        }
        return r;
    }

    public ModuleRevisionId(ModuleId moduleId, String revision) {
        this(moduleId, null, revision, null);
    }

    public ModuleRevisionId(ModuleId moduleId, String branch2, String revision) {
        this(moduleId, branch2, revision, null);
    }

    private ModuleRevisionId(ModuleId moduleId, String revision, Map<String, String> extraAttributes) {
        this(moduleId, null, revision, extraAttributes);
    }

    private ModuleRevisionId(ModuleId moduleId, String branch2, String revision, Map<String, String> extraAttributes) {
        this(moduleId, branch2, revision, extraAttributes, true);
    }

    private ModuleRevisionId(ModuleId moduleId, String branch2, String revision, Map<String, String> extraAttributes, boolean replaceNullBranchWithDefault) {
        super(null, extraAttributes);
        this.moduleId = moduleId;
        IvyContext context2 = IvyContext.getContext();
        this.branch = replaceNullBranchWithDefault && branch2 == null ? (context2.peekIvy() == null ? null : context2.getSettings().getDefaultBranch(moduleId)) : branch2;
        this.revision = revision == null ? Ivy.getWorkingRevision() : ModuleRevisionId.normalizeRevision(revision);
        this.setStandardAttribute("organisation", this.moduleId.getOrganisation());
        this.setStandardAttribute("module", this.moduleId.getName());
        this.setStandardAttribute("branch", this.branch);
        this.setStandardAttribute("revision", this.revision);
    }

    public ModuleId getModuleId() {
        return this.moduleId;
    }

    public String getName() {
        return this.getModuleId().getName();
    }

    public String getOrganisation() {
        return this.getModuleId().getOrganisation();
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModuleRevisionId)) {
            return false;
        }
        ModuleRevisionId other = (ModuleRevisionId)obj;
        return !(!other.getRevision().equals(this.getRevision()) || other.getBranch() == null && this.getBranch() != null || other.getBranch() != null && !other.getBranch().equals(this.getBranch()) || !other.getModuleId().equals(this.getModuleId()) || !other.getQualifiedExtraAttributes().equals(this.getQualifiedExtraAttributes()));
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 31;
            this.hash = this.hash * 13 + (this.getBranch() == null ? 0 : this.getBranch().hashCode());
            this.hash = this.hash * 13 + this.getRevision().hashCode();
            this.hash = this.hash * 13 + this.getModuleId().hashCode();
            this.hash = this.hash * 13 + this.getQualifiedExtraAttributes().hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return this.moduleId + (this.branch == null || this.branch.length() == 0 ? "" : "#" + this.branch) + ";" + (this.revision == null ? "NONE" : this.revision);
    }

    public String encodeToString() {
        StringBuilder buf = new StringBuilder();
        HashMap<String, String> attributes = new HashMap<String, String>(this.getAttributes());
        attributes.keySet().removeAll(this.getExtraAttributes().keySet());
        attributes.putAll(this.getQualifiedExtraAttributes());
        for (Map.Entry att : attributes.entrySet()) {
            String value2 = (String)att.getValue();
            value2 = value2 == null ? NULL_ENCODE : value2;
            buf.append(ENCODE_PREFIX).append((String)att.getKey()).append(ENCODE_SEPARATOR).append(ENCODE_PREFIX).append(value2).append(ENCODE_SEPARATOR);
        }
        return buf.toString();
    }

    public static ModuleRevisionId decode(String encoded) {
        String[] parts = encoded.split(ENCODE_SEPARATOR);
        if (parts.length % 2 != 0) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "'");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < parts.length; i += 2) {
            String attName = parts[i];
            if (!attName.startsWith(ENCODE_PREFIX)) {
                throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': " + attName + " doesn't start with " + ENCODE_PREFIX);
            }
            attName = attName.substring(1);
            String attValue = parts[i + 1];
            if (!attValue.startsWith(ENCODE_PREFIX)) {
                throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': " + attValue + " doesn't start with " + ENCODE_PREFIX);
            }
            if (NULL_ENCODE.equals(attValue = attValue.substring(1))) {
                attValue = null;
            }
            attributes.put(attName, attValue);
        }
        String org = (String)attributes.remove("organisation");
        String mod = (String)attributes.remove("module");
        String rev = (String)attributes.remove("revision");
        String branch2 = (String)attributes.remove("branch");
        if (org == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': no organisation");
        }
        if (mod == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': no module name");
        }
        if (rev == null) {
            throw new IllegalArgumentException("badly encoded module revision id: '" + encoded + "': no revision");
        }
        return ModuleRevisionId.newInstance(org, mod, branch2, rev, attributes);
    }

    public String getBranch() {
        return this.branch;
    }

    private static String normalizeRevision(String revision) {
        if (revision.startsWith("[") && revision.endsWith("]") && revision.indexOf(44) == -1) {
            if (IvyPatternHelper.getTokenString("revision").equals(revision)) {
                return revision;
            }
            return revision.substring(1, revision.length() - 1);
        }
        return revision;
    }
}

