/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.NormalRelativeUrlResolver;
import org.apache.ivy.core.RelativeUrlResolver;
import org.apache.ivy.core.cache.CacheUtil;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.cache.DefaultResolutionCacheManager;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.check.CheckEngineSettings;
import org.apache.ivy.core.deliver.DeliverEngineSettings;
import org.apache.ivy.core.install.InstallEngineSettings;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.pack.ArchivePacking;
import org.apache.ivy.core.pack.PackingRegistry;
import org.apache.ivy.core.publish.PublishEngineSettings;
import org.apache.ivy.core.repository.RepositoryManagementEngineSettings;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.core.settings.NamedTimeoutConstraint;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.core.settings.Validatable;
import org.apache.ivy.core.settings.XmlSettingsParser;
import org.apache.ivy.core.sort.SortEngineSettings;
import org.apache.ivy.osgi.core.OsgiLatestStrategy;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.circular.ErrorCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.IgnoreCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.WarnCircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.LatestCompatibleConflictManager;
import org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.apache.ivy.plugins.conflict.NoConflictManager;
import org.apache.ivy.plugins.conflict.StrictConflictManager;
import org.apache.ivy.plugins.latest.LatestLexicographicStrategy;
import org.apache.ivy.plugins.latest.LatestRevisionStrategy;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.latest.LatestTimeStrategy;
import org.apache.ivy.plugins.latest.WorkspaceLatestStrategy;
import org.apache.ivy.plugins.lock.CreateFileLockStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.plugins.lock.NIOFileLockStrategy;
import org.apache.ivy.plugins.lock.NoLockStrategy;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.matcher.RegexpPatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.report.LogReportOutputter;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.plugins.report.XmlReportOutputter;
import org.apache.ivy.plugins.resolver.AbstractWorkspaceResolver;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.DualResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.WorkspaceChainResolver;
import org.apache.ivy.plugins.signer.SignatureGenerator;
import org.apache.ivy.plugins.trigger.Trigger;
import org.apache.ivy.plugins.version.ChainVersionMatcher;
import org.apache.ivy.plugins.version.ExactVersionMatcher;
import org.apache.ivy.plugins.version.LatestVersionMatcher;
import org.apache.ivy.plugins.version.SubVersionMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.plugins.version.VersionRangeMatcher;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class IvySettings
implements SortEngineSettings,
PublishEngineSettings,
ParserSettings,
DeliverEngineSettings,
CheckEngineSettings,
InstallEngineSettings,
ResolverSettings,
ResolveEngineSettings,
RetrieveEngineSettings,
RepositoryManagementEngineSettings {
    private static final long INTERRUPT_TIMEOUT = 2000L;
    private Map<String, Class<?>> typeDefs = new HashMap();
    private Map<String, DependencyResolver> resolversMap = new HashMap<String, DependencyResolver>();
    private DependencyResolver defaultResolver;
    private DependencyResolver dictatorResolver = null;
    private String defaultResolverName;
    private File defaultCache;
    private String defaultBranch = null;
    private boolean checkUpToDate = true;
    private ModuleRules<ModuleSettings> moduleSettings = new ModuleRules();
    private Map<String, ConflictManager> conflictsManager = new HashMap<String, ConflictManager>();
    private Map<String, LatestStrategy> latestStrategies = new HashMap<String, LatestStrategy>();
    private Map<String, LockStrategy> lockStrategies = new HashMap<String, LockStrategy>();
    private Map<String, Namespace> namespaces = new HashMap<String, Namespace>();
    private Map<String, PatternMatcher> matchers = new HashMap<String, PatternMatcher>();
    private Map<String, ReportOutputter> reportOutputters = new HashMap<String, ReportOutputter>();
    private Map<String, VersionMatcher> versionMatchers = new HashMap<String, VersionMatcher>();
    private Map<String, CircularDependencyStrategy> circularDependencyStrategies = new HashMap<String, CircularDependencyStrategy>();
    private Map<String, RepositoryCacheManager> repositoryCacheManagers = new HashMap<String, RepositoryCacheManager>();
    private Map<String, SignatureGenerator> signatureGenerators = new HashMap<String, SignatureGenerator>();
    private List<Trigger> triggers = new ArrayList<Trigger>();
    private IvyVariableContainer variableContainer = new IvyVariableContainerImpl();
    private boolean validate = true;
    private LatestStrategy defaultLatestStrategy = null;
    private LockStrategy defaultLockStrategy = null;
    private ConflictManager defaultConflictManager = null;
    private CircularDependencyStrategy circularDependencyStrategy = null;
    private RepositoryCacheManager defaultRepositoryCacheManager = null;
    private ResolutionCacheManager resolutionCacheManager = null;
    private List<String> listingIgnore = new ArrayList<String>();
    private boolean repositoriesConfigured;
    private boolean useRemoteConfig = false;
    private File defaultUserDir;
    private File baseDir = new File(".").getAbsoluteFile();
    private List<URL> classpathURLs = new ArrayList<URL>();
    private ClassLoader classloader;
    private Boolean debugConflictResolution;
    private boolean logNotConvertedExclusionRule;
    private VersionMatcher versionMatcher;
    private StatusManager statusManager;
    private Boolean debugLocking;
    private Boolean dumpMemoryUsage;
    private String defaultCacheIvyPattern;
    private String defaultCacheArtifactPattern;
    private boolean defaultUseOrigin;
    private String defaultResolveMode = "default";
    private PackingRegistry packingRegistry = new PackingRegistry();
    private AbstractWorkspaceResolver workspaceResolver;
    private final Map<String, TimeoutConstraint> timeoutConstraints = new HashMap<String, TimeoutConstraint>();

    public IvySettings() {
        this(new IvyVariableContainerImpl());
    }

    public IvySettings(IvyVariableContainer variableContainer) {
        this.setVariableContainer(variableContainer);
        this.setVariable("ivy.default.settings.dir", this.getDefaultSettingsDir(), true);
        this.setVariable("ivy.basedir", this.getBaseDir().getAbsolutePath());
        this.setDeprecatedVariable("ivy.default.conf.dir", "ivy.default.settings.dir");
        String ivyTypeDefs = System.getProperty("ivy.typedef.files");
        if (ivyTypeDefs != null) {
            for (String file2 : StringUtils.splitToArray(ivyTypeDefs)) {
                try {
                    this.typeDefs(new FileInputStream(Checks.checkAbsolute(file2, "ivy.typedef.files")), true);
                }
                catch (FileNotFoundException e) {
                    Message.warn("typedefs file not found: " + file2);
                }
                catch (IOException e) {
                    Message.warn("problem with typedef file: " + file2, e);
                }
            }
        } else {
            try {
                this.typeDefs(IvySettings.getSettingsURL("typedef.properties").openStream(), true);
            }
            catch (IOException e) {
                Message.warn("impossible to load default type defs", e);
            }
        }
        LatestLexicographicStrategy latestLexicographicStrategy = new LatestLexicographicStrategy();
        LatestRevisionStrategy latestRevisionStrategy = new LatestRevisionStrategy();
        LatestTimeStrategy latestTimeStrategy = new LatestTimeStrategy();
        OsgiLatestStrategy osgiLatestStrategy = new OsgiLatestStrategy();
        this.addLatestStrategy("latest-revision", latestRevisionStrategy);
        this.addLatestStrategy("latest-lexico", latestLexicographicStrategy);
        this.addLatestStrategy("latest-time", latestTimeStrategy);
        this.addLatestStrategy("latest-osgi", osgiLatestStrategy);
        this.addLockStrategy("no-lock", new NoLockStrategy());
        this.addLockStrategy("artifact-lock", new CreateFileLockStrategy(this.debugLocking()));
        this.addLockStrategy("artifact-lock-nio", new NIOFileLockStrategy(this.debugLocking()));
        this.addConflictManager("latest-revision", new LatestConflictManager("latest-revision", latestRevisionStrategy));
        this.addConflictManager("latest-compatible", new LatestCompatibleConflictManager("latest-compatible", latestRevisionStrategy));
        this.addConflictManager("latest-time", new LatestConflictManager("latest-time", latestTimeStrategy));
        this.addConflictManager("all", new NoConflictManager());
        this.addConflictManager("strict", new StrictConflictManager());
        this.addMatcher(ExactPatternMatcher.INSTANCE);
        this.addMatcher(RegexpPatternMatcher.INSTANCE);
        this.addMatcher(ExactOrRegexpPatternMatcher.INSTANCE);
        try {
            Class<?> globClazz = IvySettings.class.getClassLoader().loadClass("org.apache.ivy.plugins.matcher.GlobPatternMatcher");
            Field instanceField = globClazz.getField("INSTANCE");
            this.addMatcher((PatternMatcher)instanceField.get(null));
        }
        catch (Exception e) {
            Message.info("impossible to define glob matcher: org.apache.ivy.plugins.matcher.GlobPatternMatcher was not found", e);
        }
        this.addReportOutputter(new LogReportOutputter());
        this.addReportOutputter(new XmlReportOutputter());
        this.configureDefaultCircularDependencyStrategies();
        this.listingIgnore.add(".cvsignore");
        this.listingIgnore.add("CVS");
        this.listingIgnore.add(".svn");
        this.listingIgnore.add("maven-metadata.xml");
        this.listingIgnore.add("maven-metadata.xml.md5");
        this.listingIgnore.add("maven-metadata.xml.sha1");
        this.addSystemProperties();
    }

    private synchronized void addSystemProperties() {
        try {
            this.addAllVariables((Map)System.getProperties().clone());
        }
        catch (AccessControlException ex) {
            Message.verbose("access denied to getting all system properties: they won't be available as Ivy variables.\nset " + ex.getPermission() + " permission if you want to access them");
        }
    }

    @Override
    public synchronized void configureRepositories(boolean remote) {
        if (!this.repositoriesConfigured) {
            Properties props;
            block9: {
                props = new Properties();
                boolean configured = false;
                if (this.useRemoteConfig && remote) {
                    try {
                        URL url2 = new URL("https://ant.apache.org/ivy/repository.properties");
                        Message.verbose("configuring repositories with " + url2);
                        props.load(URLHandlerRegistry.getDefault().openStream(url2));
                        configured = true;
                    }
                    catch (Exception ex) {
                        Message.verbose("unable to use remote repository configuration", ex);
                        props = new Properties();
                    }
                }
                if (!configured) {
                    InputStream repositoryPropsStream = null;
                    try {
                        repositoryPropsStream = IvySettings.getSettingsURL("repository.properties").openStream();
                        props.load(repositoryPropsStream);
                    }
                    catch (IOException e) {
                        Message.error("unable to use internal repository configuration", e);
                        if (repositoryPropsStream == null) break block9;
                        try {
                            repositoryPropsStream.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                }
            }
            this.addAllVariables(props, false);
            this.repositoriesConfigured = true;
        }
    }

    public synchronized void typeDefs(InputStream stream) throws IOException {
        this.typeDefs(stream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void typeDefs(InputStream stream, boolean silentFail) throws IOException {
        try {
            Properties p2 = new Properties();
            p2.load(stream);
            this.typeDefs(p2, silentFail);
        }
        finally {
            stream.close();
        }
    }

    public synchronized void typeDefs(Properties p2) {
        this.typeDefs(p2, false);
    }

    public synchronized void typeDefs(Properties p2, boolean silentFail) {
        for (Map.Entry<Object, Object> entry : p2.entrySet()) {
            this.typeDef(entry.getKey().toString(), entry.getValue().toString(), silentFail);
        }
    }

    public synchronized void load(File settingsFile) throws ParseException, IOException {
        Message.info(":: loading settings :: file = " + settingsFile);
        long start2 = System.currentTimeMillis();
        this.setSettingsVariables(settingsFile);
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.loadDefaultProperties();
        try {
            new XmlSettingsParser(this).parse(settingsFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("given file cannot be transformed to url: " + settingsFile, e);
        }
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        Message.verbose("settings loaded (" + (System.currentTimeMillis() - start2) + "ms)");
        this.dumpSettings();
    }

    public synchronized void load(URL settingsURL) throws ParseException, IOException {
        Message.info(":: loading settings :: url = " + settingsURL);
        long start2 = System.currentTimeMillis();
        this.setSettingsVariables(settingsURL);
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.loadDefaultProperties();
        new XmlSettingsParser(this).parse(settingsURL);
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        Message.verbose("settings loaded (" + (System.currentTimeMillis() - start2) + "ms)");
        this.dumpSettings();
    }

    public synchronized void defaultInit() throws IOException {
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.getDefaultCache();
        this.loadDefaultProperties();
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        this.dumpSettings();
    }

    public synchronized void loadDefault() throws ParseException, IOException {
        this.load(IvySettings.getDefaultSettingsURL());
    }

    public synchronized void loadDefault14() throws ParseException, IOException {
        this.load(IvySettings.getDefault14SettingsURL());
    }

    private void loadDefaultProperties() throws IOException {
        this.loadProperties(IvySettings.getDefaultPropertiesURL(), false);
    }

    public static URL getDefaultPropertiesURL() {
        return IvySettings.getSettingsURL("ivy.properties");
    }

    public static URL getDefaultSettingsURL() {
        return IvySettings.getSettingsURL("ivysettings.xml");
    }

    public static URL getDefault14SettingsURL() {
        return IvySettings.getSettingsURL("ivysettings-1.4.xml");
    }

    private String getDefaultSettingsDir() {
        String ivysettingsLocation = IvySettings.getDefaultSettingsURL().toExternalForm();
        return ivysettingsLocation.substring(0, ivysettingsLocation.length() - "ivysettings.xml".length() - 1);
    }

    private static URL getSettingsURL(String file2) {
        return XmlSettingsParser.class.getResource(file2);
    }

    public synchronized void setSettingsVariables(File settingsFile) {
        try {
            this.setVariable("ivy.settings.dir", new File(settingsFile.getAbsolutePath()).getParent());
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
            this.setVariable("ivy.settings.file", settingsFile.getAbsolutePath());
            this.setDeprecatedVariable("ivy.conf.file", "ivy.settings.file");
            this.setVariable("ivy.settings.url", settingsFile.toURI().toURL().toExternalForm());
            this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
            this.setVariable("ivy.settings.dir.url", new File(settingsFile.getAbsolutePath()).getParentFile().toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("given file cannot be transformed to url: " + settingsFile, e);
        }
    }

    private void setDeprecatedVariable(String deprecatedKey, String newKey) {
        this.setVariable(deprecatedKey, this.getVariable(newKey));
    }

    public synchronized void setSettingsVariables(URL settingsURL) {
        String settingsURLStr = settingsURL.toExternalForm();
        this.setVariable("ivy.settings.url", settingsURLStr);
        this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
        int slashIndex = settingsURLStr.lastIndexOf(47);
        if (slashIndex != -1) {
            String dirUrl = settingsURLStr.substring(0, slashIndex);
            this.setVariable("ivy.settings.dir", dirUrl);
            this.setVariable("ivy.settings.dir.url", dirUrl);
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
        } else {
            Message.warn("settings url does not contain any slash (/): ivy.settings.dir variable not set");
        }
    }

    private void dumpSettings() {
        Message.verbose("\tdefault cache: " + this.getDefaultCache());
        Message.verbose("\tdefault resolver: " + this.getDefaultResolver());
        Message.debug("\tdefault latest strategy: " + this.getDefaultLatestStrategy());
        Message.debug("\tdefault conflict manager: " + this.getDefaultConflictManager());
        Message.debug("\tcircular dependency strategy: " + this.getCircularDependencyStrategy());
        Message.debug("\tvalidate: " + this.doValidate());
        Message.debug("\tcheck up2date: " + this.isCheckUpToDate());
        if (!this.classpathURLs.isEmpty()) {
            Message.verbose("\t-- " + this.classpathURLs.size() + " custom classpath urls:");
            for (URL url2 : this.classpathURLs) {
                Message.debug("\t\t" + url2);
            }
        }
        Message.verbose("\t-- " + this.resolversMap.size() + " resolvers:");
        for (DependencyResolver resolver2 : this.resolversMap.values()) {
            resolver2.dumpSettings();
        }
        Message.debug("\tmodule settings:");
        this.moduleSettings.dump("\t\t");
    }

    public synchronized void loadProperties(URL url2) throws IOException {
        this.loadProperties(url2, true);
    }

    public synchronized void loadProperties(URL url2, boolean overwrite) throws IOException {
        this.loadProperties(url2.openStream(), overwrite);
    }

    public synchronized void loadProperties(File file2) throws IOException {
        this.loadProperties(file2, true);
    }

    public synchronized void loadProperties(File file2, boolean overwrite) throws IOException {
        this.loadProperties(new FileInputStream(file2), overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(InputStream stream, boolean overwrite) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(stream);
            this.addAllVariables(properties, overwrite);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void setVariable(String varName, String value2) {
        this.setVariable(varName, value2, true);
    }

    public synchronized void setVariable(String varName, String value2, boolean overwrite) {
        this.setVariable(varName, value2, overwrite, null, null);
    }

    public synchronized void setVariable(String varName, String value2, boolean overwrite, String ifSetVar, String unlessSetVar) {
        if (ifSetVar != null && this.variableContainer.getVariable(ifSetVar) == null) {
            Message.verbose("Not setting '" + varName + "' to '" + value2 + "' since '" + ifSetVar + "' is not set.");
            return;
        }
        if (unlessSetVar != null && this.variableContainer.getVariable(unlessSetVar) != null) {
            Message.verbose("Not setting '" + varName + "' to '" + value2 + "' since '" + unlessSetVar + "' is set.");
            return;
        }
        this.variableContainer.setVariable(varName, value2, overwrite);
    }

    public synchronized void addAllVariables(Map<?, ?> variables) {
        this.addAllVariables(variables, true);
    }

    public synchronized void addAllVariables(Map<?, ?> variables, boolean overwrite) {
        for (Map.Entry<?, ?> entry : variables.entrySet()) {
            Object val = entry.getValue();
            if (val != null && !(val instanceof String)) continue;
            this.setVariable(entry.getKey().toString(), (String)val, overwrite);
        }
    }

    @Override
    public synchronized String substitute(String str) {
        return IvyPatternHelper.substituteVariables(str, this.variableContainer);
    }

    @Override
    public synchronized Map<String, String> substitute(Map<String, String> strings) {
        LinkedHashMap<String, String> substituted = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : strings.entrySet()) {
            substituted.put(entry.getKey(), this.substitute(entry.getValue()));
        }
        return substituted;
    }

    @Override
    public synchronized IvyVariableContainer getVariables() {
        return this.variableContainer;
    }

    public synchronized Class<?> typeDef(String name2, String className2) {
        return this.typeDef(name2, className2, false);
    }

    public synchronized Class<?> typeDef(String name2, String className2, boolean silentFail) {
        Class<?> clazz = this.classForName(className2, silentFail);
        if (clazz != null) {
            this.typeDefs.put(name2, clazz);
        }
        return clazz;
    }

    private Class<?> classForName(String className2, boolean silentFail) {
        try {
            return this.getClassLoader().loadClass(className2);
        }
        catch (ClassNotFoundException e) {
            if (silentFail) {
                Message.info("impossible to define new type: class not found: " + className2 + " in " + this.classpathURLs + " nor Ivy classloader");
                return null;
            }
            throw new RuntimeException("impossible to define new type: class not found: " + className2 + " in " + this.classpathURLs + " nor Ivy classloader");
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classloader == null) {
            this.classloader = this.classpathURLs.isEmpty() ? Ivy.class.getClassLoader() : new URLClassLoader(this.classpathURLs.toArray(new URL[this.classpathURLs.size()]), Ivy.class.getClassLoader());
        }
        return this.classloader;
    }

    public synchronized void addClasspathURL(URL url2) {
        this.classpathURLs.add(url2);
        this.classloader = null;
    }

    public synchronized Map<String, Class<?>> getTypeDefs() {
        return this.typeDefs;
    }

    public synchronized Class<?> getTypeDef(String name2) {
        return this.typeDefs.get(name2);
    }

    public synchronized void addConfigured(DependencyResolver resolver2) {
        this.addResolver(resolver2);
    }

    public synchronized void addConfigured(ModuleDescriptorParser parser) {
        ModuleDescriptorParserRegistry.getInstance().addParser(parser);
    }

    public synchronized void addConfigured(SignatureGenerator generator) {
        this.addSignatureGenerator(generator);
    }

    public synchronized void addSignatureGenerator(SignatureGenerator generator) {
        this.init(generator);
        this.signatureGenerators.put(generator.getName(), generator);
    }

    @Override
    public synchronized SignatureGenerator getSignatureGenerator(String name2) {
        return this.signatureGenerators.get(name2);
    }

    public synchronized void addResolver(DependencyResolver resolver2) {
        if (resolver2 == null) {
            throw new NullPointerException("null resolver");
        }
        this.init(resolver2);
        this.resolversMap.put(resolver2.getName(), resolver2);
        if (resolver2 instanceof ChainResolver) {
            List<DependencyResolver> subresolvers = ((ChainResolver)resolver2).getResolvers();
            for (DependencyResolver dr : subresolvers) {
                this.addResolver(dr);
            }
        } else if (resolver2 instanceof DualResolver) {
            DependencyResolver artifactResolver;
            DependencyResolver ivyResolver = ((DualResolver)resolver2).getIvyResolver();
            if (ivyResolver != null) {
                this.addResolver(ivyResolver);
            }
            if ((artifactResolver = ((DualResolver)resolver2).getArtifactResolver()) != null) {
                this.addResolver(artifactResolver);
            }
        }
    }

    public synchronized void setDefaultCache(File cacheDirectory) {
        this.setVariable("ivy.cache.dir", cacheDirectory.getAbsolutePath(), false);
        this.defaultCache = cacheDirectory;
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.defaultCache);
        }
    }

    public synchronized void setDefaultResolver(String resolverName) {
        this.checkResolverName(resolverName);
        if (resolverName != null && !resolverName.equals(this.defaultResolverName)) {
            this.defaultResolver = null;
        }
        this.defaultResolverName = resolverName;
    }

    private void checkResolverName(String resolverName) {
        if (resolverName != null && !this.resolversMap.containsKey(resolverName)) {
            throw new IllegalArgumentException("no resolver found called " + resolverName + ": check your settings");
        }
    }

    public synchronized void addModuleConfiguration(Map<String, String> attributes, PatternMatcher matcher2, String resolverName, String branch2, String conflictManager, String resolveMode) {
        this.checkResolverName(resolverName);
        this.moduleSettings.defineRule(new MapMatcher(attributes, matcher2), new ModuleSettings(resolverName, branch2, conflictManager, resolveMode));
    }

    @Override
    public synchronized File resolveFile(String fileName) {
        return FileUtil.resolveFile(this.baseDir, fileName);
    }

    public synchronized void setBaseDir(File baseDir) {
        this.baseDir = baseDir.getAbsoluteFile();
        this.setVariable("ivy.basedir", this.baseDir.getAbsolutePath());
        this.setVariable("basedir", this.baseDir.getAbsolutePath(), false);
    }

    public synchronized File getBaseDir() {
        return this.baseDir;
    }

    public synchronized File getDefaultIvyUserDir() {
        if (this.defaultUserDir == null) {
            if (this.getVariable("ivy.home") != null) {
                this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.home"), "ivy.home"));
                Message.verbose("using ivy.default.ivy.user.dir variable for default ivy user dir: " + this.defaultUserDir);
            } else {
                this.setDefaultIvyUserDir(new File(System.getProperty("user.home"), ".ivy2"));
                Message.verbose("no default ivy user dir defined: set to " + this.defaultUserDir);
            }
        }
        return this.defaultUserDir;
    }

    public synchronized void setDefaultIvyUserDir(File defaultUserDir) {
        this.defaultUserDir = defaultUserDir;
        this.setVariable("ivy.default.ivy.user.dir", this.defaultUserDir.getAbsolutePath());
        this.setVariable("ivy.home", this.defaultUserDir.getAbsolutePath());
    }

    public synchronized File getDefaultCache() {
        if (this.defaultCache == null) {
            String cache = this.getVariable("ivy.cache.dir");
            if (cache != null) {
                this.defaultCache = Checks.checkAbsolute(cache, "ivy.cache.dir");
            } else {
                this.setDefaultCache(new File(this.getDefaultIvyUserDir(), "cache"));
                Message.verbose("no default cache defined: set to " + this.defaultCache);
            }
        }
        return this.defaultCache;
    }

    public synchronized void setDefaultRepositoryCacheBasedir(String repositoryCacheRoot) {
        this.setVariable("ivy.cache.repository", repositoryCacheRoot, true);
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.getDefaultRepositoryCacheBasedir());
        }
    }

    public synchronized void setDefaultResolutionCacheBasedir(String resolutionCacheRoot) {
        this.setVariable("ivy.cache.resolution", resolutionCacheRoot, true);
        if (this.resolutionCacheManager != null && this.resolutionCacheManager instanceof DefaultResolutionCacheManager) {
            ((DefaultResolutionCacheManager)this.resolutionCacheManager).setBasedir(this.getDefaultResolutionCacheBasedir());
        }
    }

    public synchronized File getDefaultRepositoryCacheBasedir() {
        String repositoryCacheRoot = this.getVariable("ivy.cache.repository");
        if (repositoryCacheRoot != null) {
            return Checks.checkAbsolute(repositoryCacheRoot, "ivy.cache.repository");
        }
        return this.getDefaultCache();
    }

    public synchronized File getDefaultResolutionCacheBasedir() {
        String resolutionCacheRoot = this.getVariable("ivy.cache.resolution");
        if (resolutionCacheRoot != null) {
            return Checks.checkAbsolute(resolutionCacheRoot, "ivy.cache.resolution");
        }
        return this.getDefaultCache();
    }

    @Override
    public synchronized void setDictatorResolver(DependencyResolver resolver2) {
        this.dictatorResolver = resolver2;
    }

    private DependencyResolver getDictatorResolver() {
        if (this.dictatorResolver == null) {
            return null;
        }
        if (this.workspaceResolver != null && !(this.dictatorResolver instanceof WorkspaceChainResolver)) {
            this.dictatorResolver = new WorkspaceChainResolver(this, this.dictatorResolver, this.workspaceResolver);
        }
        return this.dictatorResolver;
    }

    @Override
    public synchronized DependencyResolver getResolver(ModuleRevisionId mrid) {
        DependencyResolver r = this.getDictatorResolver();
        if (r != null) {
            return r;
        }
        String resolverName = this.getResolverName(mrid);
        return this.getResolver(resolverName);
    }

    public synchronized boolean hasResolver(String resolverName) {
        return this.resolversMap.containsKey(resolverName);
    }

    @Override
    public synchronized DependencyResolver getResolver(String resolverName) {
        DependencyResolver r = this.getDictatorResolver();
        if (r != null) {
            return r;
        }
        DependencyResolver resolver2 = this.resolversMap.get(resolverName);
        if (resolver2 == null) {
            Message.error("unknown resolver " + resolverName);
        } else if (this.workspaceResolver != null && !(resolver2 instanceof WorkspaceChainResolver)) {
            resolver2 = new WorkspaceChainResolver(this, resolver2, this.workspaceResolver);
            this.resolversMap.put(resolver2.getName(), resolver2);
            this.resolversMap.put(resolverName, resolver2);
        }
        return resolver2;
    }

    public synchronized DependencyResolver getDefaultResolver() {
        DependencyResolver r = this.getDictatorResolver();
        if (r != null) {
            return r;
        }
        if (this.defaultResolver == null) {
            this.defaultResolver = this.resolversMap.get(this.defaultResolverName);
        }
        if (this.workspaceResolver != null && !(this.defaultResolver instanceof WorkspaceChainResolver)) {
            this.defaultResolver = new WorkspaceChainResolver(this, this.defaultResolver, this.workspaceResolver);
        }
        return this.defaultResolver;
    }

    @Override
    public synchronized String getResolverName(ModuleRevisionId mrid) {
        ModuleSettings ms = this.moduleSettings.getRule(mrid, new Filter<ModuleSettings>(){

            @Override
            public boolean accept(ModuleSettings o) {
                return o.getResolverName() != null;
            }
        });
        return ms == null ? this.defaultResolverName : ms.getResolverName();
    }

    @Override
    public synchronized String getDefaultBranch(ModuleId moduleId) {
        ModuleSettings ms = this.moduleSettings.getRule(moduleId, new Filter<ModuleSettings>(){

            @Override
            public boolean accept(ModuleSettings o) {
                return o.getBranch() != null;
            }
        });
        return ms == null ? this.getDefaultBranch() : ms.getBranch();
    }

    public synchronized String getDefaultBranch() {
        return this.defaultBranch;
    }

    public synchronized void setDefaultBranch(String defaultBranch2) {
        this.defaultBranch = defaultBranch2;
    }

    @Override
    public synchronized ConflictManager getConflictManager(ModuleId moduleId) {
        ModuleSettings ms = this.moduleSettings.getRule(moduleId, new Filter<ModuleSettings>(){

            @Override
            public boolean accept(ModuleSettings o) {
                return o.getConflictManager() != null;
            }
        });
        if (ms == null) {
            return this.getDefaultConflictManager();
        }
        ConflictManager cm = this.getConflictManager(ms.getConflictManager());
        if (cm == null) {
            throw new IllegalStateException("ivy badly configured: unknown conflict manager " + ms.getConflictManager());
        }
        return cm;
    }

    @Override
    public synchronized String getResolveMode(ModuleId moduleId) {
        ModuleSettings ms = this.moduleSettings.getRule(moduleId, new Filter<ModuleSettings>(){

            @Override
            public boolean accept(ModuleSettings o) {
                return o.getResolveMode() != null;
            }
        });
        return ms == null ? this.getDefaultResolveMode() : ms.getResolveMode();
    }

    public synchronized String getDefaultResolveMode() {
        return this.defaultResolveMode;
    }

    public synchronized void setDefaultResolveMode(String defaultResolveMode) {
        this.defaultResolveMode = defaultResolveMode;
    }

    public synchronized void addConfigured(ConflictManager cm) {
        this.addConflictManager(cm.getName(), cm);
    }

    @Override
    public synchronized ConflictManager getConflictManager(String name2) {
        if ("default".equals(name2)) {
            return this.getDefaultConflictManager();
        }
        return this.conflictsManager.get(name2);
    }

    public synchronized void addConflictManager(String name2, ConflictManager cm) {
        this.init(cm);
        this.conflictsManager.put(name2, cm);
    }

    public synchronized void addConfigured(LatestStrategy latest) {
        this.addLatestStrategy(latest.getName(), latest);
    }

    @Override
    public synchronized LatestStrategy getLatestStrategy(String name2) {
        if ("default".equals(name2)) {
            return this.getDefaultLatestStrategy();
        }
        LatestStrategy strategy2 = this.latestStrategies.get(name2);
        if (this.workspaceResolver != null && !(strategy2 instanceof WorkspaceLatestStrategy)) {
            strategy2 = new WorkspaceLatestStrategy(strategy2);
            this.latestStrategies.put(name2, strategy2);
        }
        return strategy2;
    }

    public synchronized void addLatestStrategy(String name2, LatestStrategy latest) {
        this.init(latest);
        this.latestStrategies.put(name2, latest);
    }

    public synchronized void addConfigured(LockStrategy lockStrategy) {
        this.addLockStrategy(lockStrategy.getName(), lockStrategy);
    }

    public synchronized LockStrategy getLockStrategy(String name2) {
        if ("default".equals(name2)) {
            return this.getDefaultLockStrategy();
        }
        return this.lockStrategies.get(name2);
    }

    public synchronized void addLockStrategy(String name2, LockStrategy lockStrategy) {
        this.init(lockStrategy);
        this.lockStrategies.put(name2, lockStrategy);
    }

    public synchronized void addConfigured(Namespace ns) {
        this.addNamespace(ns);
    }

    @Override
    public synchronized Namespace getNamespace(String name2) {
        if ("system".equals(name2)) {
            return this.getSystemNamespace();
        }
        return this.namespaces.get(name2);
    }

    @Override
    public final Namespace getSystemNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    public synchronized void addNamespace(Namespace ns) {
        this.init(ns);
        this.namespaces.put(ns.getName(), ns);
    }

    public void addConfigured(NamedTimeoutConstraint timeoutConstraint) {
        if (timeoutConstraint == null) {
            return;
        }
        String name2 = timeoutConstraint.getName();
        StringUtils.assertNotNullNorEmpty(name2, "Name of a timeout constraint cannot be null or empty string");
        this.timeoutConstraints.put(name2, timeoutConstraint);
    }

    @Override
    public TimeoutConstraint getTimeoutConstraint(String name2) {
        return this.timeoutConstraints.get(name2);
    }

    public synchronized void addConfigured(PatternMatcher m2) {
        this.addMatcher(m2);
    }

    @Override
    public synchronized PatternMatcher getMatcher(String name2) {
        return this.matchers.get(name2);
    }

    public synchronized void addMatcher(PatternMatcher m2) {
        this.init(m2);
        this.matchers.put(m2.getName(), m2);
    }

    public synchronized void addConfigured(RepositoryCacheManager c) {
        this.addRepositoryCacheManager(c);
    }

    @Override
    public synchronized RepositoryCacheManager getRepositoryCacheManager(String name2) {
        return this.repositoryCacheManagers.get(name2);
    }

    public synchronized void addRepositoryCacheManager(RepositoryCacheManager c) {
        this.init(c);
        this.repositoryCacheManagers.put(c.getName(), c);
    }

    @Override
    public synchronized RepositoryCacheManager[] getRepositoryCacheManagers() {
        return this.repositoryCacheManagers.values().toArray(new RepositoryCacheManager[this.repositoryCacheManagers.size()]);
    }

    public synchronized void addConfigured(ReportOutputter outputter) {
        this.addReportOutputter(outputter);
    }

    public synchronized ReportOutputter getReportOutputter(String name2) {
        return this.reportOutputters.get(name2);
    }

    public synchronized void addReportOutputter(ReportOutputter outputter) {
        this.init(outputter);
        this.reportOutputters.put(outputter.getName(), outputter);
    }

    @Override
    public synchronized ReportOutputter[] getReportOutputters() {
        return this.reportOutputters.values().toArray(new ReportOutputter[this.reportOutputters.size()]);
    }

    public synchronized void addConfigured(VersionMatcher vmatcher) {
        this.addVersionMatcher(vmatcher);
    }

    public synchronized VersionMatcher getVersionMatcher(String name2) {
        return this.versionMatchers.get(name2);
    }

    public synchronized void addVersionMatcher(VersionMatcher vmatcher) {
        this.init(vmatcher);
        this.versionMatchers.put(vmatcher.getName(), vmatcher);
        if (this.versionMatcher == null) {
            this.versionMatcher = new ChainVersionMatcher();
            this.addVersionMatcher(new ExactVersionMatcher());
        }
        if (this.versionMatcher instanceof ChainVersionMatcher) {
            ChainVersionMatcher chain = (ChainVersionMatcher)this.versionMatcher;
            chain.add(vmatcher);
        }
    }

    public synchronized VersionMatcher[] getVersionMatchers() {
        return this.versionMatchers.values().toArray(new VersionMatcher[this.versionMatchers.size()]);
    }

    @Override
    public synchronized VersionMatcher getVersionMatcher() {
        if (this.versionMatcher == null) {
            this.configureDefaultVersionMatcher();
        }
        return this.versionMatcher;
    }

    public synchronized void configureDefaultVersionMatcher() {
        this.addVersionMatcher(new LatestVersionMatcher());
        this.addVersionMatcher(new SubVersionMatcher());
        this.addVersionMatcher(new VersionRangeMatcher());
    }

    @Override
    public synchronized CircularDependencyStrategy getCircularDependencyStrategy() {
        if (this.circularDependencyStrategy == null) {
            this.circularDependencyStrategy = this.getCircularDependencyStrategy("default");
        }
        return this.circularDependencyStrategy;
    }

    public synchronized CircularDependencyStrategy getCircularDependencyStrategy(String name2) {
        if ("default".equals(name2)) {
            name2 = "warn";
        }
        return this.circularDependencyStrategies.get(name2);
    }

    public synchronized void setCircularDependencyStrategy(CircularDependencyStrategy strategy2) {
        this.circularDependencyStrategy = strategy2;
    }

    public synchronized void addConfigured(CircularDependencyStrategy strategy2) {
        this.addCircularDependencyStrategy(strategy2);
    }

    private void addCircularDependencyStrategy(CircularDependencyStrategy strategy2) {
        this.circularDependencyStrategies.put(strategy2.getName(), strategy2);
    }

    private void configureDefaultCircularDependencyStrategies() {
        this.addCircularDependencyStrategy(WarnCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(ErrorCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(IgnoreCircularDependencyStrategy.getInstance());
    }

    @Override
    public synchronized StatusManager getStatusManager() {
        if (this.statusManager == null) {
            this.statusManager = StatusManager.newDefaultInstance();
        }
        return this.statusManager;
    }

    public void setStatusManager(StatusManager statusManager) {
        this.statusManager = statusManager;
    }

    @Override
    public synchronized String[] getIgnorableFilenames() {
        return this.listingIgnore.toArray(new String[this.listingIgnore.size()]);
    }

    @Override
    public synchronized void filterIgnore(Collection<String> names2) {
        names2.removeAll(this.listingIgnore);
    }

    @Override
    public synchronized boolean isCheckUpToDate() {
        return this.checkUpToDate;
    }

    public synchronized void setCheckUpToDate(boolean checkUpToDate) {
        this.checkUpToDate = checkUpToDate;
    }

    @Override
    public synchronized boolean doValidate() {
        return this.validate;
    }

    public synchronized void setValidate(boolean validate) {
        this.validate = validate;
    }

    @Override
    public synchronized String getVariable(String name2) {
        return this.variableContainer.getVariable(name2);
    }

    public synchronized boolean getVariableAsBoolean(String name2, boolean valueIfUnset) {
        String var = this.getVariable(name2);
        return var == null ? valueIfUnset : Boolean.valueOf(var);
    }

    public synchronized ConflictManager getDefaultConflictManager() {
        if (this.defaultConflictManager == null) {
            this.defaultConflictManager = new LatestConflictManager(this.getDefaultLatestStrategy());
            ((LatestConflictManager)this.defaultConflictManager).setSettings(this);
        }
        return this.defaultConflictManager;
    }

    public synchronized void setDefaultConflictManager(ConflictManager defaultConflictManager) {
        this.defaultConflictManager = defaultConflictManager;
    }

    @Override
    public synchronized LatestStrategy getDefaultLatestStrategy() {
        if (this.defaultLatestStrategy == null) {
            this.defaultLatestStrategy = new LatestRevisionStrategy();
        }
        if (this.workspaceResolver != null && !(this.defaultLatestStrategy instanceof WorkspaceLatestStrategy)) {
            this.defaultLatestStrategy = new WorkspaceLatestStrategy(this.defaultLatestStrategy);
        }
        return this.defaultLatestStrategy;
    }

    public synchronized void setDefaultLatestStrategy(LatestStrategy defaultLatestStrategy) {
        this.defaultLatestStrategy = defaultLatestStrategy;
    }

    public synchronized LockStrategy getDefaultLockStrategy() {
        if (this.defaultLockStrategy == null) {
            this.defaultLockStrategy = new NoLockStrategy();
        }
        return this.defaultLockStrategy;
    }

    public synchronized void setDefaultLockStrategy(LockStrategy defaultLockStrategy) {
        this.defaultLockStrategy = defaultLockStrategy;
    }

    @Override
    public synchronized RepositoryCacheManager getDefaultRepositoryCacheManager() {
        if (this.defaultRepositoryCacheManager == null) {
            this.defaultRepositoryCacheManager = new DefaultRepositoryCacheManager("default-cache", this, this.getDefaultRepositoryCacheBasedir());
            this.addRepositoryCacheManager(this.defaultRepositoryCacheManager);
        }
        return this.defaultRepositoryCacheManager;
    }

    public synchronized void setDefaultRepositoryCacheManager(RepositoryCacheManager cache) {
        this.defaultRepositoryCacheManager = cache;
    }

    @Override
    public synchronized ResolutionCacheManager getResolutionCacheManager() {
        if (this.resolutionCacheManager == null) {
            this.resolutionCacheManager = new DefaultResolutionCacheManager(this.getDefaultResolutionCacheBasedir());
            this.init(this.resolutionCacheManager);
        }
        return this.resolutionCacheManager;
    }

    public synchronized void setResolutionCacheManager(ResolutionCacheManager resolutionCacheManager) {
        this.resolutionCacheManager = resolutionCacheManager;
    }

    public synchronized void addTrigger(Trigger trigger2) {
        this.init(trigger2);
        this.triggers.add(trigger2);
    }

    public synchronized List<Trigger> getTriggers() {
        return this.triggers;
    }

    public synchronized void addConfigured(Trigger trigger2) {
        this.addTrigger(trigger2);
    }

    public synchronized boolean isUseRemoteConfig() {
        return this.useRemoteConfig;
    }

    public synchronized void setUseRemoteConfig(boolean useRemoteConfig) {
        this.useRemoteConfig = useRemoteConfig;
    }

    public synchronized boolean logModulesInUse() {
        return this.getVariableAsBoolean("ivy.log.modules.in.use", true);
    }

    @Override
    public synchronized boolean logModuleWhenFound() {
        return this.getVariableAsBoolean("ivy.log.module.when.found", true);
    }

    @Override
    public synchronized boolean logResolvedRevision() {
        return this.getVariableAsBoolean("ivy.log.resolved.revision", true);
    }

    @Override
    public synchronized boolean debugConflictResolution() {
        if (this.debugConflictResolution == null) {
            this.debugConflictResolution = this.getVariableAsBoolean("ivy.log.conflict.resolution", false);
        }
        return this.debugConflictResolution;
    }

    public synchronized boolean debugLocking() {
        if (this.debugLocking == null) {
            this.debugLocking = this.getVariableAsBoolean("ivy.log.locking", false);
        }
        return this.debugLocking;
    }

    @Override
    public synchronized boolean dumpMemoryUsage() {
        if (this.dumpMemoryUsage == null) {
            this.dumpMemoryUsage = this.getVariableAsBoolean("ivy.log.memory", false);
        }
        return this.dumpMemoryUsage;
    }

    @Override
    public synchronized boolean logNotConvertedExclusionRule() {
        return this.logNotConvertedExclusionRule;
    }

    @Override
    public synchronized void setLogNotConvertedExclusionRule(boolean logNotConvertedExclusionRule) {
        this.logNotConvertedExclusionRule = logNotConvertedExclusionRule;
    }

    private void init(Object obj) {
        if (obj instanceof IvySettingsAware) {
            ((IvySettingsAware)obj).setSettings(this);
        } else if (obj instanceof DependencyResolver) {
            ((DependencyResolver)obj).setSettings(this);
        }
    }

    public final long getInterruptTimeout() {
        return 2000L;
    }

    public synchronized Collection<DependencyResolver> getResolvers() {
        return this.resolversMap.values();
    }

    @Override
    public synchronized Collection<String> getResolverNames() {
        return this.resolversMap.keySet();
    }

    @Override
    public synchronized Collection<String> getMatcherNames() {
        return this.matchers.keySet();
    }

    public synchronized IvyVariableContainer getVariableContainer() {
        return this.variableContainer;
    }

    public synchronized void setVariableContainer(IvyVariableContainer variables) {
        this.variableContainer = variables;
    }

    @Override
    public synchronized RelativeUrlResolver getRelativeUrlResolver() {
        return new NormalRelativeUrlResolver();
    }

    public synchronized void setDefaultCacheIvyPattern(String defaultCacheIvyPattern) {
        CacheUtil.checkCachePattern(defaultCacheIvyPattern);
        this.defaultCacheIvyPattern = defaultCacheIvyPattern;
    }

    public synchronized String getDefaultCacheIvyPattern() {
        return this.defaultCacheIvyPattern;
    }

    public synchronized void setDefaultCacheArtifactPattern(String defaultCacheArtifactPattern) {
        CacheUtil.checkCachePattern(defaultCacheArtifactPattern);
        this.defaultCacheArtifactPattern = defaultCacheArtifactPattern;
    }

    public synchronized String getDefaultCacheArtifactPattern() {
        return this.defaultCacheArtifactPattern;
    }

    public synchronized void setDefaultUseOrigin(boolean useOrigin) {
        this.defaultUseOrigin = useOrigin;
    }

    public synchronized boolean isDefaultUseOrigin() {
        return this.defaultUseOrigin;
    }

    public synchronized void useDeprecatedUseOrigin() {
        Message.deprecated("useOrigin option is deprecated when calling resolve, use useOrigin setting on the cache implementation instead");
        this.setDefaultUseOrigin(true);
    }

    public synchronized void validate() {
        this.validateAll(this.resolversMap.values());
        this.validateAll(this.conflictsManager.values());
        this.validateAll(this.latestStrategies.values());
        this.validateAll(this.lockStrategies.values());
        this.validateAll(this.repositoryCacheManagers.values());
        this.validateAll(this.reportOutputters.values());
        this.validateAll(this.circularDependencyStrategies.values());
        this.validateAll(this.versionMatchers.values());
        this.validateAll(this.namespaces.values());
    }

    private void validateAll(Collection<?> values2) {
        for (Object object : values2) {
            if (!(object instanceof Validatable)) continue;
            ((Validatable)object).validate();
        }
    }

    @Override
    public Namespace getContextNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    public synchronized void addConfigured(ArchivePacking packing) {
        this.init(packing);
        this.packingRegistry.register(packing);
    }

    public PackingRegistry getPackingRegistry() {
        return this.packingRegistry;
    }

    public void addConfigured(AbstractWorkspaceResolver workspaceResolver) {
        this.workspaceResolver = workspaceResolver;
        if (workspaceResolver != null) {
            workspaceResolver.setSettings(this);
            DefaultRepositoryCacheManager cacheManager = new DefaultRepositoryCacheManager();
            String cacheName = "workspace-resolver-cache-" + workspaceResolver.getName();
            cacheManager.setBasedir(new File(this.getDefaultCache(), cacheName));
            cacheManager.setCheckmodified(true);
            cacheManager.setUseOrigin(true);
            cacheManager.setName(cacheName);
            this.addRepositoryCacheManager(cacheManager);
            workspaceResolver.setCache(cacheName);
        }
    }

    private static class ModuleSettings {
        private String resolverName;
        private String branch;
        private String conflictManager;
        private String resolveMode;

        public ModuleSettings(String resolver2, String branchName, String conflictMgr, String resolveMode) {
            this.resolverName = resolver2;
            this.branch = branchName;
            this.conflictManager = conflictMgr;
            this.resolveMode = resolveMode;
        }

        public String toString() {
            return (this.resolverName != null ? "resolver: " + this.resolverName : "") + (this.branch != null ? "branch: " + this.branch : "") + (this.conflictManager != null ? "conflictManager: " + this.conflictManager : "") + (this.resolveMode != null ? "resolveMode: " + this.resolveMode : "");
        }

        public String getBranch() {
            return this.branch;
        }

        public String getResolverName() {
            return this.resolverName;
        }

        public String getConflictManager() {
            return this.conflictManager;
        }

        public String getResolveMode() {
            return this.resolveMode;
        }
    }
}

