/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocation;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.impl.UtilsKt;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryRoot;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.AbstractEclipseClasspathReader;
import org.jetbrains.idea.eclipse.EPathCommonUtil;
import org.jetbrains.idea.eclipse.config.EclipseModuleRootsSerializer;
import org.jetbrains.idea.eclipse.config.EclipseProjectFile;
import org.jetbrains.idea.eclipse.config.ModulePathShortener;
import org.jetbrains.idea.eclipse.config.ModuleRelativePathResolver;
import org.jetbrains.idea.eclipse.conversion.EJavadocUtil;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u001a(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a*\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a*\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u001a(\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0018\u0010$\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a*\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020'2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\"\u0010*\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\"\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\u000b2\u0006\u0010.\u001a\u00020\u0010H\u0000\u001a\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00060"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "mainContentRoot", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ContentRootEntity;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleEntity;", "getMainContentRoot", "(Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleEntity;)Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ContentRootEntity;", "convertRelativePathToUrl", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "path", "", "contentRootEntity", "pathResolver", "Lorg/jetbrains/idea/eclipse/config/ModuleRelativePathResolver;", "virtualUrlManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "convertToEclipseJavadocPath", "javadocRoot", "module", "projectLocation", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;", "pathShortener", "Lorg/jetbrains/idea/eclipse/config/ModulePathShortener;", "convertToEclipsePath", "fileUrl", "moduleEntity", "entitySource", "Lorg/jetbrains/idea/eclipse/config/EclipseProjectFile;", "convertToEclipsePathWithVariable", "roots", "", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/LibraryRoot;", "convertToJavadocUrl", "originalPath", "relativePathResolver", "convertToRootUrl", "convertVariablePathToUrl", "pathMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "varStart", "", "findFileUnderContentRoot", "getStorageRoot", "imlFileUrl", "customDir", "virtualFileManager", "pathToUrl", "intellij.eclipse"})
public final class PathConversionKt {
    private static final Logger LOG;

    @NotNull
    public static final VirtualFileUrl convertToJavadocUrl(@NotNull String originalPath, @NotNull ModuleEntity moduleEntity, @NotNull ModuleRelativePathResolver relativePathResolver, @NotNull VirtualFileUrlManager virtualUrlManager) {
        String javadocPath;
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)relativePathResolver, (String)"relativePathResolver");
        Intrinsics.checkNotNullParameter((Object)virtualUrlManager, (String)"virtualUrlManager");
        String string = javadocPath = !SystemInfo.isWindows ? StringsKt.replaceFirst$default((String)originalPath, (String)"file:/", (String)"file://", (boolean)false, (int)4, null) : originalPath;
        if (StringsKt.startsWith$default((String)javadocPath, (String)"file:/", (boolean)false, (int)2, null)) {
            String path = StringsKt.removePrefix((String)javadocPath, (CharSequence)"file:/");
            if (new File(path).exists()) {
                return virtualUrlManager.fromUrl(PathConversionKt.pathToUrl(path));
            }
        } else {
            String protocol = VirtualFileManager.extractProtocol((String)javadocPath);
            HttpFileSystem httpFileSystem = HttpFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)httpFileSystem, (String)"HttpFileSystem.getInstance()");
            if (Intrinsics.areEqual((Object)protocol, (Object)httpFileSystem.getProtocol())) {
                return virtualUrlManager.fromUrl(javadocPath);
            }
            if (StringsKt.startsWith$default((String)javadocPath, (String)"jar:", (boolean)false, (int)2, null)) {
                String jarJavadocPath = StringsKt.removePrefix((String)javadocPath, (CharSequence)"jar:");
                if (StringsKt.startsWith$default((String)jarJavadocPath, (String)"platform:/", (boolean)false, (int)2, null)) {
                    String string2 = jarJavadocPath;
                    int n = 18;
                    String string3 = string2.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                    String relativeToPlatform = string3;
                    ContentRootEntity contentRootEntity = PathConversionKt.getMainContentRoot(moduleEntity);
                    VirtualFile currentRoot = contentRootEntity != null && (contentRootEntity = contentRootEntity.getUrl()) != null ? UtilsKt.getVirtualFile((VirtualFileUrl)contentRootEntity) : null;
                    Object object = currentRoot;
                    if (object == null || (object = object.getParent()) == null || (object = object.getPath()) == null) {
                        EntitySource entitySource2 = moduleEntity.getEntitySource();
                        if (entitySource2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.idea.eclipse.config.EclipseProjectFile");
                        }
                        object = JpsPathUtil.urlToPath((String)((EclipseProjectFile)entitySource2).getInternalSource().getProjectLocation().getBaseDirectoryUrl().getUrl());
                    }
                    Object basePath = object;
                    String currentModulePath = (String)basePath + relativeToPlatform;
                    if (EJavadocUtil.isJarFileExist(currentModulePath)) {
                        String string4 = VirtualFileManager.constructUrl((String)"jar", (String)currentModulePath);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"VirtualFileManager.const\u2026TOCOL, currentModulePath)");
                        return virtualUrlManager.fromUrl(string4);
                    }
                    String string5 = EPathCommonUtil.getRelativeModuleName((String)relativeToPlatform);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"EPathCommonUtil.getRelat\u2026eName(relativeToPlatform)");
                    String moduleName = string5;
                    String relativeToModulePathWithJarSuffix = EPathCommonUtil.getRelativeToModulePath((String)relativeToPlatform);
                    String relativeToModulePath = EJavadocUtil.stripPathInsideJar(relativeToModulePathWithJarSuffix);
                    Object url = null;
                    if (Intrinsics.areEqual((Object)moduleName, (Object)moduleEntity.getName()) ^ true) {
                        url = relativePathResolver.resolve(moduleName, relativeToModulePath);
                    }
                    if (url != null) {
                        boolean bl;
                        boolean bl2 = bl = relativeToModulePathWithJarSuffix != null;
                        if (_Assertions.ENABLED && !bl) {
                            String string6 = "Assertion failed";
                            throw new AssertionError((Object)string6);
                        }
                        boolean bl3 = bl = relativeToModulePath != null;
                        if (_Assertions.ENABLED && !bl) {
                            String string7 = "Assertion failed";
                            throw new AssertionError((Object)string7);
                        }
                        String string8 = relativeToModulePath;
                        Intrinsics.checkNotNull((Object)string8);
                        int n2 = string8.length();
                        String string9 = relativeToModulePathWithJarSuffix;
                        Intrinsics.checkNotNull((Object)string9);
                        if (n2 < string9.length()) {
                            String string10 = relativeToModulePathWithJarSuffix;
                            int n3 = relativeToModulePath.length();
                            String string11 = string10.substring(n3);
                            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"this as java.lang.String).substring(startIndex)");
                            url = (String)url + string11;
                        }
                        String string12 = VirtualFileManager.constructUrl((String)"jar", (String)VfsUtil.urlToPath((String)url));
                        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"VirtualFileManager.const\u2026, VfsUtil.urlToPath(url))");
                        return virtualUrlManager.fromUrl(string12);
                    }
                } else if (StringsKt.startsWith$default((String)jarJavadocPath, (String)"file:/", (boolean)false, (int)2, null)) {
                    String string13 = jarJavadocPath;
                    int n = "file:/".length();
                    String string14 = string13.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"this as java.lang.String).substring(startIndex)");
                    String localFile = string14;
                    if (EJavadocUtil.isJarFileExist(localFile)) {
                        String string15 = VirtualFileManager.constructUrl((String)"jar", (String)localFile);
                        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"VirtualFileManager.const\u2026stem.PROTOCOL, localFile)");
                        return virtualUrlManager.fromUrl(string15);
                    }
                }
            }
        }
        return virtualUrlManager.fromUrl(javadocPath);
    }

    @Nullable
    public static final String convertToEclipseJavadocPath(@NotNull VirtualFileUrl javadocRoot, @NotNull ModuleEntity module, @NotNull JpsProjectConfigLocation projectLocation, @NotNull ModulePathShortener pathShortener) {
        Intrinsics.checkNotNullParameter((Object)javadocRoot, (String)"javadocRoot");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)projectLocation, (String)"projectLocation");
        Intrinsics.checkNotNullParameter((Object)pathShortener, (String)"pathShortener");
        String javadocUrl = javadocRoot.getUrl();
        String protocol = VirtualFileManager.extractProtocol((String)javadocUrl);
        HttpFileSystem httpFileSystem = HttpFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)httpFileSystem, (String)"HttpFileSystem.getInstance()");
        if (Intrinsics.areEqual((Object)protocol, (Object)httpFileSystem.getProtocol()) ^ true) {
            String string = VfsUtil.urlToPath((String)javadocUrl);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtil.urlToPath(javadocUrl)");
            String path = string;
            ContentRootEntity contentRootEntity = PathConversionKt.getMainContentRoot(module);
            VirtualFile contentRoot = contentRootEntity != null && (contentRootEntity = contentRootEntity.getUrl()) != null ? UtilsKt.getVirtualFile((VirtualFileUrl)contentRootEntity) : null;
            VirtualFile baseDir = contentRoot != null ? contentRoot.getParent() : UtilsKt.getVirtualFile((VirtualFileUrl)projectLocation.getBaseDirectoryUrl());
            JarFileSystem jarFileSystem = JarFileSystem.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)jarFileSystem, (String)"JarFileSystem.getInstance()");
            if (Intrinsics.areEqual((Object)protocol, (Object)jarFileSystem.getProtocol())) {
                VirtualFile javadocFile = JarFileSystem.getInstance().getVirtualFileForJar(UtilsKt.getVirtualFile((VirtualFileUrl)javadocRoot));
                if (javadocFile != null) {
                    String relativeUrl;
                    String string2 = relativeUrl = contentRoot != null && baseDir != null && VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)javadocFile, (boolean)false) ? "/" + VfsUtilCore.getRelativePath((VirtualFile)javadocFile, (VirtualFile)baseDir, (char)'/') : pathShortener.shortenPath(javadocFile);
                    if (relativeUrl != null) {
                        Object javadocPath = javadocUrl;
                        String string3 = javadocPath;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"javadocPath");
                        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"!/", (boolean)false, (int)2, null)) {
                            javadocPath = StringUtil.trimEnd((String)javadocPath, (String)"/") + "!/";
                        }
                        String string4 = javadocPath;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"javadocPath");
                        String string5 = string4;
                        int n = javadocFile.getUrl().length() - 1;
                        String string6 = string5.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                        return "jar:platform:/resource" + relativeUrl + string6;
                    }
                    return "jar:file:/" + StringsKt.removePrefix((String)path, (CharSequence)"/");
                }
                return "jar:file:/" + StringsKt.removePrefix((String)path, (CharSequence)"/");
            }
            if (new File(path).exists()) {
                return "file:/" + StringsKt.removePrefix((String)path, (CharSequence)"/");
            }
        }
        return javadocUrl;
    }

    @NotNull
    public static final VirtualFileUrl convertToRootUrl(@NotNull String path, @NotNull VirtualFileUrlManager virtualUrlManager) {
        VirtualFile jarFile;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)virtualUrlManager, (String)"virtualUrlManager");
        String url = PathConversionKt.pathToUrl(path);
        VirtualFile localFile = VirtualFileManager.getInstance().findFileByUrl(url);
        if (localFile != null && (jarFile = JarFileSystem.getInstance().getJarRootForLocalFile(localFile)) != null) {
            String string = jarFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarFile.url");
            return virtualUrlManager.fromUrl(string);
        }
        return virtualUrlManager.fromUrl(url);
    }

    @NotNull
    public static final String pathToUrl(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = JpsPathUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)path));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JpsPathUtil.pathToUrl(Fi\u2026temIndependentName(path))");
        return string;
    }

    @NotNull
    public static final VirtualFileUrl convertVariablePathToUrl(@NotNull ExpandMacroToPathMap pathMap, @Nullable String path, int varStart, @NotNull VirtualFileUrlManager virtualUrlManager) {
        AbstractEclipseClasspathReader.EPathVariable variable;
        Intrinsics.checkNotNullParameter((Object)pathMap, (String)"pathMap");
        Intrinsics.checkNotNullParameter((Object)virtualUrlManager, (String)"virtualUrlManager");
        AbstractEclipseClasspathReader.EPathVariable ePathVariable = variable = AbstractEclipseClasspathReader.createEPathVariable((String)path, (int)varStart);
        Intrinsics.checkNotNullExpressionValue((Object)ePathVariable, (String)"variable");
        String string = AbstractEclipseClasspathReader.getVariableRelatedPath((String)ePathVariable.getVariable(), (String)variable.getRelatedPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AbstractEclipseClasspath\u2026le, variable.relatedPath)");
        String pathWithVariable = string;
        String string2 = pathMap.substitute(pathWithVariable, SystemInfo.isFileSystemCaseSensitive);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathMap.substitute(pathW\u2026sFileSystemCaseSensitive)");
        return PathConversionKt.convertToRootUrl(string2, virtualUrlManager);
    }

    @NotNull
    public static final VirtualFileUrl convertRelativePathToUrl(@NotNull String path, @NotNull ContentRootEntity contentRootEntity, @NotNull ModuleRelativePathResolver pathResolver, @NotNull VirtualFileUrlManager virtualUrlManager) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)contentRootEntity, (String)"contentRootEntity");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        Intrinsics.checkNotNullParameter((Object)virtualUrlManager, (String)"virtualUrlManager");
        if (!new File(path).exists()) {
            if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                String url;
                String string = EPathCommonUtil.getRelativeModuleName((String)path);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EPathCommonUtil.getRelativeModuleName(path)");
                String moduleName = string;
                String relativeToRootPath = EPathCommonUtil.getRelativeToModulePath((String)path);
                if (Intrinsics.areEqual((Object)moduleName, (Object)contentRootEntity.getModule().getName()) ^ true && (url = pathResolver.resolve(moduleName, relativeToRootPath)) != null) {
                    return virtualUrlManager.fromUrl(url);
                }
            } else {
                VirtualFileUrl url = PathConversionKt.findFileUnderContentRoot(path, contentRootEntity, virtualUrlManager);
                if (url != null) {
                    return url;
                }
            }
        }
        return PathConversionKt.convertToRootUrl(path, virtualUrlManager);
    }

    private static final VirtualFileUrl findFileUnderContentRoot(String path, ContentRootEntity contentRootEntity, VirtualFileUrlManager virtualUrlManager) {
        VirtualFileUrl virtualFileUrl;
        File file;
        File root = VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)contentRootEntity.getUrl()).toFile();
        if (root.exists()) {
            file = root;
        } else {
            ContentRootEntity contentRootEntity2 = PathConversionKt.getMainContentRoot(contentRootEntity.getModule());
            VirtualFileUrl fileUrl = contentRootEntity2 != null ? contentRootEntity2.getUrl() : null;
            file = fileUrl != null ? VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)fileUrl).toFile() : null;
        }
        File mainRoot = file;
        File file2 = new File(mainRoot, path);
        if (file2.exists()) {
            String string = file2.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
            virtualFileUrl = PathConversionKt.convertToRootUrl(string, virtualUrlManager);
        } else {
            virtualFileUrl = null;
        }
        return virtualFileUrl;
    }

    @Nullable
    public static final ContentRootEntity getMainContentRoot(@NotNull ModuleEntity $this$mainContentRoot) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$mainContentRoot, (String)"$this$mainContentRoot");
            Iterable $this$firstOrNull$iv = $this$mainContentRoot.getContentRoots();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ContentRootEntity it = (ContentRootEntity)element$iv;
                boolean bl = false;
                VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(it.getUrl().getUrl());
                if (!((virtualFile != null ? virtualFile.findChild(".project") : null) != null)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public static final VirtualFileUrl getStorageRoot(@NotNull VirtualFileUrl imlFileUrl, @Nullable String customDir, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)imlFileUrl, (String)"imlFileUrl");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        VirtualFileUrl virtualFileUrl = virtualFileManager.getParentVirtualUrl(imlFileUrl);
        Intrinsics.checkNotNull((Object)virtualFileUrl);
        VirtualFileUrl moduleRoot = virtualFileUrl;
        if (customDir == null) {
            return moduleRoot;
        }
        if (OSAgnosticPathUtil.isAbsolute((String)customDir)) {
            return virtualFileManager.fromPath(customDir);
        }
        VirtualFileUrl virtualFileUrl2 = moduleRoot.append(customDir);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl2, (String)"moduleRoot.append(customDir)");
        return virtualFileUrl2;
    }

    @Nullable
    public static final String convertToEclipsePath(@NotNull VirtualFileUrl fileUrl, @NotNull ModuleEntity moduleEntity, @NotNull EclipseProjectFile entitySource2, @NotNull ModulePathShortener pathShortener) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)entitySource2, (String)"entitySource");
        Intrinsics.checkNotNullParameter((Object)pathShortener, (String)"pathShortener");
        ContentRootEntity contentRootEntity = PathConversionKt.getMainContentRoot(moduleEntity);
        if (contentRootEntity != null) {
            ContentRootEntity contentRootEntity2;
            ContentRootEntity it = contentRootEntity2 = contentRootEntity;
            boolean bl = false;
            virtualFile = VirtualFileManager.getInstance().findFileByUrl(it.getUrl().getUrl());
        } else {
            virtualFile = null;
        }
        VirtualFile contentRoot = virtualFile;
        VirtualFile file = UtilsKt.getVirtualFile((VirtualFileUrl)fileUrl);
        String url = fileUrl.getUrl();
        if (file != null) {
            LOG.assertTrue(file.isValid());
            if (file.getFileSystem() instanceof JarFileSystem) {
                VirtualFile jarFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
                if (jarFile == null) {
                    LOG.error("Url: '" + url + "'; file: " + file);
                    return ProjectRootManagerImpl.extractLocalPath((String)url);
                }
                file = jarFile;
            }
            if (contentRoot != null && VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) {
                return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)'/');
            }
            String path = pathShortener.shortenPath(file);
            if (path != null) {
                return path;
            }
        } else {
            VirtualFile projectBaseDir;
            VirtualFile virtualFile2;
            if (contentRoot != null) {
                String string = contentRoot.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contentRoot.url");
                String rootUrl = string;
                String string2 = url;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url");
                if (StringsKt.startsWith$default((String)string2, (String)rootUrl, (boolean)false, (int)2, null) && url.length() > rootUrl.length()) {
                    String string3 = url;
                    int n = rootUrl.length() + 1;
                    String string4 = string3.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    return string4;
                }
            }
            if (contentRoot != null) {
                virtualFile2 = contentRoot.getParent();
            } else {
                VirtualFile virtualFile3 = UtilsKt.getVirtualFile((VirtualFileUrl)entitySource2.getInternalSource().getProjectLocation().getBaseDirectoryUrl());
                virtualFile2 = virtualFile3;
                Intrinsics.checkNotNull((Object)virtualFile3);
            }
            VirtualFile virtualFile4 = projectBaseDir = virtualFile2;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"projectBaseDir");
            String string = virtualFile4.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectBaseDir.url");
            String projectUrl = string;
            String string5 = url;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"url");
            if (StringsKt.startsWith$default((String)string5, (String)projectUrl, (boolean)false, (int)2, null)) {
                String string6 = url;
                int n = projectUrl.length();
                String string7 = string6.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                return string7;
            }
            String string8 = VfsUtilCore.urlToPath((String)url);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"VfsUtilCore.urlToPath(url)");
            String path = string8;
            String string9 = projectBaseDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"projectBaseDir.path");
            String projectPath = string9;
            if (StringsKt.startsWith$default((String)path, (String)projectPath, (boolean)false, (int)2, null)) {
                String string10 = path;
                int n = projectPath.length();
                String string11 = string10.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"this as java.lang.String).substring(startIndex)");
                return ProjectRootManagerImpl.extractLocalPath((String)string11);
            }
        }
        return ProjectRootManagerImpl.extractLocalPath((String)url);
    }

    @Nullable
    public static final String convertToEclipsePathWithVariable(@NotNull List<LibraryRoot> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map pathMacros;
            String filePath;
            LibraryRoot root = (LibraryRoot)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)VirtualFileManager.extractPath((String)root.getUrl().getUrl()), (String)"VirtualFileManager.extractPath(root.url.url)");
            int jarSeparatorIdx = StringsKt.indexOf$default((CharSequence)filePath, (String)"!/", (int)0, (boolean)false, (int)6, null);
            if (jarSeparatorIdx > -1) {
                String string = filePath;
                int n = 0;
                String string2 = string.substring(n, jarSeparatorIdx);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                filePath = string2;
            }
            PathMacros pathMacros2 = PathMacros.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)pathMacros2, (String)"PathMacros.getInstance()");
            Intrinsics.checkNotNullExpressionValue((Object)pathMacros2.getUserMacros(), (String)"PathMacros.getInstance().userMacros");
            for (String name : pathMacros.keySet()) {
                String path;
                Object v = pathMacros.get(name);
                Intrinsics.checkNotNull(v);
                Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)((String)v)), (String)"FileUtil.toSystemIndepen\u2026tName(pathMacros[name]!!)");
                if (!StringsKt.startsWith$default((String)filePath, (String)(path + "/"), (boolean)false, (int)2, null)) continue;
                CharSequence charSequence = filePath;
                int n = path.length();
                String string = ((String)charSequence).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                String substr = string;
                return name + (String)(StringsKt.startsWith$default((String)substr, (String)"/", (boolean)false, (int)2, null) || (charSequence = (CharSequence)substr).length() == 0 ? substr : "/" + substr);
            }
        }
        return null;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EclipseModuleRootsSerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

