/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexAuthHolder;
import com.intellij.indexing.shared.download.SharedIndexDownloadJson;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J,\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadJson;", "", "()V", "avoidCaching", "", "url", "downloadJsonXz", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "testConnection", "", "headers", "", "intellij.indexing.shared"})
public final class SharedIndexDownloadJson {
    @NotNull
    public static final SharedIndexDownloadJson INSTANCE;

    @VisibleForTesting
    public final boolean testConnection(@NotNull String url, @NotNull Map<String, String> headers, @NotNull ProgressIndicator indicator) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            try {
                indicator.checkCanceled();
                HttpRequests.request((String)url).productNameAsUserAgent().accept("application/octet-stream, application/xz, application/x-xz").tuner(new HttpRequests.ConnectionTuner(headers){
                    final /* synthetic */ Map $headers;

                    /*
                     * WARNING - void declaration
                     */
                    public final void tune(@NotNull URLConnection tuner) {
                        Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
                        Map $this$forEach$iv = this.$headers;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void k;
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> $dstr$k$v = element$iv = iterator.next();
                            boolean bl = false;
                            Map.Entry<K, V> entry = $dstr$k$v;
                            String string = (String)entry.getKey();
                            entry = $dstr$k$v;
                            String v = (String)entry.getValue();
                            tuner.addRequestProperty((String)k, v);
                        }
                    }
                    {
                        this.$headers = map;
                    }
                }).throwStatusCodeException(true).connect((HttpRequests.RequestProcessor)testConnection.2.INSTANCE);
            }
            catch (HttpRequests.HttpStatusException e) {
                return false;
            }
            finally {
                if (e.getStatusCode() < 400) break block4;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    public final ObjectNode downloadJsonXz(@NotNull SharedIndexLookupRequest request, @NotNull String url, @NotNull ProgressIndicator indicator) {
        Object object;
        byte[] byArray;
        block34: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Checking " + url + " for " + request + "...");
            boolean $i$f$service = false;
            Class<SharedIndexAuthHolder> serviceClass$iv = SharedIndexAuthHolder.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            Map<String, String> headers = ((SharedIndexAuthHolder)object2).resolveHeaders(url, request, indicator);
            boolean $i$f$handleHttpDownloadExceptions = false;
            try {
                boolean bl = false;
                byArray = HttpRequests.request((String)INSTANCE.avoidCaching(url)).productNameAsUserAgent().accept("application/octet-stream, application/xz, application/x-xz").tuner(new HttpRequests.ConnectionTuner(url, headers, indicator){
                    final /* synthetic */ String $url$inlined;
                    final /* synthetic */ Map $headers$inlined;
                    final /* synthetic */ ProgressIndicator $indicator$inlined;
                    {
                        this.$url$inlined = string;
                        this.$headers$inlined = map;
                        this.$indicator$inlined = progressIndicator;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void tune(@NotNull URLConnection tuner) {
                        Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
                        Map $this$forEach$iv = this.$headers$inlined;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void k;
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> $dstr$k$v = element$iv = iterator.next();
                            boolean bl = false;
                            Map.Entry<K, V> entry = $dstr$k$v;
                            String string = (String)entry.getKey();
                            entry = $dstr$k$v;
                            String v = (String)entry.getValue();
                            tuner.addRequestProperty((String)k, v);
                        }
                    }
                }).throwStatusCodeException(true).readBytes(indicator);
                break block34;
            }
            catch (ConnectException e$iv) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Cannot connect to the host for " + url + " for " + request + ". " + e$iv.getMessage(), (Throwable)e$iv);
            }
            catch (UnknownHostException e$iv) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Cannot resolve host for " + url + " for " + request + ". " + e$iv.getMessage(), (Throwable)e$iv);
            }
            catch (SocketTimeoutException e$iv) {
                if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                    SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Connection expired by timeout at " + url + " for " + request + ". Error: " + e$iv.getMessage() + ".", (Throwable)e$iv);
                } else {
                    SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Connection expired by timeout at " + url + " for " + request + ". Error: " + e$iv.getMessage() + ".");
                }
            }
            catch (HttpRequests.HttpStatusException e$iv) {
                if (e$iv.getStatusCode() < 500) {
                    SharedIndexDownloadLoggerKt.getDownloadLogger().debug("No data available for " + url + " for " + request + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                } else {
                    SharedIndexDownloadLoggerKt.getDownloadLogger().info("No data available for " + url + " for " + request + ". " + e$iv.getStatusCode(), (Throwable)e$iv);
                }
            }
            catch (IOException e$iv) {
                if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                    Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                    String string = e$iv.getMessage();
                    if (string == null) {
                        Throwable throwable = e$iv.getCause();
                        string = throwable != null ? throwable.getMessage() : null;
                    }
                    logger.warn("Failed to download " + url + " for " + request + ". Error: " + (string != null ? (Serializable)((Object)string) : (Serializable)e$iv.getClass()), (Throwable)e$iv);
                } else {
                    Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                    String string = e$iv.getMessage();
                    if (string == null) {
                        Throwable throwable = e$iv.getCause();
                        string = throwable != null ? throwable.getMessage() : null;
                    }
                    logger.warn("Failed to download " + url + " for " + request + ". Error: " + (string != null ? (Serializable)((Object)string) : (Serializable)e$iv.getClass()));
                }
            }
            catch (Throwable t$iv) {
                if (t$iv instanceof ControlFlowException) {
                    throw t$iv;
                }
                Logger logger = SharedIndexDownloadLoggerKt.getDownloadLogger();
                Class<?> clazz = t$iv.getClass();
                String string = t$iv.getMessage();
                if (string == null) {
                    Throwable throwable = t$iv.getCause();
                    string = throwable != null ? throwable.getMessage() : null;
                }
                logger.warn("Failed to download " + url + " due " + clazz + " for " + request + ". Error: " + (string != null ? (Serializable)((Object)string) : (Serializable)t$iv.getClass()));
            }
            byArray = null;
        }
        if (byArray == null) {
            return null;
        }
        byte[] rawDataXZ = byArray;
        try {
            byte[] byArray2;
            object = new ByteArrayInputStream(rawDataXZ);
            Throwable t$iv = null;
            try {
                byte[] byArray3;
                ByteArrayInputStream input = (ByteArrayInputStream)object;
                boolean bl = false;
                Closeable closeable = (Closeable)new XZInputStream((InputStream)input);
                Throwable throwable = null;
                try {
                    XZInputStream it = (XZInputStream)closeable;
                    boolean bl2 = false;
                    byArray3 = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                byArray2 = byArray3;
            }
            catch (Throwable throwable) {
                t$iv = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)t$iv);
            }
            object = byArray2;
        }
        catch (Throwable e) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to unpack data from " + url + " for " + request + ". " + e.getMessage());
            return null;
        }
        Object rawData = object;
        try {
            JsonNode jsonNode = new ObjectMapper().readTree((byte[])rawData);
            if (jsonNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            }
            object = (ObjectNode)jsonNode;
        }
        catch (Throwable e) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to read JSON from " + url + " for " + request + ". " + e.getMessage());
            return null;
        }
        return object;
    }

    private final String avoidCaching(String url) {
        return url + "?timestamp=" + System.currentTimeMillis();
    }

    private SharedIndexDownloadJson() {
    }

    static {
        SharedIndexDownloadJson sharedIndexDownloadJson;
        INSTANCE = sharedIndexDownloadJson = new SharedIndexDownloadJson();
    }
}

