/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl.cookie;

import org.apache.maven.wagon.providers.http.httpclient.annotation.Contract;
import org.apache.maven.wagon.providers.http.httpclient.annotation.ThreadingBehavior;
import org.apache.maven.wagon.providers.http.httpclient.cookie.CommonCookieAttributeHandler;
import org.apache.maven.wagon.providers.http.httpclient.cookie.Cookie;
import org.apache.maven.wagon.providers.http.httpclient.cookie.CookieOrigin;
import org.apache.maven.wagon.providers.http.httpclient.cookie.MalformedCookieException;
import org.apache.maven.wagon.providers.http.httpclient.cookie.SetCookie;
import org.apache.maven.wagon.providers.http.httpclient.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.maven.wagon.providers.http.httpclient.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

