/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.optional.image.DrawOperation;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.TransformOperation;

public class Scale
extends TransformOperation
implements DrawOperation {
    private static final int HUNDRED = 100;
    private String widthStr = "100%";
    private String heightStr = "100%";
    private boolean xPercent = true;
    private boolean yPercent = true;
    private String proportions = "ignore";

    public void setProportions(ProportionsAttribute pa) {
        this.proportions = pa.getValue();
    }

    public void setWidth(String width) {
        this.widthStr = width;
    }

    public void setHeight(String height) {
        this.heightStr = height;
    }

    public float getWidth() {
        int percIndex = this.widthStr.indexOf(37);
        if (percIndex > 0) {
            this.xPercent = true;
            float width = Float.parseFloat(this.widthStr.substring(0, percIndex));
            return width / 100.0f;
        }
        this.xPercent = false;
        return Float.parseFloat(this.widthStr);
    }

    public float getHeight() {
        int percIndex = this.heightStr.indexOf(37);
        if (percIndex > 0) {
            this.yPercent = true;
            return Float.parseFloat(this.heightStr.substring(0, percIndex)) / 100.0f;
        }
        this.yPercent = false;
        return Float.parseFloat(this.heightStr);
    }

    public PlanarImage performScale(PlanarImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        float xFl = this.getWidth();
        float yFl = this.getHeight();
        if (!this.xPercent) {
            xFl /= (float)image.getWidth();
        }
        if (!this.yPercent) {
            yFl /= (float)image.getHeight();
        }
        if ("width".equals(this.proportions)) {
            yFl = xFl;
        } else if ("height".equals(this.proportions)) {
            xFl = yFl;
        } else if ("fit".equals(this.proportions)) {
            xFl = yFl = Math.min(xFl, yFl);
        } else if ("cover".equals(this.proportions)) {
            xFl = yFl = Math.max(xFl, yFl);
        }
        pb.add(Float.valueOf(xFl));
        pb.add(Float.valueOf(yFl));
        this.log("\tScaling to " + xFl * 100.0f + "% x " + yFl * 100.0f + "%");
        return JAI.create((String)"scale", (ParameterBlock)pb);
    }

    @Override
    public PlanarImage executeTransformOperation(PlanarImage image) {
        for (ImageOperation instr : this.instructions) {
            if (instr instanceof DrawOperation) {
                return this.performScale(image);
            }
            if (!(instr instanceof TransformOperation)) continue;
            BufferedImage bi = image.getAsBufferedImage();
            image = ((TransformOperation)instr).executeTransformOperation(PlanarImage.wrapRenderedImage((RenderedImage)bi));
        }
        return this.performScale(image);
    }

    @Override
    public PlanarImage executeDrawOperation() {
        for (ImageOperation instr : this.instructions) {
            if (!(instr instanceof DrawOperation)) continue;
            PlanarImage image = null;
            this.performScale(image);
            return image;
        }
        return null;
    }

    public static class ProportionsAttribute
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"ignore", "width", "height", "cover", "fit"};
        }
    }
}

