/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.Premium;
import org.languagetool.Tag;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;

public class CleanOverlappingFilter
implements RuleMatchFilter {
    private static final int negativeConstant = -2147473648;
    private final Language language;
    private final boolean hidePremiumMatches;

    public CleanOverlappingFilter(Language lang, boolean hidePremiumMatches) {
        this.language = lang;
        this.hidePremiumMatches = hidePremiumMatches;
    }

    @Override
    public final List<RuleMatch> filter(List<RuleMatch> ruleMatches) {
        ArrayList<RuleMatch> cleanList = new ArrayList<RuleMatch>();
        RuleMatch prevRuleMatch = null;
        for (RuleMatch ruleMatch : ruleMatches) {
            if (prevRuleMatch == null) {
                prevRuleMatch = ruleMatch;
                continue;
            }
            if (ruleMatch.getFromPos() < prevRuleMatch.getFromPos()) {
                throw new IllegalArgumentException("The list of rule matches is not ordered. Make sure it is sorted by start position.");
            }
            if (ruleMatch.getFromPos() >= prevRuleMatch.getToPos()) {
                cleanList.add(prevRuleMatch);
                prevRuleMatch = ruleMatch;
                continue;
            }
            int currentPriority = this.language.getRulePriority(ruleMatch.getRule());
            if (this.isPremiumRule(ruleMatch) && this.hidePremiumMatches) {
                currentPriority = Integer.MIN_VALUE;
            }
            if (ruleMatch.getRule().getTags().contains((Object)Tag.picky) && currentPriority != Integer.MIN_VALUE) {
                currentPriority -= 2147473648;
            }
            int prevPriority = this.language.getRulePriority(prevRuleMatch.getRule());
            if (this.isPremiumRule(prevRuleMatch) && this.hidePremiumMatches) {
                prevPriority = Integer.MIN_VALUE;
            }
            if (prevRuleMatch.getRule().getTags().contains((Object)Tag.picky) && prevPriority != Integer.MIN_VALUE) {
                prevPriority -= 2147473648;
            }
            if (currentPriority == prevPriority) {
                currentPriority = ruleMatch.getToPos() - ruleMatch.getFromPos();
                prevPriority = prevRuleMatch.getToPos() - prevRuleMatch.getFromPos();
            }
            if (currentPriority == prevPriority) {
                ++currentPriority;
            }
            if (currentPriority <= prevPriority) continue;
            prevRuleMatch = ruleMatch;
        }
        if (prevRuleMatch != null) {
            cleanList.add(prevRuleMatch);
        }
        return cleanList;
    }

    protected boolean isPremiumRule(RuleMatch ruleMatch) {
        return Premium.get().isPremiumRule(ruleMatch.getRule());
    }
}

