/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.format;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.measure.Unit;
import javax.measure.quantity.Dimensionless;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.SymbolMap;
import tech.units.indriya.function.LogConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.internal.format.DefaultCharStream;
import tech.units.indriya.internal.format.Token;
import tech.units.indriya.internal.format.TokenException;
import tech.units.indriya.internal.format.UnitTokenConstants;
import tech.units.indriya.internal.format.UnitTokenManager;
import tech.units.indriya.unit.Prefix;

public final class UnitFormatParser
implements UnitTokenConstants {
    private SymbolMap symbols;
    private UnitTokenManager token_source;
    private DefaultCharStream jj_input_stream;
    private Token token;
    private Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[19];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private final List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public UnitFormatParser(SymbolMap symbols, Reader in) {
        this(in);
        this.symbols = symbols;
    }

    public Unit<?> parseUnit() throws TokenException {
        Unit<?> result = this.compoundExpr();
        this.jj_consume_token(0);
        return result;
    }

    Unit<?> compoundExpr() throws TokenException {
        Unit<Dimensionless> result = AbstractUnit.ONE;
        result = this.addExpr();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(11);
        }
        return result;
    }

    Unit<?> addExpr() throws TokenException {
        Unit<Dimensionless> result = AbstractUnit.ONE;
        Number n1 = null;
        Token sign1 = null;
        Number n2 = null;
        Token sign2 = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            n1 = this.numberExpr();
            sign1 = this.sign();
        }
        result = this.mulExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: {
                sign2 = this.sign();
                n2 = this.numberExpr();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        if (n1 != null) {
            if (sign1.image.equals("-")) {
                result = result.multiply(-1.0);
            }
            result = result.shift(n1.doubleValue());
        }
        if (n2 != null) {
            double offset = n2.doubleValue();
            if ("-".equals(sign2.image)) {
                offset = -offset;
            }
            result = result.shift(offset);
        }
        return result;
    }

    Unit<?> mulExpr() throws TokenException {
        Unit<Dimensionless> result;
        block12: {
            result = AbstractUnit.ONE;
            Unit<Dimensionless> temp = AbstractUnit.ONE;
            result = this.exponentExpr();
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block12;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                this.jj_consume_token(7);
                                break;
                            }
                            case 8: {
                                this.jj_consume_token(8);
                                break;
                            }
                            default: {
                                this.jj_la1[3] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new TokenException();
                            }
                        }
                        temp = this.exponentExpr();
                        result = result.multiply(temp);
                        continue block11;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        temp = this.exponentExpr();
                        result = result.divide(temp);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[4] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new TokenException();
        }
        return result;
    }

    Unit<?> exponentExpr() throws TokenException {
        Unit<Dimensionless> result = AbstractUnit.ONE;
        Exponent exponent = null;
        Token token = null;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    token = this.jj_consume_token(14);
                    break;
                }
                case 19: {
                    token = this.jj_consume_token(19);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new TokenException();
                }
            }
            this.jj_consume_token(10);
            result = this.atomicExpr();
            double base2 = token.kind == 14 ? (double)Integer.parseInt(token.image) : 19.0;
            return result.transform(new LogConverter(base2).inverse());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 14: 
            case 16: 
            case 20: {
                result = this.atomicExpr();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 15: {
                        exponent = this.exp();
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                    }
                }
                if (exponent != null) {
                    if (exponent.pow != 1) {
                        result = result.pow(exponent.pow);
                    }
                    if (exponent.root != 1) {
                        result = result.root(exponent.root);
                    }
                }
                return result;
            }
            case 17: 
            case 18: {
                block11 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        this.jj_consume_token(17);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 14: {
                                token = this.jj_consume_token(14);
                                break block11;
                            }
                        }
                        this.jj_la1[7] = this.jj_gen;
                        break;
                    }
                    case 18: {
                        token = this.jj_consume_token(18);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new TokenException();
                    }
                }
                this.jj_consume_token(12);
                result = this.addExpr();
                this.jj_consume_token(13);
                double base3 = 10.0;
                if (token != null) {
                    if (token.kind == 14) {
                        base3 = Integer.parseInt(token.image);
                    } else if (token.kind == 18) {
                        base3 = 19.0;
                    }
                }
                return result.transform(new LogConverter(base3));
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new TokenException();
    }

    Unit<?> atomicExpr() throws TokenException {
        Unit<Dimensionless> result = AbstractUnit.ONE;
        Number n = null;
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 16: {
                n = this.numberExpr();
                if (n instanceof Integer) {
                    return result.multiply(n.intValue());
                }
                return result.multiply(n.doubleValue());
            }
            case 20: {
                token = this.jj_consume_token(20);
                Unit<?> unit = this.symbols.getUnit(token.image);
                if (unit == null) {
                    String prefixSymbol;
                    Prefix prefix = this.symbols.getPrefix(token.image);
                    if (prefix != null && (unit = this.symbols.getUnit(token.image.substring((prefixSymbol = this.symbols.getSymbol(prefix)).length()))) != null) {
                        return unit.transform(MultiplyConverter.of(prefix));
                    }
                    throw new TokenException();
                }
                return unit;
            }
            case 12: {
                this.jj_consume_token(12);
                result = this.addExpr();
                this.jj_consume_token(13);
                return result;
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new TokenException();
    }

    Token sign() throws TokenException {
        Token result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                result = this.jj_consume_token(5);
                break;
            }
            case 6: {
                result = this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new TokenException();
            }
        }
        return result;
    }

    Number numberExpr() throws TokenException {
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                token = this.jj_consume_token(14);
                return Long.valueOf(token.image);
            }
            case 16: {
                token = this.jj_consume_token(16);
                return Double.valueOf(token.image);
            }
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new TokenException();
    }

    Exponent exp() throws TokenException {
        Token powSign = null;
        Token powToken = null;
        Token rootSign = null;
        Token rootToken = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: 
                    case 14: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: 
                            case 6: {
                                powSign = this.sign();
                                break;
                            }
                            default: {
                                this.jj_la1[13] = this.jj_gen;
                            }
                        }
                        powToken = this.jj_consume_token(14);
                        int pow = Integer.parseInt(powToken.image);
                        if (powSign != null && powSign.image.equals("-")) {
                            pow = -pow;
                        }
                        return new Exponent(pow, 1);
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: 
                            case 6: {
                                powSign = this.sign();
                                break;
                            }
                            default: {
                                this.jj_la1[14] = this.jj_gen;
                            }
                        }
                        powToken = this.jj_consume_token(14);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 9: {
                                this.jj_consume_token(9);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 5: 
                                    case 6: {
                                        rootSign = this.sign();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[15] = this.jj_gen;
                                    }
                                }
                                rootToken = this.jj_consume_token(14);
                                break;
                            }
                            default: {
                                this.jj_la1[16] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(13);
                        int pow = Integer.parseInt(powToken.image);
                        if (powSign != null && powSign.image.equals("-")) {
                            pow = -pow;
                        }
                        int root = 1;
                        if (rootToken != null) {
                            root = Integer.parseInt(rootToken.image);
                            if (rootSign != null && rootSign.image.equals("-")) {
                                root = -root;
                            }
                        }
                        return new Exponent(pow, root);
                    }
                }
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new TokenException();
            }
            case 15: {
                powToken = this.jj_consume_token(15);
                int pow = 0;
                block31: for (int i2 = 0; i2 < powToken.image.length(); ++i2) {
                    pow *= 10;
                    switch (powToken.image.charAt(i2)) {
                        case '\u00b9': {
                            ++pow;
                            continue block31;
                        }
                        case '\u00b2': {
                            pow += 2;
                            continue block31;
                        }
                        case '\u00b3': {
                            pow += 3;
                            continue block31;
                        }
                        case '\u2074': {
                            pow += 4;
                            continue block31;
                        }
                        case '\u2075': {
                            pow += 5;
                            continue block31;
                        }
                        case '\u2076': {
                            pow += 6;
                            continue block31;
                        }
                        case '\u2077': {
                            pow += 7;
                            continue block31;
                        }
                        case '\u2078': {
                            pow += 8;
                            continue block31;
                        }
                        case '\u2079': {
                            pow += 9;
                        }
                    }
                }
                return new Exponent(pow, 1);
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new TokenException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3R_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_6()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_6() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(14)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(19)) {
                return true;
            }
        }
        return this.jj_scan_token(10);
    }

    private boolean jj_3_1() {
        return this.jj_3R_3() || this.jj_3R_4();
    }

    private boolean jj_3R_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(5)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(6)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_5() {
        return this.jj_scan_token(14);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{2048, 96, 896, 384, 896, 540672, 33792, 16384, 393216, 1527808, 0x115000, 96, 81920, 96, 96, 96, 512, 20576, 33792};
    }

    UnitFormatParser(InputStream stream) {
        this(stream, null);
    }

    UnitFormatParser(InputStream stream, String encoding) {
        int i2;
        try {
            this.jj_input_stream = new DefaultCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new UnitTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    UnitFormatParser(Reader stream) {
        int i2;
        this.jj_input_stream = new DefaultCharStream(stream, 1, 1);
        this.token_source = new UnitTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    UnitFormatParser(UnitTokenManager tm) {
        int i2;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws TokenException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
                    JJCalls c = this.jj_2_rtns[i2];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i2 = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i2;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i2);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    final Token getToken(int index) {
        Token t = this.token;
        for (int i2 = 0; i2 < index; ++i2) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            System.arraycopy(this.jj_lasttokens, 0, this.jj_expentry, 0, this.jj_endpos);
            block0: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i2 = 0; i2 < this.jj_expentry.length; ++i2) {
                    if (oldentry[i2] != this.jj_expentry[i2]) continue block0;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    TokenException generateParseException() {
        int i2;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[21];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i2 = 0; i2 < 19; ++i2) {
            if (this.jj_la1[i2] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i2] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i2 = 0; i2 < 21; ++i2) {
            if (!la1tokens[i2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i2;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i3 = 0; i3 < this.jj_expentries.size(); ++i3) {
            exptokseq[i3] = this.jj_expentries.get(i3);
        }
        return new TokenException(this.token, exptokseq, tokenImage);
    }

    final void enable_tracing() {
    }

    final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                JJCalls p2 = this.jj_2_rtns[i2];
                do {
                    if (p2.gen <= this.jj_gen) continue;
                    this.jj_la = p2.arg;
                    this.jj_lastpos = this.jj_scanpos = p2.first;
                    switch (i2) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p2 = p2.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p2 = this.jj_2_rtns[index];
        while (p2.gen > this.jj_gen) {
            if (p2.next == null) {
                p2 = p2.next = new JJCalls();
                break;
            }
            p2 = p2.next;
        }
        p2.gen = this.jj_gen + xla - this.jj_la;
        p2.first = this.token;
        p2.arg = xla;
    }

    static {
        UnitFormatParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private static final long serialVersionUID = -8192240240676284081L;

        private LookaheadSuccess() {
        }
    }

    private static class Exponent {
        final int pow;
        final int root;

        public Exponent(int pow, int root) {
            this.pow = pow;
            this.root = root;
        }
    }
}

