/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.relativizer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.incremental.relativizer.CommonPathRelativizer;
import org.jetbrains.jps.incremental.relativizer.GradlePathRelativizer;
import org.jetbrains.jps.incremental.relativizer.JavaSdkPathRelativizer;
import org.jetbrains.jps.incremental.relativizer.MavenPathRelativizer;
import org.jetbrains.jps.incremental.relativizer.PathRelativizer;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.util.JpsPathUtil;

public class PathRelativizerService {
    private static final Logger LOG = Logger.getInstance(PathRelativizerService.class);
    private static final String PROJECT_DIR_IDENTIFIER = "$PROJECT_DIR$";
    private static final String BUILD_DIR_IDENTIFIER = "$BUILD_DIR$";
    private final List<PathRelativizer> myRelativizers;
    private final Set<String> myUnhandledPaths;

    public PathRelativizerService(@Nullable String projectPath) {
        this.myRelativizers = new SmartList();
        this.myUnhandledPaths = Collections.synchronizedSet(new LinkedHashSet());
        this.initialize(projectPath, null, null);
    }

    public PathRelativizerService(@NotNull JpsProject project) {
        if (project == null) {
            PathRelativizerService.$$$reportNull$$$0(0);
        }
        this.myRelativizers = new SmartList();
        this.myUnhandledPaths = Collections.synchronizedSet(new LinkedHashSet());
        File projectBaseDirectory = JpsModelSerializationDataService.getBaseDirectory((JpsProject)project);
        Set javaSdks = project.getModules().stream().map(module -> module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE)).filter(sdk -> sdk != null && sdk.getVersionString() != null && sdk.getHomePath() != null).collect(Collectors.toSet());
        this.initialize(projectBaseDirectory != null ? projectBaseDirectory.getAbsolutePath() : null, PathRelativizerService.getBuildDirPath(project), javaSdks);
    }

    @TestOnly
    public PathRelativizerService() {
        this.myRelativizers = new SmartList();
        this.myUnhandledPaths = Collections.synchronizedSet(new LinkedHashSet());
        this.initialize(null, null, null);
    }

    private void initialize(@Nullable String projectPath, @Nullable String buildDirPath, @Nullable Set<? extends JpsSdk<?>> javaSdks) {
        String normalizedProjectPath = projectPath != null ? PathRelativizerService.normalizePath(projectPath) : null;
        String normalizedBuildDirPath = buildDirPath != null ? PathRelativizerService.normalizePath(buildDirPath) : null;
        this.myRelativizers.add(new CommonPathRelativizer(normalizedBuildDirPath, BUILD_DIR_IDENTIFIER));
        this.myRelativizers.add(new CommonPathRelativizer(normalizedProjectPath, PROJECT_DIR_IDENTIFIER));
        this.myRelativizers.add(new JavaSdkPathRelativizer(javaSdks));
        this.myRelativizers.add(new MavenPathRelativizer());
        this.myRelativizers.add(new GradlePathRelativizer());
    }

    @NotNull
    public String toRelative(@NotNull String path) {
        if (path == null) {
            PathRelativizerService.$$$reportNull$$$0(1);
        }
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)path);
        for (PathRelativizer relativizer : this.myRelativizers) {
            String relativePath = relativizer.toRelativePath(systemIndependentPath);
            if (relativePath == null) continue;
            String string = relativePath;
            if (string == null) {
                PathRelativizerService.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (LOG.isDebugEnabled()) {
            this.myUnhandledPaths.add(path);
        }
        String string = systemIndependentPath;
        if (string == null) {
            PathRelativizerService.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String toFull(@NotNull String path) {
        if (path == null) {
            PathRelativizerService.$$$reportNull$$$0(4);
        }
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)path);
        for (PathRelativizer relativizer : this.myRelativizers) {
            String fullPath = relativizer.toAbsolutePath(systemIndependentPath);
            if (fullPath == null) continue;
            String string = fullPath;
            if (string == null) {
                PathRelativizerService.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = systemIndependentPath;
        if (string == null) {
            PathRelativizerService.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void reportUnhandledPaths() {
        if (LOG.isDebugEnabled()) {
            StringBuilder logBuilder = new StringBuilder();
            this.myUnhandledPaths.forEach(it -> logBuilder.append((String)it).append("\n"));
            LOG.debug("Unhandled by relativizer paths:\n" + logBuilder);
            this.myUnhandledPaths.clear();
        }
    }

    @NotNull
    static String normalizePath(@NotNull String path) {
        if (path == null) {
            PathRelativizerService.$$$reportNull$$$0(7);
        }
        String string = StringUtil.trimTrailing((String)FileUtil.toSystemIndependentName((String)path), (char)'/');
        if (string == null) {
            PathRelativizerService.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static String getBuildDirPath(@NotNull JpsProject project) {
        JpsJavaProjectExtension projectExtension;
        if (project == null) {
            PathRelativizerService.$$$reportNull$$$0(9);
        }
        if ((projectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(project)) == null) {
            return null;
        }
        String url = projectExtension.getOutputUrl();
        if (StringUtil.isEmpty((String)url)) {
            return null;
        }
        return JpsPathUtil.urlToFile((String)url).getAbsolutePath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/relativizer/PathRelativizerService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/relativizer/PathRelativizerService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toRelative";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toFull";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toRelative";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toFull";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "normalizePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBuildDirPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

