/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirLocalVariableTypeParametersSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "()V", "checkLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkPsi", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "isApplicable", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
public final class FirLocalVariableTypeParametersSyntaxChecker
extends FirDeclarationSyntaxChecker<FirProperty, KtExpression> {
    @NotNull
    public static final FirLocalVariableTypeParametersSyntaxChecker INSTANCE = new FirLocalVariableTypeParametersSyntaxChecker();

    private FirLocalVariableTypeParametersSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirProperty element, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        return !(source.getKind() instanceof KtFakeSourceElementKind) && element.isLocal();
    }

    @Override
    public void checkPsi(@NotNull FirProperty element, @NotNull KtPsiSourceElement source, @NotNull KtExpression psi, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(psi, "psi");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (psi instanceof KtProperty && ((KtProperty)psi).getTypeParameterList() != null) {
            KtDiagnosticFactory0 diagnostic = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitTypeParametersForLocalVariables) ? FirErrors.INSTANCE.getLOCAL_VARIABLE_WITH_TYPE_PARAMETERS() : FirErrors.INSTANCE.getLOCAL_VARIABLE_WITH_TYPE_PARAMETERS_WARNING();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (DiagnosticContext)context, null, 8, null);
        }
    }

    @Override
    public void checkLightTree(@NotNull FirProperty element, @NotNull KtLightSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block0: {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (LightTreePositioningStrategiesKt.typeParametersList(source.getTreeStructure(), source.getLighterASTNode()) == null) break block0;
            boolean bl = false;
            KtDiagnosticFactory0 diagnostic = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitTypeParametersForLocalVariables) ? FirErrors.INSTANCE.getLOCAL_VARIABLE_WITH_TYPE_PARAMETERS() : FirErrors.INSTANCE.getLOCAL_VARIABLE_WITH_TYPE_PARAMETERS_WARNING();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (DiagnosticContext)context, null, 8, null);
        }
    }
}

