/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsCommonInlineClassesUtils;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IdSignatureValues;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsInlineClassesUtils;", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonInlineClassesUtils;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "boxIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getBoxIntrinsic", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "unboxIntrinsic", "getUnboxIntrinsic", "getInlinedClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isClassInlineLike", "", "klass", "backend.js"})
public final class JsInlineClassesUtils
implements JsCommonInlineClassesUtils {
    @NotNull
    private final JsIrBackendContext context;

    public JsInlineClassesUtils(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public IrClass getInlinedClass(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        if (type2 instanceof IrSimpleType) {
            IrClass irClass2 = IrTypeUtilsKt.erase(type2);
            if (irClass2 == null) {
                return null;
            }
            IrClass erased = irClass2;
            if (this.isClassInlineLike(erased)) {
                if (IrTypePredicatesKt.isMarkedNullable((IrSimpleType)type2)) {
                    IrType fieldType = null;
                    IrClass fieldInlinedClass = erased;
                    while (true) {
                        if (IrTypePredicatesKt.isMarkedNullable(fieldType = this.getInlineClassUnderlyingType(fieldInlinedClass))) {
                            return null;
                        }
                        if (this.getInlinedClass(fieldType) == null) break;
                    }
                }
                return erased;
            }
        }
        return null;
    }

    @Override
    public boolean isClassInlineLike(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return JsCommonInlineClassesUtils.DefaultImpls.isClassInlineLike(this, klass) || Intrinsics.areEqual(klass.getSymbol().getSignature(), IdSignatureValues._char);
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getBoxIntrinsic() {
        return this.context.getIntrinsics().getJsBoxIntrinsic();
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getUnboxIntrinsic() {
        return this.context.getIntrinsics().getJsUnboxIntrinsic();
    }

    @Override
    public boolean isTypeInlined(@NotNull IrType type2) {
        return JsCommonInlineClassesUtils.DefaultImpls.isTypeInlined(this, type2);
    }

    @Override
    public boolean shouldValueParameterBeBoxed(@NotNull IrValueParameter parameter) {
        return JsCommonInlineClassesUtils.DefaultImpls.shouldValueParameterBeBoxed(this, parameter);
    }

    @Override
    @NotNull
    public IrType getInlineClassUnderlyingType(@NotNull IrClass irClass2) {
        return JsCommonInlineClassesUtils.DefaultImpls.getInlineClassUnderlyingType(this, irClass2);
    }
}

