/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/EmptyStatementElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "hasChanges", "", "apply", "js.translator"})
public final class EmptyStatementElimination {
    @NotNull
    private final JsStatement root;
    private boolean hasChanges;

    public EmptyStatementElimination(@NotNull JsStatement root2) {
        Intrinsics.checkNotNullParameter(root2, "root");
        this.root = root2;
    }

    public final boolean apply() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ EmptyStatementElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                return false;
            }

            public void endVisit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                if (MetadataProperties.getSynthetic(x)) {
                    JsStatement jsStatement = x.getStatement();
                    Intrinsics.checkNotNullExpressionValue(jsStatement, "x.statement");
                    if (this.isEmpty(jsStatement)) {
                        ctx.replaceMe((JsNode)x.getStatement());
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    }
                }
            }

            public void endVisit(@NotNull JsBlock x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                List<JsStatement> list2 = x.getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, "x.statements");
                this.processStatements(list2);
            }

            public void endVisit(@NotNull JsIf x, @NotNull JsContext<JsNode> ctx) {
                boolean bl;
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                JsStatement jsStatement = x.getThenStatement();
                Intrinsics.checkNotNullExpressionValue(jsStatement, "x.thenStatement");
                boolean thenEmpty = this.isEmpty(jsStatement);
                JsStatement jsStatement2 = x.getElseStatement();
                if (jsStatement2 != null) {
                    JsStatement it = jsStatement2;
                    boolean bl2 = false;
                    bl = this.isEmpty(it);
                } else {
                    bl = true;
                }
                boolean elseEmpty = bl;
                if (thenEmpty && elseEmpty) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.replaceMe((JsNode)JsAstUtils.asSyntheticStatement(x.getIfExpression()));
                } else if (elseEmpty) {
                    if (x.getElseStatement() != null) {
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                        x.setElseStatement(null);
                    }
                } else if (thenEmpty) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    JsStatement jsStatement3 = x.getElseStatement();
                    Intrinsics.checkNotNull(jsStatement3);
                    x.setThenStatement(jsStatement3);
                    x.setElseStatement(null);
                    x.setIfExpression(JsAstUtils.notOptimized(x.getIfExpression()));
                }
            }

            public void endVisit(@NotNull JsTry x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                JsBlock finallyBlock = x.getFinallyBlock();
                if (x.getTryBlock().isEmpty()) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    JsBlock jsBlock = finallyBlock;
                    ctx.replaceMe(jsBlock == null ? (JsNode)JsEmpty.INSTANCE : (JsNode)jsBlock);
                }
            }

            public void endVisit(@NotNull JsSwitch x, @NotNull JsContext<JsNode> ctx) {
                block14: {
                    Object object;
                    block13: {
                        boolean bl;
                        block11: {
                            JsSwitchMember it;
                            T element$iv;
                            boolean $i$f$all;
                            Iterable $this$all$iv;
                            block12: {
                                boolean bl2;
                                block10: {
                                    Intrinsics.checkNotNullParameter(x, "x");
                                    Intrinsics.checkNotNullParameter(ctx, "ctx");
                                    for (JsSwitchMember jsSwitchMember : x.getCases()) {
                                        List<JsStatement> list2 = jsSwitchMember.getStatements();
                                        Intrinsics.checkNotNullExpressionValue(list2, "case.statements");
                                        this.processStatements(list2);
                                    }
                                    List<JsSwitchMember> list3 = x.getCases();
                                    Intrinsics.checkNotNullExpressionValue(list3, "x.cases");
                                    if (!(CollectionsKt.lastOrNull(list3) instanceof JsDefault)) break block12;
                                    List<JsSwitchMember> list4 = x.getCases();
                                    Intrinsics.checkNotNullExpressionValue(list4, "x.cases");
                                    $this$all$iv = CollectionsKt.dropLast(list4, 1);
                                    $i$f$all = false;
                                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                        bl2 = true;
                                    } else {
                                        object = $this$all$iv.iterator();
                                        while (object.hasNext()) {
                                            element$iv = object.next();
                                            it = (JsSwitchMember)element$iv;
                                            boolean bl3 = false;
                                            if (it.getStatements().isEmpty()) continue;
                                            bl2 = false;
                                            break block10;
                                        }
                                        bl2 = true;
                                    }
                                }
                                if (bl2) break block13;
                            }
                            List<JsSwitchMember> list5 = x.getCases();
                            Intrinsics.checkNotNullExpressionValue(list5, "x.cases");
                            $this$all$iv = list5;
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                            } else {
                                object = $this$all$iv.iterator();
                                while (object.hasNext()) {
                                    element$iv = object.next();
                                    it = (JsSwitchMember)element$iv;
                                    boolean bl4 = false;
                                    if (it.getStatements().isEmpty()) continue;
                                    bl = false;
                                    break block11;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) break block14;
                    }
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    JsStatement[] jsStatementArray = new JsStatement[]{JsAstUtils.asSyntheticStatement(x.getExpression())};
                    List<JsStatement> replacement = CollectionsKt.mutableListOf(jsStatementArray);
                    List<JsSwitchMember> list6 = x.getCases();
                    Intrinsics.checkNotNullExpressionValue(list6, "x.cases");
                    JsSwitchMember jsSwitchMember = CollectionsKt.lastOrNull(list6);
                    if (jsSwitchMember != null) {
                        Object $this$endVisit_u24lambda_u2d3 = object = jsSwitchMember;
                        boolean bl = false;
                        List<JsStatement> list7 = ((JsSwitchMember)$this$endVisit_u24lambda_u2d3).getStatements();
                        Intrinsics.checkNotNullExpressionValue(list7, "statements");
                        replacement.addAll((Collection<JsStatement>)list7);
                    }
                    ctx.replaceMe((JsNode)new JsBlock(replacement));
                }
            }

            private final void processStatements(List<JsStatement> statements) {
                for (IndexedValue<T> indexedValue : CollectionsKt.reversed(CollectionsKt.withIndex((Iterable)statements))) {
                    int index2 = indexedValue.component1();
                    JsStatement statement2 = (JsStatement)indexedValue.component2();
                    if (statement2 instanceof JsEmpty) {
                        statements.remove(index2);
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                        continue;
                    }
                    if (!(statement2 instanceof JsBlock)) continue;
                    statements.remove(index2);
                    List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, "statement.statements");
                    statements.addAll(index2, (Collection<JsStatement>)list2);
                }
            }

            private final boolean isEmpty(JsStatement statement2) {
                return statement2 instanceof JsBlock && ((JsBlock)statement2).isEmpty() || statement2 instanceof JsEmpty;
            }
        }.accept((JsNode)this.root);
        return this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(EmptyStatementElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

