/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.table.TableModelEditor;
import java.awt.Container;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundle;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ReadOnlySourcesEditorKt;
import org.jetbrains.settingsRepository.ReadonlySource;
import org.jetbrains.settingsRepository.UpstreamEditorKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\"&\u0010\u0000\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\b\u0001\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\t"}, d2={"COLUMNS", "", "Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "Lorg/jetbrains/settingsRepository/ReadonlySource;", "", "[Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "createReadOnlySourcesEditor", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "intellij.settingsRepository"})
public final class ReadOnlySourcesEditorKt {
    private static final TableModelEditor.EditableColumnInfo<ReadonlySource, ? extends Object>[] COLUMNS = new TableModelEditor.EditableColumnInfo[]{(TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, Boolean>(){

        @NotNull
        public Class<Boolean> getColumnClass() {
            return Boolean.TYPE;
        }

        @NotNull
        public Boolean valueOf(@NotNull ReadonlySource item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getActive();
        }

        public void setValue(@NotNull ReadonlySource item, boolean value) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            item.setActive(value);
        }
    }, (TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, String>(){

        @Nullable
        public String valueOf(@NotNull ReadonlySource item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getUrl();
        }

        public void setValue(@NotNull ReadonlySource item, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            item.setUrl(value);
        }
    }};

    @NotNull
    public static final ConfigurableUi<IcsSettings> createReadOnlySourcesEditor() {
        TableModelEditor.DialogItemEditor<ReadonlySource> itemEditor2 = new TableModelEditor.DialogItemEditor<ReadonlySource>(){
            static final /* synthetic */ KProperty[] $$delegatedProperties;

            static {
                $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty0((MutablePropertyReference0)new MutablePropertyReference0Impl(createReadOnlySourcesEditor.itemEditor.1.class, "urlField", "<v#0>", 0))};
            }

            @NotNull
            public ReadonlySource clone(@NotNull ReadonlySource item, boolean forInPlaceEditing) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return new ReadonlySource(item.getUrl(), item.getActive());
            }

            @NotNull
            public Class<ReadonlySource> getItemClass() {
                return ReadonlySource.class;
            }

            public void edit(@NotNull ReadonlySource item, @NotNull Function<? super ReadonlySource, ? extends ReadonlySource> mutator, boolean isAdd) {
                LayoutBuilder builder$iv;
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
                KProperty kProperty = $$delegatedProperties[0];
                ReadWriteProperty urlField = Delegates.INSTANCE.notNull();
                LCFlags[] constraints$iv = new LCFlags[]{};
                String title$iv = null;
                boolean $i$f$panel = false;
                LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
                boolean bl = false;
                RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$panel), (String)IcsBundle.message("readonly.sources.configuration.url.label", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(urlField, kProperty){
                    final /* synthetic */ ReadWriteProperty $urlField$inlined;
                    final /* synthetic */ KProperty $urlField$metadata$inlined;
                    {
                        this.$urlField$inlined = readWriteProperty;
                        this.$urlField$metadata$inlined = kProperty;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$receiver");
                        Cell cell = (Cell)$this$row;
                        String string = IcsBundle.message("readonly.sources.configuration.repository.chooser", new Object[0]);
                        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"FileChooserDescriptorFac\u2026eSingleFolderDescriptor()");
                        this.$urlField$inlined.setValue(null, this.$urlField$metadata$inlined, (Object)Cell.textFieldWithBrowseButton$default((Cell)cell, (String)string, null, null, (FileChooserDescriptor)fileChooserDescriptor, null, (int)22, null).getComponent());
                    }
                }), (int)2, null);
                DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
                builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
                LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
                DialogPanel panel2 = panel$iv;
                ComponentsKt.dialog$default((String)IcsBundle.message("readonly.sources.configuration.add.source", new Object[0]), (JComponent)((JComponent)panel2), (boolean)false, (JComponent)((JComponent)urlField.getValue(null, kProperty)), (boolean)false, null, null, null, null, null, (Function0)((Function0)new Function0<List<? extends ValidationInfo>>(urlField, kProperty, mutator, item){
                    final /* synthetic */ ReadWriteProperty $urlField;
                    final /* synthetic */ KProperty $urlField$metadata;
                    final /* synthetic */ Function $mutator;
                    final /* synthetic */ ReadonlySource $item;

                    @Nullable
                    public final List<ValidationInfo> invoke() {
                        String url = StringKt.nullize((String)((TextFieldWithBrowseButton)this.$urlField.getValue(null, this.$urlField$metadata)).getText(), (boolean)true);
                        String string = UpstreamEditorKt.validateUrl(url, null);
                        if (string != null) {
                            String string2;
                            String it = string2 = string;
                            boolean bl = false;
                            return CollectionsKt.listOf((Object)new ValidationInfo(it));
                        }
                        ((ReadonlySource)this.$mutator.fun((Object)this.$item)).setUrl(url);
                        return null;
                    }
                    {
                        this.$urlField = readWriteProperty;
                        this.$urlField$metadata = kProperty;
                        this.$mutator = function;
                        this.$item = readonlySource;
                        super(0);
                    }
                }), (int)1012, null).show();
            }

            public void applyEdited(@NotNull ReadonlySource oldItem, @NotNull ReadonlySource newItem) {
                Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
                Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
                newItem.setUrl(oldItem.getUrl());
            }

            public boolean isUseDialogToAdd() {
                return true;
            }
        };
        TableModelEditor editor2 = new TableModelEditor((ColumnInfo[])COLUMNS, (CollectionItemEditor)itemEditor2, IcsBundle.message("readonly.sources.configuration.no.sources.configured", new Object[0]));
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        editor2.reset((List)(application.isUnitTestMode() ? CollectionsKt.emptyList() : IcsManagerKt.getIcsManager().getSettings().getReadOnlySources()));
        return (ConfigurableUi)new ConfigurableUi<IcsSettings>(editor2){
            final /* synthetic */ TableModelEditor $editor;

            public boolean isModified(@NotNull IcsSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                return this.$editor.isModified();
            }

            public void apply(@NotNull IcsSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                List<ReadonlySource> oldList = settings.getReadOnlySources();
                Set set = CollectionFactory.createSmallMemoryFootprintSet((int)oldList.size());
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"CollectionFactory.create\u2026Set<String>(oldList.size)");
                Set toDelete = set;
                for (ReadonlySource oldSource : oldList) {
                    ContainerUtil.addIfNotNull((Collection)toDelete, (Object)oldSource.getPath());
                }
                Set set2 = CollectionFactory.createSmallMemoryFootprintSet();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"CollectionFactory.create\u2026rintSet<ReadonlySource>()");
                Set toCheckout = set2;
                List list = this.$editor.apply();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.apply()");
                List newList = list;
                for (ReadonlySource newSource : newList) {
                    String path = newSource.getPath();
                    if (path == null || toDelete.remove(path)) continue;
                    toCheckout.add(newSource);
                }
                if (toDelete.isEmpty() && toCheckout.isEmpty()) {
                    return;
                }
                String title$iv = IcsBundleKt.icsMessage("task.sync.title", new Object[0]);
                Project project$iv = null;
                boolean cancellable$iv = true;
                boolean $i$f$runModalTask = false;
                boolean $i$f$createModalTask = false;
                ProgressManager.getInstance().run((Task)new Task.Modal(project$iv, title$iv, cancellable$iv, project$iv, title$iv, cancellable$iv, toDelete, toCheckout, newList){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $title;
                    final /* synthetic */ boolean $cancellable;
                    final /* synthetic */ Set $toDelete$inlined;
                    final /* synthetic */ Set $toCheckout$inlined;
                    final /* synthetic */ List $newList$inlined;
                    {
                        this.$project = $captured_local_variable$1;
                        this.$title = $captured_local_variable$2;
                        this.$cancellable = $captured_local_variable$3;
                        this.$toDelete$inlined = set;
                        this.$toCheckout$inlined = set2;
                        this.$newList$inlined = list;
                        super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Object $this$runCatching$iv;
                        Logger logger;
                        boolean $i$f$runAndLogException;
                        Logger $this$runAndLogException$iv;
                        Object path2;
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ProgressIndicator indicator2 = indicator;
                        boolean bl = false;
                        indicator2.setIndeterminate(true);
                        Path root = IcsManagerKt.getIcsManager().getReadOnlySourcesManager().getRootDir();
                        Collection collection = this.$toDelete$inlined;
                        if (!collection.isEmpty()) {
                            indicator2.setText(IcsBundleKt.icsMessage("progress.deleting.old.repositories", new Object[0]));
                            for (Object path2 : this.$toDelete$inlined) {
                                indicator2.checkCanceled();
                                $this$runAndLogException$iv = IcsManagerKt.getLOG();
                                $i$f$runAndLogException = false;
                                logger = $this$runAndLogException$iv;
                                try {
                                    $this$runCatching$iv = logger;
                                    boolean bl2 = false;
                                    boolean bl3 = false;
                                    indicator2.setText2((String)path2);
                                    Path path3 = root.resolve((String)path2);
                                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"root.resolve(path)");
                                    PathKt.delete$default((Path)path3, (boolean)false, (int)1, null);
                                    $this$runCatching$iv = Result.constructor-impl((Object)Unit.INSTANCE);
                                }
                                catch (Throwable bl2) {
                                    $this$runCatching$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                                }
                                LoggerKt.getOrLogException((Object)$this$runCatching$iv, (Logger)$this$runAndLogException$iv);
                            }
                        }
                        if (!(path2 = (Collection)this.$toCheckout$inlined).isEmpty()) {
                            for (ReadonlySource source : this.$toCheckout$inlined) {
                                Object object;
                                indicator2.checkCanceled();
                                $this$runAndLogException$iv = IcsManagerKt.getLOG();
                                $i$f$runAndLogException = false;
                                logger = $this$runAndLogException$iv;
                                try {
                                    Path dir;
                                    $this$runCatching$iv = logger;
                                    boolean bl4 = false;
                                    boolean bl5 = false;
                                    Object[] objectArray = new Object[1];
                                    String string = source.getUrl();
                                    Intrinsics.checkNotNull((Object)string);
                                    objectArray[0] = StringKt.trimMiddle$default((String)string, (int)255, (boolean)false, (int)2, null);
                                    indicator2.setText(IcsBundleKt.icsMessage("progress.cloning.repository", objectArray));
                                    String string2 = source.getPath();
                                    Intrinsics.checkNotNull((Object)string2);
                                    Path path4 = dir = root.resolve(string2);
                                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"dir");
                                    if (PathKt.exists((Path)path4)) {
                                        PathKt.delete$default((Path)dir, (boolean)false, (int)1, null);
                                    }
                                    String string3 = source.getUrl();
                                    Intrinsics.checkNotNull((Object)string3);
                                    GitExKt.cloneBare(string3, dir, IcsManagerKt.getIcsManager().getCredentialsStore(), JGitProgressMonitorKt.asProgressMonitor(indicator2)).close();
                                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                                }
                                catch (Throwable throwable) {
                                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                }
                                LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
                            }
                        }
                        IcsManagerKt.getIcsManager().getReadOnlySourcesManager().setSources(this.$newList$inlined);
                        ((SchemeManagerFactoryBase)IcsManagerKt.getIcsManager().getSchemeManagerFactory().getValue()).process((Function1)createReadOnlySourcesEditor.apply.1.3.INSTANCE);
                    }
                });
            }

            public void reset(@NotNull IcsSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                this.$editor.reset(settings.getReadOnlySources());
            }

            @NotNull
            public JComponent getComponent() {
                JComponent jComponent = this.$editor.createComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.createComponent()");
                return jComponent;
            }
            {
                this.$editor = $captured_local_variable$0;
            }
        };
    }
}

