/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImplKt;
import org.jetbrains.yaml.psi.impl.YamlScalarTextEvaluator;

public abstract class YAMLBlockScalarTextEvaluator<T extends YAMLBlockScalarImpl>
extends YamlScalarTextEvaluator<T> {
    public YAMLBlockScalarTextEvaluator(@NotNull T host) {
        if (host == null) {
            YAMLBlockScalarTextEvaluator.$$$reportNull$$$0(0);
        }
        super(host);
    }

    protected boolean shouldIncludeEolInRange(ASTNode child) {
        return YAMLBlockScalarImplKt.isEol(child) && child.getTreeNext() == null && this.getChompingIndicator() == ChompingIndicator.KEEP;
    }

    protected boolean isEnding(@Nullable TextRange rangeInHost) {
        if (rangeInHost == null) {
            return true;
        }
        TextRange lastItem = (TextRange)ContainerUtil.getLastItem(this.getContentRanges());
        if (lastItem == null) {
            return false;
        }
        return rangeInHost.getEndOffset() == lastItem.getEndOffset();
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        ChompingIndicator chomping;
        ASTNode firstContentChild = ((YAMLBlockScalarImpl)this.myHost).getFirstContentNode();
        if (firstContentChild == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                YAMLBlockScalarTextEvaluator.$$$reportNull$$$0(1);
            }
            return list;
        }
        int myStart = ((YAMLBlockScalarImpl)this.myHost).getTextRange().getStartOffset();
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        int indent = ((YAMLBlockScalarImpl)this.myHost).locateIndent();
        ASTNode firstEol = TreeUtil.findSibling((ASTNode)firstContentChild, (TokenSet)YAMLElementTypes.EOL_ELEMENTS);
        if (firstEol == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                YAMLBlockScalarTextEvaluator.$$$reportNull$$$0(2);
            }
            return list;
        }
        int thisLineStart = firstEol.getStartOffset() + 1;
        for (ASTNode child = firstEol.getTreeNext(); child != null; child = child.getTreeNext()) {
            int endOffset;
            IElementType childType = child.getElementType();
            TextRange childRange = child.getTextRange();
            if (childType == YAMLTokenTypes.INDENT && YAMLBlockScalarImplKt.isEol(child.getTreePrev())) {
                thisLineStart = child.getStartOffset() + Math.min(indent, child.getTextLength());
                continue;
            }
            if (childType == YAMLTokenTypes.SCALAR_EOL) {
                if (thisLineStart != -1) {
                    endOffset = this.shouldIncludeEolInRange(child) ? child.getTextRange().getEndOffset() : child.getStartOffset();
                    result.add(TextRange.create((int)thisLineStart, (int)endOffset).shiftRight(-myStart));
                }
                thisLineStart = child.getStartOffset() + 1;
                continue;
            }
            if (!YAMLBlockScalarImplKt.isEol(child.getTreeNext())) continue;
            if (thisLineStart == -1) {
                Logger.getInstance(YAMLBlockScalarTextEvaluator.class).warn("thisLineStart == -1: '" + ((YAMLBlockScalarImpl)this.myHost).getText() + "'", new Throwable());
                continue;
            }
            endOffset = this.shouldIncludeEolInRange(child) ? child.getTreeNext().getTextRange().getEndOffset() : childRange.getEndOffset();
            result.add(TextRange.create((int)thisLineStart, (int)endOffset).shiftRight(-myStart));
            thisLineStart = -1;
        }
        if (thisLineStart != -1) {
            result.add(TextRange.create((int)thisLineStart, (int)((YAMLBlockScalarImpl)this.myHost).getTextRange().getEndOffset()).shiftRight(-myStart));
        }
        if ((chomping = this.getChompingIndicator()) == ChompingIndicator.KEEP) {
            ArrayList<TextRange> arrayList = result;
            if (arrayList == null) {
                YAMLBlockScalarTextEvaluator.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        int lastNonEmpty = ContainerUtil.lastIndexOf(result, range -> range.getLength() != 0);
        List<Object> list = lastNonEmpty == -1 ? Collections.emptyList() : result.subList(0, lastNonEmpty + 1);
        if (list == null) {
            YAMLBlockScalarTextEvaluator.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    protected final ChompingIndicator getChompingIndicator() {
        ASTNode headerNode = ((YAMLBlockScalarImpl)this.myHost).getNthContentTypeChild(0);
        assert (headerNode != null);
        String header = headerNode.getText();
        if (header.contains("+")) {
            ChompingIndicator chompingIndicator = ChompingIndicator.KEEP;
            if (chompingIndicator == null) {
                YAMLBlockScalarTextEvaluator.$$$reportNull$$$0(5);
            }
            return chompingIndicator;
        }
        if (header.contains("-")) {
            ChompingIndicator chompingIndicator = ChompingIndicator.STRIP;
            if (chompingIndicator == null) {
                YAMLBlockScalarTextEvaluator.$$$reportNull$$$0(6);
            }
            return chompingIndicator;
        }
        ChompingIndicator chompingIndicator = ChompingIndicator.CLIP;
        if (chompingIndicator == null) {
            YAMLBlockScalarTextEvaluator.$$$reportNull$$$0(7);
        }
        return chompingIndicator;
    }

    @Contract(value="null -> true")
    public static boolean isEolOrNull(@Nullable ASTNode node) {
        if (node == null) {
            return true;
        }
        return YAMLElementTypes.EOL_ELEMENTS.contains(node.getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLBlockScalarTextEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLBlockScalarTextEvaluator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRanges";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChompingIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static enum ChompingIndicator {
        CLIP,
        STRIP,
        KEEP;

    }
}

