/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.Terminal;
import net.rubygrapefruit.platform.TerminalSize;
import net.rubygrapefruit.platform.Terminals;
import net.rubygrapefruit.platform.internal.AbstractTerminal;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.MutableTerminalSize;
import net.rubygrapefruit.platform.internal.TerminalCapabilities;
import net.rubygrapefruit.platform.internal.jni.PosixTerminalFunctions;
import net.rubygrapefruit.platform.internal.jni.TerminfoFunctions;

public class TerminfoTerminal
extends AbstractTerminal {
    private final Terminals.Output output;
    private final TerminalCapabilities capabilities = new TerminalCapabilities();
    private Terminal.Color foreground;

    public TerminfoTerminal(Terminals.Output output) {
        this.output = output;
    }

    public String toString() {
        return String.format("Curses terminal on %s", this.getOutputDisplay());
    }

    private String getOutputDisplay() {
        return this.output.toString().toLowerCase();
    }

    protected void init() {
        FunctionResult result2 = new FunctionResult();
        TerminfoFunctions.initTerminal(this.output.ordinal(), this.capabilities, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not open terminal for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
    }

    public TerminalSize getTerminalSize() {
        MutableTerminalSize terminalSize = new MutableTerminalSize();
        FunctionResult result2 = new FunctionResult();
        PosixTerminalFunctions.getTerminalSize(this.output.ordinal(), terminalSize, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not get terminal size for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return terminalSize;
    }

    public boolean supportsColor() {
        return this.capabilities.colors;
    }

    public boolean supportsCursorMotion() {
        return this.capabilities.cursorMotion;
    }

    public boolean supportsTextAttributes() {
        return this.capabilities.textAttributes;
    }

    public Terminal foreground(Terminal.Color color) {
        if (!this.capabilities.colors) {
            return this;
        }
        FunctionResult result2 = new FunctionResult();
        TerminfoFunctions.foreground(color.ordinal(), result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not switch foreground color for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        this.foreground = color;
        return this;
    }

    public Terminal bold() {
        if (!this.capabilities.textAttributes) {
            return this;
        }
        FunctionResult result2 = new FunctionResult();
        TerminfoFunctions.bold(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not switch to bold mode for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal normal() {
        this.reset();
        if (this.foreground != null) {
            this.foreground(this.foreground);
        }
        return this;
    }

    public Terminal reset() {
        FunctionResult result2 = new FunctionResult();
        TerminfoFunctions.reset(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not reset terminal for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal cursorDown(int count) {
        FunctionResult result2 = new FunctionResult();
        TerminfoFunctions.down(count, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not move cursor down for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal cursorUp(int count) {
        FunctionResult result2 = new FunctionResult();
        TerminfoFunctions.up(count, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not move cursor up for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal cursorLeft(int count) {
        FunctionResult result2 = new FunctionResult();
        TerminfoFunctions.left(count, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not move cursor left for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal cursorRight(int count) {
        FunctionResult result2 = new FunctionResult();
        TerminfoFunctions.right(count, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not move cursor right for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal cursorStartOfLine() throws NativeException {
        FunctionResult result2 = new FunctionResult();
        TerminfoFunctions.startLine(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not move cursor to start of line for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }

    public Terminal clearToEndOfLine() throws NativeException {
        FunctionResult result2 = new FunctionResult();
        TerminfoFunctions.clearToEndOfLine(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not clear to end of line for %s: %s", this.getOutputDisplay(), result2.getMessage()));
        }
        return this;
    }
}

