/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.tree.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiFile;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.tree.BaseDomElementNode;
import com.intellij.util.xml.tree.DomFileElementNode;
import com.intellij.util.xml.tree.DomModelTreeView;
import com.intellij.util.xml.tree.actions.BaseDomTreeAction;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.PropertyKey;

public class DeleteDomElement
extends BaseDomTreeAction {
    public DeleteDomElement() {
    }

    public DeleteDomElement(DomModelTreeView treeView) {
        super(treeView);
    }

    @Override
    public void actionPerformed(AnActionEvent e, DomModelTreeView treeView) {
        SimpleNode selectedNode = treeView.getTree().getSelectedNode();
        if (selectedNode instanceof BaseDomElementNode) {
            if (selectedNode instanceof DomFileElementNode) {
                e.getPresentation().setVisible(false);
                return;
            }
            DomElement domElement = ((BaseDomElementNode)selectedNode).getDomElement();
            int ret = Messages.showOkCancelDialog((String)DeleteDomElement.getPresentationText(selectedNode, "dom.dialog.message.remove.elements"), (String)XmlDomBundle.message((String)"dom.tree.remove.xml.element.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (ret == 0) {
                WriteCommandAction.writeCommandAction((Project)domElement.getManager().getProject(), (PsiFile[])new PsiFile[]{DomUtil.getFile((DomElement)domElement)}).run(() -> domElement.undefine());
            }
        }
    }

    @Override
    public void update(AnActionEvent e, DomModelTreeView treeView) {
        DomElement domElement;
        SimpleNode selectedNode = treeView.getTree().getSelectedNode();
        if (selectedNode instanceof DomFileElementNode) {
            e.getPresentation().setVisible(false);
            return;
        }
        boolean enabled = false;
        if (selectedNode instanceof BaseDomElementNode && (domElement = ((BaseDomElementNode)selectedNode).getDomElement()).isValid() && DomUtil.hasXml((DomElement)domElement) && !(domElement.getParent() instanceof DomFileElement)) {
            enabled = true;
        }
        e.getPresentation().setEnabled(enabled);
        if (enabled) {
            e.getPresentation().setText(DeleteDomElement.getPresentationText(selectedNode, "dom.action.remove.elements"));
        } else {
            e.getPresentation().setText(XmlDomBundle.messagePointer((String)"dom.action.remove", (Object[])new Object[0]));
        }
        e.getPresentation().setIcon(AllIcons.General.Remove);
    }

    @Nls
    private static String getPresentationText(SimpleNode selectedNode, @PropertyKey(resourceBundle="messages.XmlDomBundle") @PropertyKey(resourceBundle="messages.XmlDomBundle") String messageKey) {
        ElementPresentation presentation = ((BaseDomElementNode)selectedNode).getDomElement().getPresentation();
        return XmlDomBundle.message((String)messageKey, (Object[])new Object[]{presentation.getTypeName() + (String)(presentation.getElementName() == null || presentation.getElementName().trim().length() == 0 ? "" : ": " + presentation.getElementName())});
    }
}

