/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.typeann;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TargetInfo;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructTypePathEntry;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructTypeAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.gen.Type;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class TypeAnnotation {
    public static final int CLASS_TYPE_PARAMETER = 0;
    public static final int METHOD_TYPE_PARAMETER = 1;
    public static final int SUPER_TYPE_REFERENCE = 16;
    public static final int CLASS_TYPE_PARAMETER_BOUND = 17;
    public static final int METHOD_TYPE_PARAMETER_BOUND = 18;
    public static final int FIELD = 19;
    public static final int METHOD_RETURN_TYPE = 20;
    public static final int METHOD_RECEIVER = 21;
    public static final int METHOD_PARAMETER = 22;
    public static final int THROWS_REFERENCE = 23;
    public static final int LOCAL_VARIABLE = 64;
    public static final int RESOURCE_VARIABLE = 65;
    public static final int CATCH_CLAUSE = 66;
    public static final int EXPR_INSTANCEOF = 67;
    public static final int EXPR_NEW = 68;
    public static final int EXPR_CONSTRUCTOR_REF = 69;
    public static final int EXPR_METHOD_REF = 70;
    public static final int TYPE_ARG_CAST = 71;
    public static final int TYPE_ARG_CONSTRUCTOR_CALL = 72;
    public static final int TYPE_ARG_METHOD_CALL = 73;
    public static final int TYPE_ARG_CONSTRUCTOR_REF = 74;
    public static final int TYPE_ARG_METHOD_REF = 75;
    private final int targetType;
    private final TargetInfo targetInfo;
    @NotNull
    private final List<StructTypePathEntry> paths;
    @NotNull
    private final AnnotationExprent annotation;

    public TypeAnnotation(int targetType, TargetInfo targetInfo, @NotNull List<StructTypePathEntry> paths, @NotNull AnnotationExprent annotation) {
        if (paths == null) {
            TypeAnnotation.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            TypeAnnotation.$$$reportNull$$$0(1);
        }
        this.targetType = targetType;
        this.targetInfo = targetInfo;
        this.paths = paths;
        this.annotation = annotation;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public TargetInfo getTargetInfo() {
        return this.targetInfo;
    }

    @NotNull
    public AnnotationExprent getAnnotationExpr() {
        AnnotationExprent annotationExprent = this.annotation;
        if (annotationExprent == null) {
            TypeAnnotation.$$$reportNull$$$0(2);
        }
        return annotationExprent;
    }

    @NotNull
    public List<StructTypePathEntry> getPaths() {
        List<StructTypePathEntry> list = this.paths;
        if (list == null) {
            TypeAnnotation.$$$reportNull$$$0(3);
        }
        return list;
    }

    public String toString() {
        return this.getAnnotationExpr().toJava(0, BytecodeMappingTracer.DUMMY).toString();
    }

    public void writeTo(@NotNull StringBuilder sb) {
        if (sb == null) {
            TypeAnnotation.$$$reportNull$$$0(4);
        }
        sb.append(this);
        sb.append(' ');
    }

    public void writeTo(@NotNull TextBuffer sb) {
        if (sb == null) {
            TypeAnnotation.$$$reportNull$$$0(5);
        }
        sb.append(this.toString());
        sb.append(' ');
    }

    public static List<TypeAnnotation> listFrom(StructMember md) {
        return Arrays.stream(StructGeneralAttribute.TYPE_ANNOTATION_ATTRIBUTES).flatMap(attrKey -> {
            StructTypeAnnotationAttribute attribute = (StructTypeAnnotationAttribute)md.getAttribute(attrKey);
            if (attribute == null) {
                return Stream.empty();
            }
            return attribute.getAnnotations().stream();
        }).collect(Collectors.toList());
    }

    public boolean isWrittenBeforeType(Type type) {
        StructTypePathEntry pathEntry = this.getPaths().stream().findFirst().orElse(null);
        if (pathEntry == null && type.getArrayDim() == 0) {
            return type.isAnnotatable();
        }
        return pathEntry != null && pathEntry.getTypePathEntryKind() == StructTypePathEntry.Kind.ARRAY.getId() && this.getPaths().size() == type.getArrayDim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/decompiler/modules/decompiler/typeann/TypeAnnotation";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/decompiler/modules/decompiler/typeann/TypeAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationExpr";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

