/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.make.FormSourceCodeGenerator;
import com.intellij.uiDesigner.make.LayoutSourceGenerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.FlowLayout;
import org.jetbrains.annotations.NonNls;

public final class FlowLayoutSourceGenerator
extends LayoutSourceGenerator {
    @NonNls
    private static final Int2ObjectMap<String> myAlignMap = new Int2ObjectOpenHashMap();

    @Override
    public void generateContainerLayout(LwContainer component, FormSourceCodeGenerator generator, String variable) {
        generator.startMethodCall(variable, "setLayout");
        FlowLayout layout = (FlowLayout)component.getLayout();
        generator.startConstructor(FlowLayout.class.getName());
        generator.push(layout.getAlignment(), myAlignMap);
        generator.push(layout.getHgap());
        generator.push(layout.getVgap());
        generator.endConstructor();
        generator.endMethod();
    }

    @Override
    public void generateComponentLayout(LwComponent component, FormSourceCodeGenerator generator, String variable, String parentVariable) {
        generator.startMethodCall(parentVariable, "add");
        generator.pushVar(variable);
        generator.endMethod();
    }

    static {
        myAlignMap.put(1, (Object)"FlowLayout.CENTER");
        myAlignMap.put(0, (Object)"FlowLayout.LEFT");
        myAlignMap.put(2, (Object)"FlowLayout.RIGHT");
        myAlignMap.put(3, (Object)"FlowLayout.LEADING");
        myAlignMap.put(4, (Object)"FlowLayout.TRAILING");
    }
}

