/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByVersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedTypealiasByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000b\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u000b\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0005*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000f\u00a8\u0006\u0013"}, d2={"computeLevelForDeprecatedSinceKotlin", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "createDeprecationDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lcom/intellij/psi/PsiElement;", "deprecation", "Lorg/jetbrains/kotlin/resolve/deprecation/DescriptorBasedDeprecationInfo;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecatedByAnnotationReplaceWithExpression", "", "deprecatedByOverriddenMessage", "getSinceVersion", "name", "frontend"})
public final class DeprecationUtilKt {
    @Nullable
    public static final String deprecatedByOverriddenMessage(@NotNull DescriptorBasedDeprecationInfo $this$deprecatedByOverriddenMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$deprecatedByOverriddenMessage), (String)"<this>");
        DeprecatedByOverridden deprecatedByOverridden = $this$deprecatedByOverriddenMessage instanceof DeprecatedByOverridden ? (DeprecatedByOverridden)$this$deprecatedByOverriddenMessage : null;
        return deprecatedByOverridden != null ? deprecatedByOverridden.additionalMessage$frontend() : null;
    }

    @Nullable
    public static final String deprecatedByAnnotationReplaceWithExpression(@NotNull DescriptorBasedDeprecationInfo $this$deprecatedByAnnotationReplaceWithExpression) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$deprecatedByAnnotationReplaceWithExpression), (String)"<this>");
        DeprecatedByAnnotation deprecatedByAnnotation = $this$deprecatedByAnnotationReplaceWithExpression instanceof DeprecatedByAnnotation ? (DeprecatedByAnnotation)$this$deprecatedByAnnotationReplaceWithExpression : null;
        return deprecatedByAnnotation != null ? deprecatedByAnnotation.getReplaceWithValue$frontend() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final ApiVersion getSinceVersion(@NotNull AnnotationDescriptor $this$getSinceVersion, @NotNull String name) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getSinceVersion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StringValue stringValue = AnnotationUtilKt.argumentValue($this$getSinceVersion, name);
        Object object2 = stringValue;
        if (stringValue == null) return null;
        StringValue $this$safeAs$iv = object2;
        boolean $i$f$safeAs = false;
        StringValue stringValue2 = $this$safeAs$iv;
        if (!(stringValue2 instanceof StringValue)) {
            stringValue2 = null;
        }
        StringValue stringValue3 = stringValue2;
        object2 = stringValue3;
        if (stringValue3 == null) return null;
        String string2 = (String)((ConstantValue)object2).getValue();
        object2 = string2;
        if (string2 == null) return null;
        Object p0 = object = object2;
        boolean bl = false;
        if (((CharSequence)p0).length() == 0) {
            return null;
        }
        boolean bl2 = false;
        if (bl2) return null;
        Object object3 = object;
        object2 = object3;
        if (object3 == null) return null;
        object = object2;
        ApiVersion.Companion companion = ApiVersion.Companion;
        Object p02 = object;
        boolean bl3 = false;
        ApiVersion apiVersion = companion.parse((String)p02);
        return apiVersion;
    }

    @Nullable
    public static final DeprecationLevelValue computeLevelForDeprecatedSinceKotlin(@NotNull AnnotationDescriptor annotation2, @NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        ApiVersion hiddenSince = DeprecationUtilKt.getSinceVersion(annotation2, "hiddenSince");
        if (hiddenSince != null && apiVersion.compareTo(hiddenSince) >= 0) {
            return DeprecationLevelValue.HIDDEN;
        }
        ApiVersion errorSince = DeprecationUtilKt.getSinceVersion(annotation2, "errorSince");
        if (errorSince != null && apiVersion.compareTo(errorSince) >= 0) {
            return DeprecationLevelValue.ERROR;
        }
        ApiVersion warningSince = DeprecationUtilKt.getSinceVersion(annotation2, "warningSince");
        if (warningSince != null && apiVersion.compareTo(warningSince) >= 0) {
            return DeprecationLevelValue.WARNING;
        }
        return null;
    }

    @NotNull
    public static final Diagnostic createDeprecationDiagnostic(@NotNull PsiElement element, @NotNull DescriptorBasedDeprecationInfo deprecation, @NotNull LanguageVersionSettings languageVersionSettings) {
        Diagnostic diagnostic;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)deprecation), (String)"deprecation");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        DeclarationDescriptor declarationDescriptor = deprecation.getTarget().getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"deprecation.target.original");
        DeclarationDescriptor targetOriginal = declarationDescriptor;
        DescriptorBasedDeprecationInfo descriptorBasedDeprecationInfo = deprecation;
        if (descriptorBasedDeprecationInfo instanceof DeprecatedByVersionRequirement) {
            String string2;
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<String, String>> diagnosticFactory3;
            switch (WhenMappings.$EnumSwitchMapping$0[deprecation.getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<String, String>> factory = diagnosticFactory3;
            switch (WhenMappings.$EnumSwitchMapping$1[((DeprecatedByVersionRequirement)deprecation).getVersionRequirement().getKind().ordinal()]) {
                case 1: {
                    string2 = KotlinCompilerVersion.VERSION;
                    break;
                }
                case 2: {
                    string2 = languageVersionSettings.getLanguageVersion().getVersionString();
                    break;
                }
                case 3: {
                    string2 = languageVersionSettings.getApiVersion().getVersionString();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String currentVersionString = string2;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory.on(element, targetOriginal, ((DeprecatedByVersionRequirement)deprecation).getVersionRequirement().getVersion(), (Pair<String, String>)TuplesKt.to((Object)currentVersionString, (Object)deprecation.getMessage()));
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"{\n            val factor\u2026e\n            )\n        }");
            diagnostic = parametrizedDiagnostic;
        } else if (descriptorBasedDeprecationInfo instanceof DeprecatedTypealiasByAnnotation) {
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> diagnosticFactory3;
            switch (WhenMappings.$EnumSwitchMapping$0[deprecation.getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> factory = diagnosticFactory3;
            TypeAliasDescriptor typeAliasDescriptor = ((DeprecatedTypealiasByAnnotation)deprecation).getTypeAliasTarget().getOriginal();
            DeclarationDescriptor declarationDescriptor2 = ((DeprecatedTypealiasByAnnotation)deprecation).getNested().getTarget().getOriginal();
            String string3 = ((DeprecatedTypealiasByAnnotation)deprecation).getNested().getMessage();
            if (string3 == null) {
                string3 = "";
            }
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory.on(element, typeAliasDescriptor, declarationDescriptor2, string3);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"{\n            val factor\u2026.message ?: \"\")\n        }");
            diagnostic = parametrizedDiagnostic;
        } else {
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> diagnosticFactory2;
            switch (WhenMappings.$EnumSwitchMapping$0[deprecation.getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory2 = Errors.DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory2 = Errors.DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> factory = diagnosticFactory2;
            String string4 = deprecation.getMessage();
            if (string4 == null) {
                string4 = "";
            }
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory.on(element, targetOriginal, string4);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"{\n            val factor\u2026.message ?: \"\")\n        }");
            diagnostic = parametrizedDiagnostic;
        }
        return diagnostic;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DeprecationLevelValue.values().length];
            nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
            nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
            nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProtoBuf.VersionRequirement.VersionKind.values().length];
            nArray[ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION.ordinal()] = 1;
            nArray[ProtoBuf.VersionRequirement.VersionKind.LANGUAGE_VERSION.ordinal()] = 2;
            nArray[ProtoBuf.VersionRequirement.VersionKind.API_VERSION.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

