/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi.impl;

import com.intellij.debugger.streams.psi.ChainTransformer;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaTypes;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.wrapper.CallArgument;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import com.intellij.debugger.streams.wrapper.impl.CallArgumentImpl;
import com.intellij.debugger.streams.wrapper.impl.IntermediateStreamCallImpl;
import com.intellij.debugger.streams.wrapper.impl.QualifierExpressionImpl;
import com.intellij.debugger.streams.wrapper.impl.StreamChainImpl;
import com.intellij.debugger.streams.wrapper.impl.TerminatorStreamCallImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class JavaChainTransformerImpl
implements ChainTransformer.Java {
    @Override
    @NotNull
    public StreamChain transform(@NotNull List<PsiMethodCallExpression> streamExpressions, @NotNull PsiElement context) {
        PsiMethodCallExpression firstCall;
        PsiExpression qualifierExpression;
        if (streamExpressions == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(1);
        }
        PsiType qualifierType = (qualifierExpression = (firstCall = streamExpressions.get(0)).getMethodExpression().getQualifierExpression()) == null ? null : qualifierExpression.getType();
        GenericType typeAfterQualifier = qualifierType == null ? JavaChainTransformerImpl.getGenericTypeOfThis(qualifierExpression) : JavaTypes.INSTANCE.fromStreamPsiType(qualifierType);
        QualifierExpressionImpl qualifier = qualifierExpression == null ? new QualifierExpressionImpl("", TextRange.EMPTY_RANGE, typeAfterQualifier) : new QualifierExpressionImpl(qualifierExpression.getText(), qualifierExpression.getTextRange(), typeAfterQualifier);
        List<IntermediateStreamCall> intermediateCalls = JavaChainTransformerImpl.createIntermediateCalls(typeAfterQualifier, streamExpressions.subList(0, streamExpressions.size() - 1));
        GenericType typeBefore = intermediateCalls.isEmpty() ? qualifier.getTypeAfter() : intermediateCalls.get(intermediateCalls.size() - 1).getTypeAfter();
        TerminatorStreamCall terminationCall = JavaChainTransformerImpl.createTerminationCall(typeBefore, streamExpressions.get(streamExpressions.size() - 1));
        return new StreamChainImpl(qualifier, intermediateCalls, terminationCall, context);
    }

    @NotNull
    private static GenericType getGenericTypeOfThis(PsiExpression expression) {
        PsiClass klass = ClassUtils.getContainingClass((PsiElement)expression);
        GenericType genericType = klass == null ? JavaTypes.INSTANCE.getANY() : JavaTypes.INSTANCE.fromPsiClass(klass);
        if (genericType == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(2);
        }
        return genericType;
    }

    @NotNull
    private static List<IntermediateStreamCall> createIntermediateCalls(@NotNull GenericType producerAfterType, @NotNull List<PsiMethodCallExpression> expressions) {
        if (producerAfterType == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(3);
        }
        if (expressions == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(4);
        }
        ArrayList<IntermediateStreamCall> result = new ArrayList<IntermediateStreamCall>();
        GenericType typeBefore = producerAfterType;
        for (PsiMethodCallExpression callExpression : expressions) {
            String name = JavaChainTransformerImpl.resolveMethodName(callExpression);
            List<CallArgument> args = JavaChainTransformerImpl.resolveArguments(callExpression);
            GenericType type = JavaChainTransformerImpl.resolveType(callExpression);
            result.add(new IntermediateStreamCallImpl(name, args, typeBefore, type, callExpression.getTextRange()));
            typeBefore = type;
        }
        ArrayList<IntermediateStreamCall> arrayList = result;
        if (arrayList == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static TerminatorStreamCall createTerminationCall(@NotNull GenericType typeBefore, @NotNull PsiMethodCallExpression expression) {
        if (typeBefore == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(6);
        }
        if (expression == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(7);
        }
        String name = JavaChainTransformerImpl.resolveMethodName(expression);
        List<CallArgument> args = JavaChainTransformerImpl.resolveArguments(expression);
        GenericType resultType = JavaChainTransformerImpl.resolveTerminationCallType(expression);
        return new TerminatorStreamCallImpl(name, args, typeBefore, resultType, expression.getTextRange());
    }

    @NotNull
    private static List<CallArgument> resolveArguments(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(8);
        }
        PsiExpressionList list2 = methodCall.getArgumentList();
        List list3 = (List)StreamEx.of((Object[])list2.getExpressions()).zipWith((Stream)StreamEx.of((Object[])list2.getExpressionTypes()), (expression, type) -> new CallArgumentImpl(GenericsUtil.getVariableTypeByExpressionType((PsiType)type).getCanonicalText(), expression.getText())).collect(Collectors.toList());
        if (list3 == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(9);
        }
        return list3;
    }

    @NotNull
    private static String resolveMethodName(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(10);
        }
        String name = methodCall.getMethodExpression().getReferenceName();
        Objects.requireNonNull(name, "Method reference must be not null" + methodCall.getText());
        String string = name;
        if (string == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static PsiType extractType(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(12);
        }
        PsiType returnType = expression.getType();
        Objects.requireNonNull(returnType, "Method return type must be not null" + expression.getText());
        PsiType psiType = returnType;
        if (psiType == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(13);
        }
        return psiType;
    }

    @NotNull
    private static GenericType resolveType(@NotNull PsiMethodCallExpression call2) {
        if (call2 == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(14);
        }
        GenericType genericType = JavaTypes.INSTANCE.fromStreamPsiType(JavaChainTransformerImpl.extractType(call2));
        if (genericType == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(15);
        }
        return genericType;
    }

    @NotNull
    private static GenericType resolveTerminationCallType(@NotNull PsiMethodCallExpression call2) {
        if (call2 == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(16);
        }
        GenericType genericType = JavaTypes.INSTANCE.fromPsiType(JavaChainTransformerImpl.extractType(call2));
        if (genericType == null) {
            JavaChainTransformerImpl.$$$reportNull$$$0(17);
        }
        return genericType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamExpressions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/psi/impl/JavaChainTransformerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerAfterType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeBefore";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/psi/impl/JavaChainTransformerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericTypeOfThis";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntermediateCalls";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArguments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMethodName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTerminationCallType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createIntermediateCalls";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTerminationCall";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveArguments";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveMethodName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveTerminationCallType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

