/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve.util;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.util.KotlinResolveScopeEnlarger;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"enlargedSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "searchScope", "module", "Lcom/intellij/openapi/module/Module;", "isTestScope", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "getResolveScope", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.core"})
public final class ScopeUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GlobalSearchScope getResolveScope(@NotNull KtFile file2) {
        GlobalSearchScope globalSearchScope;
        KtFile ktFile;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2 instanceof KtCodeFragment && (ktFile = ((KtCodeFragment)file2).getContextContainingFile()) != null && (ktFile = ktFile.getResolveScope()) != null) {
            GlobalSearchScope globalSearchScope2;
            KtFile ktFile2;
            KtFile it = ktFile2 = ktFile;
            boolean bl = false;
            IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getModuleInfo$default((PsiElement)file2, false, 1, null);
            if (ideaModuleInfo instanceof SourceForBinaryModuleInfo) {
                KtFile ktFile3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktFile3, (String)"it");
                Project project2 = ((KtCodeFragment)file2).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
                globalSearchScope2 = KotlinSourceFilterScope.Companion.libraryClassFiles((GlobalSearchScope)ktFile3, project2);
            } else {
                KtFile ktFile4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktFile4, (String)"it");
                Project project3 = ((KtCodeFragment)file2).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"file.project");
                globalSearchScope2 = KotlinSourceFilterScope.Companion.sourceAndClassFiles((GlobalSearchScope)ktFile4, project3);
            }
            return globalSearchScope2;
        }
        IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getModuleInfo$default((PsiElement)file2, false, 1, null);
        if (ideaModuleInfo instanceof ModuleSourceInfo) {
            GlobalSearchScope globalSearchScope3 = file2.getResolveScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"file.resolveScope");
            Project project4 = file2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"file.project");
            globalSearchScope = ScopeUtilsKt.enlargedSearchScope(KotlinSourceFilterScope.Companion.projectSourceAndClassFiles(globalSearchScope3, project4), (PsiFile)file2);
        } else if (ideaModuleInfo instanceof ScriptModuleInfo) {
            List list2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = GetModuleInfoKt.getModuleInfo$default((PsiElement)file2, false, 1, null).dependencies();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IdeaModuleInfo ideaModuleInfo2 = (IdeaModuleInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GlobalSearchScope globalSearchScope4 = it.contentScope();
                collection.add(globalSearchScope4);
            }
            List it = list2 = (List)destination$iv$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = it;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[0]);
            Intrinsics.checkNotNull((Object)globalSearchScopeArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            GlobalSearchScope globalSearchScope5 = GlobalSearchScope.union((GlobalSearchScope[])globalSearchScopeArray);
            globalSearchScope = globalSearchScope5;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope5, (String)"GlobalSearchScope.union(it.toTypedArray())");
        } else {
            GlobalSearchScope globalSearchScope6 = GlobalSearchScope.EMPTY_SCOPE;
            globalSearchScope = globalSearchScope6;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope6, (String)"GlobalSearchScope.EMPTY_SCOPE");
        }
        return globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GlobalSearchScope enlargedSearchScope(@NotNull GlobalSearchScope searchScope2, @Nullable PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        PsiFile psiFile3 = psiFile2;
        if (psiFile3 == null || (psiFile3 = psiFile3.getOriginalFile()) == null || (psiFile3 = psiFile3.getVirtualFile()) == null) {
            return searchScope2;
        }
        PsiFile vFile = psiFile3;
        ExtensionPointName extensionPointName = ResolveScopeEnlarger.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ResolveScopeEnlarger.EP_NAME");
        Object[] objectArray = extensionPointName.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ResolveScopeEnlarger.EP_NAME.extensions");
        Object[] $this$fold$iv = objectArray;
        boolean $i$f$fold = false;
        GlobalSearchScope accumulator$iv = searchScope2;
        for (Object element$iv : $this$fold$iv) {
            GlobalSearchScope globalSearchScope;
            block6: {
                GlobalSearchScope scope2;
                block7: {
                    GlobalSearchScope globalSearchScope2;
                    void enlarger;
                    Project project2;
                    block5: {
                        ResolveScopeEnlarger resolveScopeEnlarger = (ResolveScopeEnlarger)element$iv;
                        scope2 = accumulator$iv;
                        boolean bl = false;
                        if (scope2.getProject() != null) break block5;
                        globalSearchScope = scope2;
                        break block6;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"scope.project ?: return@fold scope");
                    globalSearchScope = enlarger.getAdditionalResolveScope((VirtualFile)vFile, project2);
                    if (globalSearchScope == null) break block7;
                    GlobalSearchScope it = globalSearchScope2 = globalSearchScope;
                    boolean bl = false;
                    globalSearchScope = scope2.union((SearchScope)it);
                    if (globalSearchScope != null) break block6;
                }
                globalSearchScope = scope2;
            }
            accumulator$iv = globalSearchScope;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GlobalSearchScope enlargedSearchScope(@NotNull GlobalSearchScope searchScope2, @NotNull Module module2, boolean isTestScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Object[] objectArray = KotlinResolveScopeEnlarger.Companion.getEP_NAME().getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"KotlinResolveScopeEnlarger.EP_NAME.extensions");
        Object[] $this$fold$iv = objectArray;
        boolean $i$f$fold = false;
        GlobalSearchScope accumulator$iv = searchScope2;
        for (Object element$iv : $this$fold$iv) {
            GlobalSearchScope globalSearchScope;
            void enlarger;
            KotlinResolveScopeEnlarger kotlinResolveScopeEnlarger = (KotlinResolveScopeEnlarger)element$iv;
            GlobalSearchScope scope2 = accumulator$iv;
            boolean bl = false;
            SearchScope extra = enlarger.getAdditionalResolveScope(module2, isTestScope);
            if (extra != null) {
                GlobalSearchScope globalSearchScope2 = scope2.union(extra);
                globalSearchScope = globalSearchScope2;
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"scope.union(extra)");
            } else {
                globalSearchScope = scope2;
            }
            accumulator$iv = globalSearchScope;
        }
        return accumulator$iv;
    }
}

