/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"ANDROIDX_COMPOSE_PACKAGE_NAME", "", "COMPOSABLE_SINGLETONS_PREFIX", "computeComposableSingletonsClassName", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getClassPrepareRequestForComposableSingletons", "Lcom/sun/jdi/request/ClassPrepareRequest;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "getComposableSingletonsClasses", "", "Lcom/sun/jdi/ReferenceType;", "isInsideProjectWithCompose", "", "Lcom/intellij/debugger/SourcePosition;", "kotlin.jvm-debugger.core"})
public final class ComposeUtilsKt {
    private static final String COMPOSABLE_SINGLETONS_PREFIX = "ComposableSingletons";
    private static final String ANDROIDX_COMPOSE_PACKAGE_NAME = "androidx.compose";

    @NotNull
    public static final String computeComposableSingletonsClassName(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object object = file2.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            object = file2.getName();
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.virtualFile?.path ?: file.name");
        Object filePath = object;
        String fileName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)filePath), (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null));
        String shortName = PackagePartClassUtils.getFilePartShortName((String)fileName);
        boolean $i$f$runReadAction = false;
        FqName fileClassFqName = ((JvmFileClassInfo)ApplicationManager.getApplication().runReadAction(new Computable(file2){
            final /* synthetic */ KtFile $file$inlined;
            {
                this.$file$inlined = ktFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)this.$file$inlined);
            }
        })).getFacadeClassFqName();
        String classNameSuffix = "ComposableSingletons$" + shortName;
        FqName fqName2 = fileClassFqName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"fileClassFqName.parent()");
        FqName filePackageName = fqName2;
        if (filePackageName.isRoot()) {
            return classNameSuffix;
        }
        return filePackageName.asString() + "." + classNameSuffix;
    }

    public static final boolean isInsideProjectWithCompose(@NotNull SourcePosition $this$isInsideProjectWithCompose) {
        Intrinsics.checkNotNullParameter((Object)$this$isInsideProjectWithCompose, (String)"$this$isInsideProjectWithCompose");
        Object object = ReadAction.nonBlocking((Callable)new Callable($this$isInsideProjectWithCompose){
            final /* synthetic */ SourcePosition $this_isInsideProjectWithCompose;

            public final Boolean call() {
                PsiFile psiFile2 = this.$this_isInsideProjectWithCompose.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file");
                return JavaPsiFacade.getInstance((Project)psiFile2.getProject()).findPackage("androidx.compose") != null;
            }
            {
                this.$this_isInsideProjectWithCompose = sourcePosition2;
            }
        }).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ReadAction.nonBlocking<B\u2026 }.executeSynchronously()");
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ReferenceType> getComposableSingletonsClasses(@NotNull DebugProcess debugProcess, @NotNull KtFile file2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        VirtualMachineProxy vm = debugProcess.getVirtualMachineProxy();
        String composableSingletonsClassName = ComposeUtilsKt.computeComposableSingletonsClassName(file2);
        List list2 = vm.classesByName(composableSingletonsClassName);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"vm.classesByName(composableSingletonsClassName)");
        Iterable $this$flatMap$iv = list2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ReferenceType referenceType = (ReferenceType)element$iv$iv;
            boolean bl = false;
            ReferenceType referenceType2 = referenceType;
            Intrinsics.checkNotNullExpressionValue((Object)referenceType2, (String)"referenceType");
            Iterable list$iv$iv = referenceType2.isPrepared() ? vm.nestedTypes(referenceType) : CollectionsKt.emptyList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ClassPrepareRequest getClassPrepareRequestForComposableSingletons(@NotNull DebugProcess debugProcess, @NotNull ClassPrepareRequestor requestor, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return debugProcess.getRequestsManager().createClassPrepareRequest(requestor, ComposeUtilsKt.computeComposableSingletonsClassName(file2) + "$*");
    }
}

