/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.ClosedRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.KotlinFileTypeFactoryUtils;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.ClassNameCalculatorKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.MockStackFrame;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u001a\u000e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001c\u001a\u001e\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0004\u001a\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001c\u001a\u000e\u0010#\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001c\u001a\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u001a\n\u0010&\u001a\u00020\u0003*\u00020'\u001a\u0010\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)*\u00020'\u001a1\u0010*\u001a\u0004\u0018\u0001H+\"\b\b\u0000\u0010+*\u00020,*\u00020\u00042\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u0001H+0.\u00a2\u0006\u0002\u0010/\u001a\n\u00100\u001a\u00020\u0003*\u00020\u001c\u001a\n\u00100\u001a\u00020\u0003*\u00020'\u001a\u0010\u00101\u001a\b\u0012\u0004\u0012\u00020\u00030)*\u00020'\u001a\n\u00102\u001a\u00020\u0003*\u000203\u001a\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020605*\u00020\u001c2\u0006\u0010!\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u00067"}, d2={"INVOKE_SUSPEND_SIGNATURE", "", "canRunEvaluation", "", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getCanRunEvaluation", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)Z", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "(Lcom/intellij/debugger/impl/DebuggerContextImpl;)Z", "continuationAsmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "findCallByEndToken", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "element", "Lcom/intellij/psi/PsiElement;", "findElementAtLine", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "functionNameByArgument", "elementAt", "Lorg/jetbrains/kotlin/psi/KtFunction;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "functionNameByLocalVariable", "name", "getFirstMethodLocation", "Lcom/sun/jdi/Location;", "location", "isInSuspendMethod", "isInsideInlineArgument", "inlineArgument", "debugProcess", "isOnSuspendReturnOrReenter", "isOneLineMethod", "lambdaOrdinalByArgument", "lambdaOrdinalByLocalVariable", "containsKotlinStrata", "Lcom/sun/jdi/ReferenceType;", "containsKotlinStrataAsync", "Ljava/util/concurrent/CompletableFuture;", "invokeInManagerThread", "T", "", "f", "Lkotlin/Function1;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isInKotlinSources", "isInKotlinSourcesAsync", "isOnSuspensionPoint", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "visibleVariables", "", "Lcom/sun/jdi/LocalVariable;", "kotlin.jvm-debugger.core"})
public final class DebuggerUtilKt {
    private static final String INVOKE_SUSPEND_SIGNATURE = "(Ljava/lang/Object;)Ljava/lang/Object;";

    public static final boolean isInKotlinSources(@NotNull Location $this$isInKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSources, (String)"$this$isInKotlinSources");
        ReferenceType referenceType = $this$isInKotlinSources.declaringType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType()");
        return DebuggerUtilKt.isInKotlinSources(referenceType);
    }

    public static final boolean isInKotlinSources(@NotNull ReferenceType $this$isInKotlinSources) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSources, (String)"$this$isInKotlinSources");
                string = SafeUtilKt.safeSourceName($this$isInKotlinSources);
                if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)) == null) break block2;
                String string2 = string;
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
                string = string3;
                if (string3 != null) break block3;
            }
            string = "";
        }
        String fileExtension2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS, (String)"KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS");
        return ArraysKt.contains((Object[])KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS, (Object)fileExtension2) || DebuggerUtilKt.containsKotlinStrata($this$isInKotlinSources);
    }

    @NotNull
    public static final CompletableFuture<Boolean> isInKotlinSourcesAsync(@NotNull ReferenceType $this$isInKotlinSourcesAsync) {
        Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSourcesAsync, (String)"$this$isInKotlinSourcesAsync");
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)DebuggerUtilsAsync.sourceName((ReferenceType)$this$isInKotlinSourcesAsync).thenApply((Function)isInKotlinSourcesAsync.1.INSTANCE)).exceptionally((Function)isInKotlinSourcesAsync.2.INSTANCE)).thenCombine(DebuggerUtilKt.containsKotlinStrataAsync($this$isInKotlinSourcesAsync), (BiFunction)isInKotlinSourcesAsync.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"DebuggerUtilsAsync.sourc\u2026tlinExt || kotlinStrata }");
        return completionStage;
    }

    public static final boolean containsKotlinStrata(@NotNull ReferenceType $this$containsKotlinStrata) {
        Intrinsics.checkNotNullParameter((Object)$this$containsKotlinStrata, (String)"$this$containsKotlinStrata");
        return $this$containsKotlinStrata.availableStrata().contains("Kotlin");
    }

    @NotNull
    public static final CompletableFuture<Boolean> containsKotlinStrataAsync(@NotNull ReferenceType $this$containsKotlinStrataAsync) {
        Intrinsics.checkNotNullParameter((Object)$this$containsKotlinStrataAsync, (String)"$this$containsKotlinStrataAsync");
        CompletionStage completionStage = DebuggerUtilsAsync.availableStrata((ReferenceType)$this$containsKotlinStrataAsync).thenApply((Function)containsKotlinStrataAsync.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"DebuggerUtilsAsync.avail\u2026ins(KOTLIN_STRATA_NAME) }");
        return completionStage;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isInsideInlineArgument(@NotNull KtFunction inlineArgument, @NotNull Location location2, @NotNull DebugProcessImpl debugProcess) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)inlineArgument, (String)"inlineArgument");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        List<LocalVariable> visibleVariables = DebuggerUtilKt.visibleVariables(location2, debugProcess);
        Iterable $this$filter$iv = visibleVariables;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LocalVariable it = (LocalVariable)element$iv$iv;
            boolean bl = false;
            String string = it.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name()");
            if (!StringsKt.startsWith$default((String)string, (String)"$i$a$", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List markerLocalVariables = (List)destination$iv$iv;
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(inlineArgument, markerLocalVariables){
            final /* synthetic */ KtFunction $inlineArgument;
            final /* synthetic */ List $markerLocalVariables;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                boolean bl;
                block8: {
                    void $this$mapTo$iv$iv;
                    int lambdaOrdinal = DebuggerUtilKt.access$lambdaOrdinalByArgument(this.$inlineArgument);
                    String functionName = DebuggerUtilKt.access$functionNameByArgument(this.$inlineArgument, ResolutionUtils.analyze((KtElement)this.$inlineArgument, BodyResolveMode.PARTIAL));
                    Iterable $this$map$iv = this.$markerLocalVariables;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        LocalVariable localVariable = (LocalVariable)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        String string = it.name();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name()");
                        String string2 = StringsKt.drop((String)string, (int)"$i$a$".length());
                        collection.add(string2);
                    }
                    Iterable $this$any$iv = (List)destination$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (E element$iv : $this$any$iv) {
                            boolean bl3;
                            String variableName = (String)element$iv;
                            boolean bl4 = false;
                            if (StringsKt.startsWith$default((String)variableName, (String)"-", (boolean)false, (int)2, null)) {
                                String string = ClassNameCalculatorKt.getClassNameCompat(ClassNameCalculator.INSTANCE, (KtElement)this.$inlineArgument);
                                if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)) == null) {
                                    bl3 = false;
                                } else {
                                    String lambdaClassName = string;
                                    bl3 = Intrinsics.areEqual((Object)InlineUtilsKt.dropInlineSuffix(variableName), (Object)("-" + functionName + "-" + lambdaClassName));
                                }
                            } else {
                                bl3 = DebuggerUtilKt.access$lambdaOrdinalByLocalVariable(variableName) == lambdaOrdinal && Intrinsics.areEqual((Object)DebuggerUtilKt.access$functionNameByLocalVariable(variableName), (Object)functionName);
                            }
                            if (!bl3) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$inlineArgument = ktFunction;
                this.$markerLocalVariables = list2;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> T invokeInManagerThread(@NotNull DebugProcessImpl $this$invokeInManagerThread, @NotNull Function1<? super DebuggerContextImpl, ? extends T> f2) {
        void result2;
        Intrinsics.checkNotNullParameter((Object)$this$invokeInManagerThread, (String)"$this$invokeInManagerThread");
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        DebuggerCommandImpl command2 = new DebuggerCommandImpl($this$invokeInManagerThread, (Ref.ObjectRef)result2, f2){
            final /* synthetic */ DebugProcessImpl $this_invokeInManagerThread;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ Function1 $f;

            protected void action() {
                DebuggerContextImpl debuggerContextImpl = this.$this_invokeInManagerThread.getDebuggerContext();
                Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"debuggerContext");
                this.$result.element = this.$f.invoke((Object)debuggerContextImpl);
            }
            {
                this.$this_invokeInManagerThread = $receiver;
                this.$result = $captured_local_variable$1;
                this.$f = $captured_local_variable$2;
            }
        };
        if (DebuggerManagerThreadImpl.isManagerThread()) {
            $this$invokeInManagerThread.getManagerThread().invoke(command2);
        } else {
            $this$invokeInManagerThread.getManagerThread().invokeAndWait(command2);
        }
        return (T)result2.element;
    }

    private static final int lambdaOrdinalByArgument(KtFunction elementAt) {
        String string = ClassNameCalculatorKt.getClassNameCompat(ClassNameCalculator.INSTANCE, (KtElement)elementAt);
        if (string == null) {
            return 0;
        }
        String className2 = string;
        String string2 = StringsKt.substringAfterLast$default((String)className2, (String)"$", null, (int)2, null);
        return Integer.parseInt(string2);
    }

    private static final String functionNameByArgument(KtFunction elementAt, BindingContext context2) {
        ValueParameterDescriptor inlineArgumentDescriptor = InlineUtil.getInlineArgumentDescriptor((KtFunction)elementAt, (BindingContext)context2);
        Object object = inlineArgumentDescriptor;
        if (object == null || (object = object.getContainingDeclaration()) == null || (object = object.getName()) == null || (object = object.asString()) == null) {
            object = "unknown";
        }
        return object;
    }

    private static final List<LocalVariable> visibleVariables(Location $this$visibleVariables, DebugProcessImpl debugProcess) {
        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcess.getVirtualMachineProxy();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachineProxyImpl, (String)"debugProcess.virtualMachineProxy");
        VirtualMachine virtualMachine = virtualMachineProxyImpl.getVirtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"debugProcess.virtualMachineProxy.virtualMachine");
        MockStackFrame stackFrame = new MockStackFrame($this$visibleVariables, virtualMachine);
        return stackFrame.visibleVariables();
    }

    private static final int lambdaOrdinalByLocalVariable(String name2) {
        int n;
        try {
            String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
            n = Integer.parseInt(StringsKt.substringBefore((String)nameWithoutPrefix, (String)"$", (String)nameWithoutPrefix));
        }
        catch (NumberFormatException e) {
            n = 0;
        }
        return n;
    }

    private static final String functionNameByLocalVariable(String name2) {
        String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
        return StringsKt.substringAfterLast((String)nameWithoutPrefix, (String)"$", (String)"unknown");
    }

    public static final boolean isOnSuspensionPoint(@NotNull StackFrameProxyImpl $this$isOnSuspensionPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$isOnSuspensionPoint, (String)"$this$isOnSuspensionPoint");
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)$this$isOnSuspensionPoint);
        if (location2 == null) {
            return false;
        }
        Location location3 = location2;
        if (DebuggerUtilKt.isInSuspendMethod(location3)) {
            Location location4 = DebuggerUtilKt.getFirstMethodLocation(location3);
            if (location4 == null) {
                return false;
            }
            Location firstLocation = location4;
            return SafeUtilKt.safeLineNumber(firstLocation) == SafeUtilKt.safeLineNumber(location3) && firstLocation.codeIndex() != location3.codeIndex();
        }
        return false;
    }

    public static final boolean isInSuspendMethod(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Method method = location2.method();
        String signature = method.signature();
        Type continuationAsmType = DebuggerUtilKt.continuationAsmType();
        String string = signature;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature");
        CharSequence charSequence = string;
        String string2 = continuationAsmType.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"continuationAsmType.toString()");
        return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)signature, (Object)INVOKE_SUSPEND_SIGNATURE);
    }

    private static final Type continuationAsmType() {
        FqName fqName2 = StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier((String)"Continuation"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"StandardNames.COROUTINES\u2026entifier(\"Continuation\"))");
        return CodegenUtilKt.topLevelClassAsmType((FqName)fqName2);
    }

    private static final Location getFirstMethodLocation(Location location2) {
        Mirror mirror = SafeUtilKt.safeMethod(location2);
        if (mirror == null || (mirror = mirror.location()) == null) {
            return null;
        }
        Mirror firstLocation = mirror;
        if (SafeUtilKt.safeLineNumber((Location)firstLocation) < 0) {
            return null;
        }
        return firstLocation;
    }

    public static final boolean isOnSuspendReturnOrReenter(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Location location3 = DebuggerUtilKt.getFirstMethodLocation(location2);
        if (location3 == null) {
            return false;
        }
        Location firstLocation = location3;
        return SafeUtilKt.safeLineNumber(firstLocation) == SafeUtilKt.safeLineNumber(location2);
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean isOneLineMethod(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        v0 = SafeUtilKt.safeMethod(location);
        if (v0 == null) {
            return false;
        }
        method = v0;
        allLineLocations = SafeUtilKt.safeAllLineLocations(method);
        if (allLineLocations.isEmpty()) {
            return false;
        }
        if (allLineLocations.size() == 1) {
            return true;
        }
        inlineFunctionBorders = KotlinPositionManagerKt.getInlineFunctionAndArgumentVariablesToBordersMap(method).values();
        var4_4 = allLineLocations;
        $i$f$mapNotNull = false;
        var6_6 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var11_11 = $this$forEach$iv$iv$iv.iterator();
        while (var11_11.hasNext()) {
            block9: {
                element$iv$iv = element$iv$iv$iv = var11_11.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                loc = (Location)element$iv$iv;
                $i$a$-mapNotNull-DebuggerUtilKt$isOneLineMethod$1 = false;
                if (DebuggerUtils.INSTANCE.isKotlinFakeLineNumber(loc)) ** GOTO lbl-1000
                $this$any$iv = inlineFunctionBorders;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (ClosedRange)element$iv;
                        $i$a$-any-DebuggerUtilKt$isOneLineMethod$1$1 = false;
                        if (!it.contains((Comparable)loc)) continue;
                        v1 = true;
                        break block9;
                    }
                    v1 = false;
                }
            }
            if (!v1) {
                v2 = loc.lineNumber();
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
            if (v2 == null) continue;
            it$iv$iv = var23_23 = v2;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv)).size() == 1;
    }

    @Nullable
    public static final PsiElement findElementAtLine(@NotNull KtFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file2, line);
        if (n == null) {
            return null;
        }
        int lineStartOffset = n;
        Integer n2 = PsiLinesUtilsKt.getLineEndOffset((PsiFile)file2, line);
        if (n2 == null) {
            return null;
        }
        int lineEndOffset = n2;
        return (PsiElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiElement>(lineStartOffset, lineEndOffset, file2){
            final /* synthetic */ int $lineStartOffset;
            final /* synthetic */ int $lineEndOffset;
            final /* synthetic */ KtFile $file;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final PsiElement invoke() {
                void var1_1;
                void offset2;
                PsiElement topMostElement = null;
                PsiElement elementAt = null;
                int n = this.$lineStartOffset;
                int n2 = this.$lineEndOffset;
                while (!(n >= n2 || (elementAt = this.$file.findElementAt((int)offset2)) != null && (topMostElement = CodeInsightUtils.getTopmostElementAtOffset(elementAt, (int)offset2)) instanceof KtElement)) {
                    ++offset2;
                }
                return var1_1;
            }
            {
                this.$lineStartOffset = n;
                this.$lineEndOffset = n2;
                this.$file = ktFile;
                super(0);
            }
        });
    }

    @Nullable
    public static final KtCallExpression findCallByEndToken(@NotNull PsiElement element3) {
        KtCallExpression ktCallExpression;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3 instanceof KtElement) {
            return null;
        }
        ASTNode aSTNode = element3.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
        IElementType iElementType = aSTNode.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RPAR)) {
            PsiElement psiElement2 = element3.getParent();
            if (!(psiElement2 instanceof KtValueArgumentList)) {
                psiElement2 = null;
            }
            KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement2;
            Object object = ktValueArgumentList != null ? ktValueArgumentList.getParent() : null;
            if (!(object instanceof KtCallExpression)) {
                object = null;
            }
            ktCallExpression = (KtCallExpression)object;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RBRACE)) {
            PsiElement psiElement3 = CodeInsightUtils.getTopParentWithEndOffset(element3, KtCallExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"CodeInsightUtils.getTopP\u2026llExpression::class.java)");
            PsiElement braceParent = psiElement3;
            if (braceParent instanceof KtCallExpression) {
                ktCallExpression = (KtCallExpression)braceParent;
            } else if (braceParent instanceof KtLambdaArgument) {
                PsiElement psiElement4 = ((KtLambdaArgument)braceParent).getParent();
                if (!(psiElement4 instanceof KtCallExpression)) {
                    psiElement4 = null;
                }
                ktCallExpression = (KtCallExpression)psiElement4;
            } else if (braceParent instanceof KtValueArgument) {
                PsiElement psiElement5 = ((KtValueArgument)braceParent).getParent();
                if (!(psiElement5 instanceof KtValueArgumentList)) {
                    psiElement5 = null;
                }
                KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement5;
                Object object = ktValueArgumentList != null ? ktValueArgumentList.getParent() : null;
                if (!(object instanceof KtCallExpression)) {
                    object = null;
                }
                ktCallExpression = (KtCallExpression)object;
            } else {
                ktCallExpression = null;
            }
        } else {
            ktCallExpression = null;
        }
        return ktCallExpression;
    }

    public static final boolean getCanRunEvaluation(@NotNull DebuggerContextImpl $this$canRunEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$canRunEvaluation, (String)"$this$canRunEvaluation");
        DebugProcessImpl debugProcessImpl = $this$canRunEvaluation.getDebugProcess();
        return debugProcessImpl != null ? DebuggerUtilKt.getCanRunEvaluation(debugProcessImpl) : false;
    }

    public static final boolean getCanRunEvaluation(@NotNull DebugProcessImpl $this$canRunEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$canRunEvaluation, (String)"$this$canRunEvaluation");
        SuspendManager suspendManager = $this$canRunEvaluation.getSuspendManager();
        Intrinsics.checkNotNullExpressionValue((Object)suspendManager, (String)"suspendManager");
        return suspendManager.getPausedContext() != null;
    }

    public static final /* synthetic */ int access$lambdaOrdinalByArgument(KtFunction elementAt) {
        return DebuggerUtilKt.lambdaOrdinalByArgument(elementAt);
    }

    public static final /* synthetic */ String access$functionNameByArgument(KtFunction elementAt, BindingContext context2) {
        return DebuggerUtilKt.functionNameByArgument(elementAt, context2);
    }

    public static final /* synthetic */ int access$lambdaOrdinalByLocalVariable(String name2) {
        return DebuggerUtilKt.lambdaOrdinalByLocalVariable(name2);
    }

    public static final /* synthetic */ String access$functionNameByLocalVariable(String name2) {
        return DebuggerUtilKt.functionNameByLocalVariable(name2);
    }
}

