/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.util;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.TypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendExitMode;
import org.jetbrains.kotlin.idea.debugger.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\r\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\r\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0011\u001a\u0012\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\f*\u00020\u0016\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u0016\u001a\u0012\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\f*\u00020\u0016\u001a\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u0004*\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u001e\u001a\u00020\u001f*\u00020\u001d\u001a\n\u0010 \u001a\u00020\u000f*\u00020!\u001a+\u0010\"\u001a\u0004\u0018\u0001H#\"\b\b\u0000\u0010#*\u00020$*\u00020\u00112\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H#0&\u00a2\u0006\u0002\u0010'\u001a\n\u0010(\u001a\u00020\u000f*\u00020)\u001a\n\u0010*\u001a\u00020\u000f*\u00020)\u001a\n\u0010+\u001a\u00020\u000f*\u00020\u0018\u001a\n\u0010,\u001a\u00020\u000f*\u00020)\u001a\n\u0010-\u001a\u00020\u000f*\u00020.\u001a\u0014\u0010/\u001a\u00020\u000f*\u00020\u001d2\b\u00100\u001a\u0004\u0018\u00010\u001d\u001a\u0014\u00101\u001a\u00020\u000f*\u00020\u001d2\b\u00100\u001a\u0004\u0018\u00010\u001d\u001a\n\u00102\u001a\u00020\u000f*\u00020\u001d\u001a\f\u00103\u001a\u00020\u000f*\u00020!H\u0002\u001a\n\u00104\u001a\u00020\u000f*\u00020!\u001a\n\u00105\u001a\u00020\u000f*\u00020\u001d\u001a\n\u00105\u001a\u00020\u000f*\u00020!\u001a\n\u00106\u001a\u00020\u000f*\u00020\u001d\u001a\u0012\u00107\u001a\u00020\u000f*\u00020)2\u0006\u0010\u0007\u001a\u00020\u0001\u001a\n\u00108\u001a\u00020\u000f*\u00020!\u001a\n\u00108\u001a\u00020\u000f*\u00020\u0018\u001a\n\u00109\u001a\u00020\u000f*\u00020\u001d\u001a\u0014\u0010:\u001a\u00020\u000f*\u00020\u001d2\b\u00100\u001a\u0004\u0018\u00010\u001d\u001a\n\u0010;\u001a\u00020\u000f*\u00020\u0011\u001a\n\u0010;\u001a\u00020\u000f*\u00020<\u001a\f\u0010=\u001a\u0004\u0018\u00010\u0014*\u00020\r\u001a\u0014\u0010>\u001a\u0004\u0018\u00010\u0014*\u00020\r2\u0006\u0010?\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"CREATION_CLASS_NAME", "", "CREATION_STACK_TRACE_SEPARATOR", "getPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "project", "Lcom/intellij/openapi/project/Project;", "className", "lineNumber", "", "hasGetCoroutineSuspended", "frames", "", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "threadAndContextSupportsEvaluation", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "frameProxy", "continuationVariableValue", "Lcom/sun/jdi/ObjectReference;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "findCancellableContinuationImplReferenceType", "Lcom/sun/jdi/ReferenceType;", "findCoroutineMetadataType", "Lcom/sun/jdi/ClassType;", "findDispatchedContinuationReferenceType", "findPosition", "Lcom/sun/jdi/Location;", "getSuspendExitMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/SuspendExitMode;", "hasContinuationParameter", "Lcom/sun/jdi/Method;", "invokeInManagerThread", "T", "", "f", "Lkotlin/Function0;", "(Lcom/intellij/debugger/engine/SuspendContextImpl;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isAbstractCoroutine", "Lcom/sun/jdi/Type;", "isBaseContinuationImpl", "isContinuation", "isCoroutineScope", "isCreationSeparatorFrame", "Ljava/lang/StackTraceElement;", "isFilterFromBottom", "location", "isFilterFromTop", "isFilteredInvokeSuspend", "isGetCoroutineSuspended", "isInvoke", "isInvokeSuspend", "isInvokeSuspendWithNegativeLineNumber", "isSubTypeOrSame", "isSuspendLambda", "safeCoroutineExitPointLineNumber", "sameLineAndMethod", "supportsEvaluation", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "thisVariableValue", "variableValue", "variableName", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineUtilsKt {
    @NotNull
    public static final String CREATION_STACK_TRACE_SEPARATOR = "\b\b\b";
    @NotNull
    public static final String CREATION_CLASS_NAME = "_COROUTINE._CREATION";

    public static final boolean isInvokeSuspend(@NotNull Method $this$isInvokeSuspend) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeSuspend, (String)"$this$isInvokeSuspend");
        return Intrinsics.areEqual((Object)$this$isInvokeSuspend.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)$this$isInvokeSuspend.signature(), (Object)"(Ljava/lang/Object;)Ljava/lang/Object;");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInvoke(@NotNull Method $this$isInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvoke, (String)"$this$isInvoke");
        if (!Intrinsics.areEqual((Object)$this$isInvoke.name(), (Object)"invoke")) return false;
        String string = $this$isInvoke.signature();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature()");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Ljava/lang/Object;)Ljava/lang/Object;", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuspendLambda(@NotNull Method $this$isSuspendLambda) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendLambda, (String)"$this$isSuspendLambda");
        if (!CoroutineUtilsKt.isInvokeSuspend($this$isSuspendLambda)) return false;
        ReferenceType referenceType = $this$isSuspendLambda.declaringType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType()");
        if (!CoroutineUtilsKt.isSuspendLambda(referenceType)) return false;
        return true;
    }

    public static final boolean hasContinuationParameter(@NotNull Method $this$hasContinuationParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$hasContinuationParameter, (String)"$this$hasContinuationParameter");
        String string = $this$hasContinuationParameter.signature();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature()");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"Lkotlin/coroutines/Continuation;)", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final SuspendExitMode getSuspendExitMode(@NotNull Location $this$getSuspendExitMode) {
        Intrinsics.checkNotNullParameter((Object)$this$getSuspendExitMode, (String)"$this$getSuspendExitMode");
        Method method = SafeUtilKt.safeMethod($this$getSuspendExitMode);
        if (method == null) {
            return SuspendExitMode.NONE;
        }
        Method method2 = method;
        if (CoroutineUtilsKt.isSuspendLambda(method2)) {
            return SuspendExitMode.SUSPEND_LAMBDA;
        }
        if (CoroutineUtilsKt.hasContinuationParameter(method2)) {
            return SuspendExitMode.SUSPEND_METHOD_PARAMETER;
        }
        if ((CoroutineUtilsKt.isInvokeSuspend(method2) || CoroutineUtilsKt.isInvoke(method2)) && CoroutineUtilsKt.safeCoroutineExitPointLineNumber($this$getSuspendExitMode)) {
            return SuspendExitMode.SUSPEND_METHOD;
        }
        return SuspendExitMode.NONE;
    }

    public static final boolean safeCoroutineExitPointLineNumber(@NotNull Location $this$safeCoroutineExitPointLineNumber) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$safeCoroutineExitPointLineNumber, (String)"$this$safeCoroutineExitPointLineNumber");
        boolean $i$f$wrapIllegalArgumentException = false;
        try {
            boolean bl = false;
            n = DebuggerUtilsEx.getLineNumber((Location)$this$safeCoroutineExitPointLineNumber, (boolean)false);
        }
        catch (IllegalArgumentException e$iv) {
            n = null;
        }
        Integer n2 = n;
        return (n2 != null ? n2 : -2) == -1;
    }

    public static final boolean isContinuation(@NotNull ReferenceType $this$isContinuation) {
        Intrinsics.checkNotNullParameter((Object)$this$isContinuation, (String)"$this$isContinuation");
        return CoroutineUtilsKt.isBaseContinuationImpl($this$isContinuation) || TypeUtilsKt.isSubtype((Type)$this$isContinuation, "kotlin.coroutines.Continuation");
    }

    public static final boolean isBaseContinuationImpl(@NotNull Type $this$isBaseContinuationImpl) {
        Intrinsics.checkNotNullParameter((Object)$this$isBaseContinuationImpl, (String)"$this$isBaseContinuationImpl");
        return TypeUtilsKt.isSubtype($this$isBaseContinuationImpl, "kotlin.coroutines.jvm.internal.BaseContinuationImpl");
    }

    public static final boolean isAbstractCoroutine(@NotNull Type $this$isAbstractCoroutine) {
        Intrinsics.checkNotNullParameter((Object)$this$isAbstractCoroutine, (String)"$this$isAbstractCoroutine");
        return TypeUtilsKt.isSubtype($this$isAbstractCoroutine, "kotlinx.coroutines.AbstractCoroutine");
    }

    public static final boolean isCoroutineScope(@NotNull Type $this$isCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)$this$isCoroutineScope, (String)"$this$isCoroutineScope");
        return TypeUtilsKt.isSubtype($this$isCoroutineScope, "kotlinx.coroutines.CoroutineScope");
    }

    public static final boolean isSubTypeOrSame(@NotNull Type $this$isSubTypeOrSame, @NotNull String className2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubTypeOrSame, (String)"$this$isSubTypeOrSame");
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        return Intrinsics.areEqual((Object)$this$isSubTypeOrSame.name(), (Object)className2) || TypeUtilsKt.isSubtype($this$isSubTypeOrSame, className2);
    }

    public static final boolean isSuspendLambda(@NotNull ReferenceType $this$isSuspendLambda) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isSuspendLambda, (String)"$this$isSuspendLambda");
            Iterable $this$any$iv = org.jetbrains.kotlin.idea.debugger.CoroutineUtilsKt.getSUSPEND_LAMBDA_CLASSES();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!TypeUtilsKt.isSubtype((Type)$this$isSuspendLambda, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isInvokeSuspend(@NotNull Location $this$isInvokeSuspend) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeSuspend, (String)"$this$isInvokeSuspend");
        Method method = SafeUtilKt.safeMethod($this$isInvokeSuspend);
        return method != null ? CoroutineUtilsKt.isInvokeSuspend(method) : false;
    }

    public static final boolean isInvokeSuspendWithNegativeLineNumber(@NotNull Location $this$isInvokeSuspendWithNegativeLineNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeSuspendWithNegativeLineNumber, (String)"$this$isInvokeSuspendWithNegativeLineNumber");
        return CoroutineUtilsKt.isInvokeSuspend($this$isInvokeSuspendWithNegativeLineNumber) && SafeUtilKt.safeLineNumber($this$isInvokeSuspendWithNegativeLineNumber) < 0;
    }

    public static final boolean isFilteredInvokeSuspend(@NotNull Location $this$isFilteredInvokeSuspend) {
        Intrinsics.checkNotNullParameter((Object)$this$isFilteredInvokeSuspend, (String)"$this$isFilteredInvokeSuspend");
        return CoroutineUtilsKt.isInvokeSuspend($this$isFilteredInvokeSuspend) || CoroutineUtilsKt.isInvokeSuspendWithNegativeLineNumber($this$isFilteredInvokeSuspend);
    }

    @Nullable
    public static final ObjectReference variableValue(@NotNull StackFrameProxyImpl $this$variableValue, @NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)$this$variableValue, (String)"$this$variableValue");
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        LocalVariableProxyImpl localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName($this$variableValue, variableName);
        if (localVariableProxyImpl == null) {
            return null;
        }
        LocalVariableProxyImpl continuationVariable = localVariableProxyImpl;
        Value value2 = $this$variableValue.getValue(continuationVariable);
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        ObjectReference objectReference = (ObjectReference)value2;
        if (objectReference == null) {
            return null;
        }
        return objectReference;
    }

    @Nullable
    public static final ObjectReference continuationVariableValue(@NotNull StackFrameProxyImpl $this$continuationVariableValue) {
        Intrinsics.checkNotNullParameter((Object)$this$continuationVariableValue, (String)"$this$continuationVariableValue");
        return CoroutineUtilsKt.variableValue($this$continuationVariableValue, "$continuation");
    }

    @Nullable
    public static final ObjectReference thisVariableValue(@NotNull StackFrameProxyImpl $this$thisVariableValue) {
        Intrinsics.checkNotNullParameter((Object)$this$thisVariableValue, (String)"$this$thisVariableValue");
        return $this$thisVariableValue.thisObject();
    }

    private static final boolean isGetCoroutineSuspended(Method $this$isGetCoroutineSuspended) {
        return Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.signature(), (Object)"()Ljava/lang/Object;") && Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.name(), (Object)"getCOROUTINE_SUSPENDED") && Intrinsics.areEqual((Object)$this$isGetCoroutineSuspended.declaringType().name(), (Object)"kotlin.coroutines.intrinsics.IntrinsicsKt__IntrinsicsKt");
    }

    @Nullable
    public static final ClassType findCoroutineMetadataType(@NotNull DefaultExecutionContext $this$findCoroutineMetadataType) {
        Intrinsics.checkNotNullParameter((Object)$this$findCoroutineMetadataType, (String)"$this$findCoroutineMetadataType");
        return (ClassType)DebuggerUtilKt.invokeInManagerThread($this$findCoroutineMetadataType.getDebugProcess(), (Function1)new Function1<DebuggerContextImpl, ClassType>($this$findCoroutineMetadataType){
            final /* synthetic */ DefaultExecutionContext $this_findCoroutineMetadataType;

            @Nullable
            public final ClassType invoke(@NotNull DebuggerContextImpl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$this_findCoroutineMetadataType.findClassSafe("kotlin.coroutines.jvm.internal.DebugMetadataKt");
            }
            {
                this.$this_findCoroutineMetadataType = defaultExecutionContext;
                super(1);
            }
        });
    }

    @Nullable
    public static final List<ReferenceType> findDispatchedContinuationReferenceType(@NotNull DefaultExecutionContext $this$findDispatchedContinuationReferenceType) {
        Intrinsics.checkNotNullParameter((Object)$this$findDispatchedContinuationReferenceType, (String)"$this$findDispatchedContinuationReferenceType");
        return $this$findDispatchedContinuationReferenceType.getVm().classesByName("kotlinx.coroutines.DispatchedContinuation");
    }

    @Nullable
    public static final List<ReferenceType> findCancellableContinuationImplReferenceType(@NotNull DefaultExecutionContext $this$findCancellableContinuationImplReferenceType) {
        Intrinsics.checkNotNullParameter((Object)$this$findCancellableContinuationImplReferenceType, (String)"$this$findCancellableContinuationImplReferenceType");
        return $this$findCancellableContinuationImplReferenceType.getVm().classesByName("kotlinx.coroutines.CancellableContinuationImpl");
    }

    public static final int hasGetCoroutineSuspended(@NotNull List<? extends StackFrameProxyImpl> frames) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter(frames, (String)"frames");
            List<? extends StackFrameProxyImpl> $this$indexOfFirst$iv = frames;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<? extends StackFrameProxyImpl> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                StackFrameProxyImpl item$iv;
                StackFrameProxyImpl it = item$iv = iterator.next();
                boolean bl = false;
                Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)it);
                if (comparable != null && (comparable = SafeUtilKt.safeMethod(comparable)) != null && CoroutineUtilsKt.isGetCoroutineSuspended((Method)comparable)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public static final boolean isCreationSeparatorFrame(@NotNull StackTraceElement $this$isCreationSeparatorFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$isCreationSeparatorFrame, (String)"$this$isCreationSeparatorFrame");
        String string = $this$isCreationSeparatorFrame.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
        return StringsKt.startsWith$default((String)string, (String)CREATION_STACK_TRACE_SEPARATOR, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)$this$isCreationSeparatorFrame.getClassName(), (Object)CREATION_CLASS_NAME);
    }

    @Nullable
    public static final XSourcePosition findPosition(@NotNull Location $this$findPosition, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$findPosition, (String)"$this$findPosition");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return (XSourcePosition)ApplicationUtilsKt.runReadAction((Function0)new Function0<XSourcePosition>($this$findPosition, project2){
            final /* synthetic */ Location $this_findPosition;
            final /* synthetic */ Project $project;

            @Nullable
            public final XSourcePosition invoke() {
                XSourcePosition xSourcePosition;
                if (this.$this_findPosition.declaringType() != null) {
                    String string = this.$this_findPosition.declaringType().name();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaringType().name()");
                    xSourcePosition = CoroutineUtilsKt.access$getPosition(this.$project, string, this.$this_findPosition.lineNumber());
                } else {
                    xSourcePosition = null;
                }
                return xSourcePosition;
            }
            {
                this.$this_findPosition = location2;
                this.$project = project2;
                super(0);
            }
        });
    }

    private static final XSourcePosition getPosition(Project project2, String className2, int lineNumber2) {
        VirtualFile classFile;
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiClass psiClass2 = psiFacade.findClass(StringsKt.substringBefore$default((String)className2, (String)"$", null, (int)2, null), GlobalSearchScope.everythingScope((Project)project2));
        PsiClass psiClass3 = psiClass2;
        VirtualFile virtualFile2 = psiClass3 != null && (psiClass3 = psiClass3.getContainingFile()) != null ? psiClass3.getVirtualFile() : (classFile = null);
        if (lineNumber2 <= 0) {
            return null;
        }
        int localLineNumber = lineNumber2 - 1;
        return XDebuggerUtil.getInstance().createPosition(classFile, localLineNumber);
    }

    @Nullable
    public static final DefaultExecutionContext executionContext(@NotNull SuspendContextImpl $this$executionContext) {
        Intrinsics.checkNotNullParameter((Object)$this$executionContext, (String)"$this$executionContext");
        return (DefaultExecutionContext)CoroutineUtilsKt.invokeInManagerThread($this$executionContext, (Function0)new Function0<DefaultExecutionContext>($this$executionContext){
            final /* synthetic */ SuspendContextImpl $this_executionContext;

            @Nullable
            public final DefaultExecutionContext invoke() {
                return new DefaultExecutionContext(new EvaluationContextImpl(this.$this_executionContext, this.$this_executionContext.getFrameProxy()));
            }
            {
                this.$this_executionContext = suspendContextImpl;
                super(0);
            }
        });
    }

    @Nullable
    public static final <T> T invokeInManagerThread(@NotNull SuspendContextImpl $this$invokeInManagerThread, @NotNull Function0<? extends T> f2) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeInManagerThread, (String)"$this$invokeInManagerThread");
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        DebugProcessImpl debugProcessImpl = $this$invokeInManagerThread.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"debugProcess");
        return DebuggerUtilKt.invokeInManagerThread(debugProcessImpl, (Function1)new Function1<DebuggerContextImpl, T>(f2){
            final /* synthetic */ Function0 $f;

            @Nullable
            public final T invoke(@NotNull DebuggerContextImpl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (T)this.$f.invoke();
            }
            {
                this.$f = function0;
                super(1);
            }
        });
    }

    public static final boolean supportsEvaluation(@NotNull ThreadReferenceProxyImpl $this$supportsEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsEvaluation, (String)"$this$supportsEvaluation");
        ThreadReference threadReference = $this$supportsEvaluation.getThreadReference();
        return threadReference != null ? threadReference.isSuspended() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean supportsEvaluation(@NotNull SuspendContextImpl $this$supportsEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsEvaluation, (String)"$this$supportsEvaluation");
        DebugProcessImpl debugProcessImpl = $this$supportsEvaluation.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"this.debugProcess");
        if (DebuggerUtilKt.getCanRunEvaluation(debugProcessImpl)) return true;
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) return false;
        return true;
    }

    public static final boolean threadAndContextSupportsEvaluation(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Boolean bl = (Boolean)CoroutineUtilsKt.invokeInManagerThread(suspendContext, (Function0)new Function0<Boolean>(frameProxy, suspendContext){
            final /* synthetic */ StackFrameProxyImpl $frameProxy;
            final /* synthetic */ SuspendContextImpl $suspendContext;

            @Nullable
            public final Boolean invoke() {
                StackFrameProxyImpl stackFrameProxyImpl;
                return CoroutineUtilsKt.supportsEvaluation(this.$suspendContext) && ((stackFrameProxyImpl = this.$frameProxy) != null && (stackFrameProxyImpl = stackFrameProxyImpl.threadProxy()) != null ? CoroutineUtilsKt.supportsEvaluation((ThreadReferenceProxyImpl)stackFrameProxyImpl) : false);
            }
            {
                this.$frameProxy = stackFrameProxyImpl;
                this.$suspendContext = suspendContextImpl;
                super(0);
            }
        });
        return bl != null ? bl : false;
    }

    public static final boolean sameLineAndMethod(@NotNull Location $this$sameLineAndMethod, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)$this$sameLineAndMethod, (String)"$this$sameLineAndMethod");
        return location2 != null && Intrinsics.areEqual((Object)SafeUtilKt.safeMethod(location2), (Object)SafeUtilKt.safeMethod($this$sameLineAndMethod)) && SafeUtilKt.safeLineNumber(location2) == SafeUtilKt.safeLineNumber($this$sameLineAndMethod);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFilterFromTop(@NotNull Location $this$isFilterFromTop, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)$this$isFilterFromTop, (String)"$this$isFilterFromTop");
        if (CoroutineUtilsKt.isFilteredInvokeSuspend($this$isFilterFromTop)) return true;
        if (CoroutineUtilsKt.sameLineAndMethod($this$isFilterFromTop, location2)) return true;
        Location location3 = location2;
        if (!Intrinsics.areEqual((Object)(location3 != null ? SafeUtilKt.safeMethod(location3) : null), (Object)SafeUtilKt.safeMethod($this$isFilterFromTop))) return false;
        return true;
    }

    public static final boolean isFilterFromBottom(@NotNull Location $this$isFilterFromBottom, @Nullable Location location2) {
        Intrinsics.checkNotNullParameter((Object)$this$isFilterFromBottom, (String)"$this$isFilterFromBottom");
        return CoroutineUtilsKt.sameLineAndMethod($this$isFilterFromBottom, location2);
    }

    public static final /* synthetic */ XSourcePosition access$getPosition(Project project2, String className2, int lineNumber2) {
        return CoroutineUtilsKt.getPosition(project2, className2, lineNumber2);
    }
}

