/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContext;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaState;
import org.jetbrains.kotlin.idea.formatter.trailingComma.UtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH$J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/TrailingCommaVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "()V", "recursively", "", "getRecursively", "()Z", "process", "", "trailingCommaContext", "Lorg/jetbrains/kotlin/idea/formatter/trailingComma/TrailingCommaContext;", "runProcessIfApplicable", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitElement", "Lcom/intellij/psi/PsiElement;", "visitKtElement", "kotlin.idea"})
public abstract class TrailingCommaVisitor
extends KtTreeVisitorVoid {
    private final boolean recursively;

    public void visitKtElement(@NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super.visitKtElement(element3);
        if (!(element3 instanceof KtFunctionLiteral) && UtilKt.canAddTrailingComma((PsiElement)element3)) {
            this.runProcessIfApplicable(element3);
        }
    }

    public void visitElement(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        ProgressIndicatorProvider.checkCanceled();
        if (this.getRecursively()) {
            super.visitElement(element3);
        }
    }

    private final void runProcessIfApplicable(KtElement element3) {
        TrailingCommaContext context2 = TrailingCommaContext.Companion.create((PsiElement)element3);
        if (context2.getState() != TrailingCommaState.NOT_APPLICABLE) {
            this.process(context2);
        }
    }

    protected abstract void process(@NotNull TrailingCommaContext var1);

    protected boolean getRecursively() {
        return this.recursively;
    }

    public TrailingCommaVisitor() {
        this.recursively = true;
    }
}

