/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfBooleanConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfLongConstantType;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.dfa.KtClassDef;
import org.jetbrains.kotlin.idea.inspections.dfa.LambdaAndParameter;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0006H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0000\u001a\u0016\u0010\u0013\u001a\u00020\u0011*\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0012*\u00020\u0012H\u0000\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0012*\u00020\u0018H\u0000\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002\u001a\u000e\u0010\u001c\u001a\u00020\u0001*\u0004\u0018\u00010\u0012H\u0000\u001a\f\u0010\u001d\u001a\u00020\u0001*\u00020\u0012H\u0002\u001a\f\u0010\u001e\u001a\u00020\u001f*\u00020\u0012H\u0000\u00a8\u0006 "}, d2={"getConstant", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "expr", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "getInlineableLambda", "Lorg/jetbrains/kotlin/idea/inspections/dfa/LambdaAndParameter;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "mathOpFromAssignmentToken", "Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp;", "token", "Lcom/intellij/psi/tree/IElementType;", "mathOpFromToken", "ref", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "relationFromToken", "Lcom/intellij/codeInspection/dataFlow/value/RelationType;", "canBeNull", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "fqNameEquals", "fqName", "", "getArrayElementType", "getKotlinType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getTypeConstraint", "Lcom/intellij/codeInspection/dataFlow/TypeConstraint;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "toDfType", "toDfTypeNotNullable", "toPsiPrimitiveType", "Lcom/intellij/psi/PsiPrimitiveType;", "kotlin.idea"})
public final class KtDfaHelpersKt {
    @NotNull
    public static final DfType toDfType(@Nullable KotlinType $this$toDfType) {
        if ($this$toDfType == null) {
            DfType dfType = DfType.TOP;
            Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"DfType.TOP");
            return dfType;
        }
        if (KtDfaHelpersKt.canBeNull($this$toDfType)) {
            DfType dfType;
            DfType dfType2;
            DfType notNullableType = KtDfaHelpersKt.toDfTypeNotNullable(TypeUtilsKt.makeNotNullable((KotlinType)$this$toDfType));
            if (notNullableType instanceof DfPrimitiveType) {
                ClassifierDescriptor classifierDescriptor = $this$toDfType.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                ClassDescriptor cls = (ClassDescriptor)classifierDescriptor;
                DfType boxedType = null;
                if (cls != null) {
                    DfType dfType3 = TypeConstraints.exactClass((TypeConstraints.ClassDef)new KtClassDef(cls)).asDfType();
                    Intrinsics.checkNotNullExpressionValue((Object)dfType3, (String)"TypeConstraints.exactCla\u2026ClassDef(cls)).asDfType()");
                    boxedType = dfType3;
                } else {
                    DfReferenceType dfReferenceType = DfTypes.OBJECT_OR_NULL;
                    Intrinsics.checkNotNullExpressionValue((Object)dfReferenceType, (String)"DfTypes.OBJECT_OR_NULL");
                    boxedType = (DfType)dfReferenceType;
                }
                DfType dfType4 = SpecialField.UNBOX.asDfType(notNullableType).meet(boxedType);
                Intrinsics.checkNotNullExpressionValue((Object)dfType4, (String)"SpecialField.UNBOX.asDfT\u2026ableType).meet(boxedType)");
                notNullableType = dfType4;
            }
            if ((dfType2 = notNullableType) instanceof DfReferenceType) {
                DfType dfType5 = ((DfReferenceType)notNullableType).dropNullability().meet((DfType)DfaNullability.NULLABLE.asDfType());
                dfType = dfType5;
                Intrinsics.checkNotNullExpressionValue((Object)dfType5, (String)"notNullableType.dropNull\u2026lity.NULLABLE.asDfType())");
            } else if (Intrinsics.areEqual((Object)dfType2, (Object)DfType.BOTTOM)) {
                DfNullConstantType dfNullConstantType = DfTypes.NULL;
                Intrinsics.checkNotNullExpressionValue((Object)dfNullConstantType, (String)"DfTypes.NULL");
                dfType = (DfType)dfNullConstantType;
            } else {
                dfType = notNullableType;
            }
            return dfType;
        }
        return KtDfaHelpersKt.toDfTypeNotNullable($this$toDfType);
    }

    /*
     * WARNING - void declaration
     */
    private static final DfType toDfTypeNotNullable(KotlinType $this$toDfTypeNotNullable) {
        DfType dfType;
        ClassifierDescriptor descriptor2 = $this$toDfTypeNotNullable.getConstructor().getDeclarationDescriptor();
        if (descriptor2 instanceof TypeAliasDescriptor) {
            dfType = KtDfaHelpersKt.toDfType((KotlinType)((TypeAliasDescriptor)descriptor2).getExpandedType());
        } else if (descriptor2 instanceof ClassDescriptor) {
            DfType dfType2;
            FqNameUnsafe fqNameUnsafe = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)descriptor2));
            if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._boolean)) {
                dfType2 = (DfType)DfTypes.BOOLEAN;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._byte)) {
                dfType2 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)-128, (long)127));
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._char)) {
                int n = 0;
                long l = n;
                n = 65535;
                dfType2 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)l, (long)n));
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._short)) {
                dfType2 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)Short.MIN_VALUE, (long)Short.MAX_VALUE));
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._int)) {
                dfType2 = (DfType)DfTypes.INT;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._long)) {
                dfType2 = (DfType)DfTypes.LONG;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._float)) {
                dfType2 = (DfType)DfTypes.FLOAT;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._double)) {
                dfType2 = (DfType)DfTypes.DOUBLE;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames.array)) {
                ClassifierDescriptor classifierDescriptor;
                KotlinType kotlinType = KtDfaHelpersKt.getArrayElementType($this$toDfTypeNotNullable);
                if (!((kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null ? kotlinType.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                if (classDescriptor == null) {
                    DfType dfType3 = DfType.TOP;
                    Intrinsics.checkNotNullExpressionValue((Object)dfType3, (String)"DfType.TOP");
                    return dfType3;
                }
                ClassDescriptor elementType = classDescriptor;
                dfType2 = KtDfaHelpersKt.getTypeConstraint(elementType).arrayOf().asDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT);
            } else {
                dfType2 = Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames.any) ? (DfType)DfTypes.NOT_NULL_OBJECT : KtDfaHelpersKt.getTypeConstraint((ClassDescriptor)descriptor2).asDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT);
            }
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"when (descriptor.fqNameU\u2026OT_NULL_OBJECT)\n        }");
        } else if (descriptor2 instanceof TypeParameterDescriptor) {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            List list2 = ((TypeParameterDescriptor)descriptor2).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"descriptor.upperBounds");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void type2;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DfType dfType4 = KtDfaHelpersKt.toDfType((KotlinType)type2);
                collection.add(dfType4);
            }
            $this$map$iv = (List)destination$iv$iv;
            DfType initial$iv = DfType.TOP;
            boolean $i$f$fold = false;
            DfType accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void p2;
                Object item$iv$iv;
                item$iv$iv = (DfType)element$iv;
                DfType p1 = accumulator$iv;
                boolean bl = false;
                accumulator$iv = p1.meet((DfType)p2);
            }
            DfType dfType5 = accumulator$iv;
            dfType = dfType5;
            Intrinsics.checkNotNullExpressionValue((Object)dfType5, (String)"descriptor.upperBounds.m\u2026DfType.TOP, DfType::meet)");
        } else {
            DfType dfType6 = DfType.TOP;
            dfType = dfType6;
            Intrinsics.checkNotNullExpressionValue((Object)dfType6, (String)"DfType.TOP");
        }
        return dfType;
    }

    /*
     * WARNING - void declaration
     */
    private static final TypeConstraint getTypeConstraint(ClassDescriptor $this$getTypeConstraint) {
        TypeConstraint typeConstraint;
        FqNameUnsafe fqNameUnsafe = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)$this$getTypeConstraint));
        Name name2 = fqNameUnsafe.shortNameOrSpecial();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"fqNameUnsafe.shortNameOrSpecial()");
        if (name2.isSpecial()) {
            KtElement psi2;
            SourceElement sourceElement = $this$getTypeConstraint.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"source");
            SourceElement source = sourceElement;
            if (source instanceof KotlinSourceElement && (psi2 = ((KotlinSourceElement)source).getPsi()) instanceof KtObjectDeclaration) {
                TypeConstraint typeConstraint2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                BindingContext bindingContext2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode$default(psi2, null, 1, null);
                Iterable iterable = ((KtObjectDeclaration)psi2).getSuperTypeListEntries();
                boolean $i$f$map = false;
                void var8_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ClassDescriptor classDescriptor;
                    ClassifierDescriptor classifierDescriptor;
                    void entry;
                    KtSuperTypeListEntry ktSuperTypeListEntry = (KtSuperTypeListEntry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    KtTypeReference ktTypeReference = entry.getTypeReference();
                    if (!((ktTypeReference != null && (ktTypeReference = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)ktTypeReference, (BindingContext)bindingContext2)) != null && (ktTypeReference = ktTypeReference.getConstructor()) != null ? ktTypeReference.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
                        classifierDescriptor = null;
                    }
                    KtClassDef ktClassDef = (classDescriptor = (ClassDescriptor)classifierDescriptor) == null ? null : new KtClassDef(classDescriptor);
                    collection.add(ktClassDef);
                }
                List superTypes2 = (List)destination$iv$iv;
                if (superTypes2.contains(null)) {
                    TypeConstraint typeConstraint3 = TypeConstraints.TOP;
                    typeConstraint2 = typeConstraint3;
                    Intrinsics.checkNotNullExpressionValue((Object)typeConstraint3, (String)"TypeConstraints.TOP");
                } else {
                    TypeConstraint typeConstraint4 = TypeConstraints.exactSubtype((PsiElement)((PsiElement)psi2), (List)superTypes2);
                    typeConstraint2 = typeConstraint4;
                    Intrinsics.checkNotNullExpressionValue((Object)typeConstraint4, (String)"TypeConstraints.exactSubtype(psi, superTypes)");
                }
                return typeConstraint2;
            }
        }
        switch (fqNameUnsafe.asString()) {
            case "kotlin.ByteArray": {
                TypeConstraint typeConstraint5 = TypeConstraints.exact((PsiType)((PsiType)PsiType.BYTE.createArrayType()));
                typeConstraint = typeConstraint5;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint5, (String)"TypeConstraints.exact(Ps\u2026e.BYTE.createArrayType())");
                break;
            }
            case "kotlin.IntArray": {
                TypeConstraint typeConstraint6 = TypeConstraints.exact((PsiType)((PsiType)PsiType.INT.createArrayType()));
                typeConstraint = typeConstraint6;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint6, (String)"TypeConstraints.exact(Ps\u2026pe.INT.createArrayType())");
                break;
            }
            case "kotlin.LongArray": {
                TypeConstraint typeConstraint7 = TypeConstraints.exact((PsiType)((PsiType)PsiType.LONG.createArrayType()));
                typeConstraint = typeConstraint7;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint7, (String)"TypeConstraints.exact(Ps\u2026e.LONG.createArrayType())");
                break;
            }
            case "kotlin.ShortArray": {
                TypeConstraint typeConstraint8 = TypeConstraints.exact((PsiType)((PsiType)PsiType.SHORT.createArrayType()));
                typeConstraint = typeConstraint8;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint8, (String)"TypeConstraints.exact(Ps\u2026.SHORT.createArrayType())");
                break;
            }
            case "kotlin.CharArray": {
                TypeConstraint typeConstraint9 = TypeConstraints.exact((PsiType)((PsiType)PsiType.CHAR.createArrayType()));
                typeConstraint = typeConstraint9;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint9, (String)"TypeConstraints.exact(Ps\u2026e.CHAR.createArrayType())");
                break;
            }
            case "kotlin.BooleanArray": {
                TypeConstraint typeConstraint10 = TypeConstraints.exact((PsiType)((PsiType)PsiType.BOOLEAN.createArrayType()));
                typeConstraint = typeConstraint10;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint10, (String)"TypeConstraints.exact(Ps\u2026OOLEAN.createArrayType())");
                break;
            }
            case "kotlin.FloatArray": {
                TypeConstraint typeConstraint11 = TypeConstraints.exact((PsiType)((PsiType)PsiType.FLOAT.createArrayType()));
                typeConstraint = typeConstraint11;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint11, (String)"TypeConstraints.exact(Ps\u2026.FLOAT.createArrayType())");
                break;
            }
            case "kotlin.DoubleArray": {
                TypeConstraint typeConstraint12 = TypeConstraints.exact((PsiType)((PsiType)PsiType.DOUBLE.createArrayType()));
                typeConstraint = typeConstraint12;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint12, (String)"TypeConstraints.exact(Ps\u2026DOUBLE.createArrayType())");
                break;
            }
            default: {
                KtClassDef classDef2 = new KtClassDef($this$getTypeConstraint);
                TypeConstraint typeConstraint13 = $this$getTypeConstraint.getKind() == ClassKind.OBJECT && classDef2.isFinal() ? (TypeConstraint)TypeConstraints.singleton((TypeConstraints.ClassDef)classDef2) : TypeConstraints.exactClass((TypeConstraints.ClassDef)classDef2).instanceOf();
                typeConstraint = typeConstraint13;
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint13, (String)"if (kind == ClassKind.OB\u2026nstanceOf()\n            }");
            }
        }
        return typeConstraint;
    }

    public static final boolean fqNameEquals(@Nullable KotlinType $this$fqNameEquals, @NotNull String fqName2) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return $this$fqNameEquals != null && Intrinsics.areEqual((classifierDescriptor = $this$fqNameEquals.getConstructor().getDeclarationDescriptor()) != null && (classifierDescriptor = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor))) != null ? classifierDescriptor.asString() : null, (Object)fqName2);
    }

    public static final boolean canBeNull(@NotNull KotlinType $this$canBeNull) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeNull, (String)"$this$canBeNull");
        return $this$canBeNull.isMarkedNullable() || FlexibleTypesKt.isNullabilityFlexible((KotlinType)$this$canBeNull);
    }

    @NotNull
    public static final DfType getConstant(@NotNull KtConstantExpression expr) {
        DfType dfType;
        ConstantValue constant;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        BindingContext bindingContext2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)expr, BodyResolveMode.PARTIAL);
        KotlinType type2 = bindingContext2.getType((KtExpression)expr);
        if (type2 == null) {
            object = null;
        } else {
            CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant((KtExpression)expr, bindingContext2);
            object = compileTimeConstant != null ? compileTimeConstant.toConstantValue(type2) : null;
        }
        ConstantValue constantValue = constant = object;
        if (constantValue instanceof NullValue) {
            DfNullConstantType dfNullConstantType = DfTypes.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)dfNullConstantType, (String)"DfTypes.NULL");
            dfType = (DfType)dfNullConstantType;
        } else if (constantValue instanceof BooleanValue) {
            DfBooleanConstantType dfBooleanConstantType = DfTypes.booleanValue((boolean)((Boolean)((BooleanValue)constant).getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)dfBooleanConstantType, (String)"DfTypes.booleanValue(constant.value)");
            dfType = (DfType)dfBooleanConstantType;
        } else if (constantValue instanceof ByteValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((ByteValue)constant).getValue()).byteValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value.toInt())");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof ShortValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((ShortValue)constant).getValue()).shortValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value.toInt())");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof CharValue) {
            char c = ((Character)((CharValue)constant).getValue()).charValue();
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)c);
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value.code)");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof IntValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((IntValue)constant).getValue()).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value)");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof LongValue) {
            DfLongConstantType dfLongConstantType = DfTypes.longValue((long)((Number)((LongValue)constant).getValue()).longValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfLongConstantType, (String)"DfTypes.longValue(constant.value)");
            dfType = (DfType)dfLongConstantType;
        } else if (constantValue instanceof FloatValue) {
            DfFloatConstantType dfFloatConstantType = DfTypes.floatValue((float)((Number)((FloatValue)constant).getValue()).floatValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfFloatConstantType, (String)"DfTypes.floatValue(constant.value)");
            dfType = (DfType)dfFloatConstantType;
        } else if (constantValue instanceof DoubleValue) {
            DfDoubleConstantType dfDoubleConstantType = DfTypes.doubleValue((double)((Number)((DoubleValue)constant).getValue()).doubleValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfDoubleConstantType, (String)"DfTypes.doubleValue(constant.value)");
            dfType = (DfType)dfDoubleConstantType;
        } else {
            DfType dfType2 = DfType.TOP;
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"DfType.TOP");
        }
        return dfType;
    }

    @Nullable
    public static final KotlinType getKotlinType(@NotNull KtExpression $this$getKotlinType) {
        Intrinsics.checkNotNullParameter((Object)$this$getKotlinType, (String)"$this$getKotlinType");
        PsiElement parent2 = $this$getKotlinType.getParent();
        if (parent2 instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)parent2).getSelectorExpression(), (Object)$this$getKotlinType)) {
            parent2 = ((KtDotQualifiedExpression)parent2).getParent();
        }
        while (parent2 instanceof KtParenthesizedExpression) {
            parent2 = ((KtParenthesizedExpression)parent2).getParent();
        }
        if (parent2 instanceof KtBinaryExpressionWithTypeRHS) {
            ResolvedCall call;
            KtSimpleNameExpression ktSimpleNameExpression = ((KtBinaryExpressionWithTypeRHS)parent2).getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"parent.operationReference");
            if (Intrinsics.areEqual((Object)ktSimpleNameExpression.getText(), (Object)"as?") && (call = ResolutionUtils.resolveToCall$default((KtElement)$this$getKotlinType, null, 1, null)) != null) {
                ClassifierDescriptor typeDescriptor;
                CallableDescriptor descriptor2 = call.getResultingDescriptor();
                CallableDescriptor callableDescriptor = descriptor2.getOriginal();
                Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"descriptor.original");
                KotlinType kotlinType = callableDescriptor.getReturnType();
                ClassifierDescriptor classifierDescriptor = kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null ? kotlinType.getDeclarationDescriptor() : (typeDescriptor = null);
                if (typeDescriptor instanceof TypeParameterDescriptor) {
                    List list2 = ((TypeParameterDescriptor)typeDescriptor).getUpperBounds();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"typeDescriptor.upperBounds");
                    KotlinType upperBound = (KotlinType)CollectionsKt.singleOrNull((List)list2);
                    if (upperBound != null) {
                        return upperBound;
                    }
                }
            }
        }
        return ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)$this$getKotlinType, BodyResolveMode.PARTIAL).getType($this$getKotlinType);
    }

    @Nullable
    public static final KotlinType getArrayElementType(@NotNull KotlinType $this$getArrayElementType) {
        Intrinsics.checkNotNullParameter((Object)$this$getArrayElementType, (String)"$this$getArrayElementType");
        if (!KotlinBuiltIns.isArrayOrPrimitiveArray((KotlinType)$this$getArrayElementType)) {
            return null;
        }
        KotlinType kotlinType = TypeUtilsKt.getBuiltIns((KotlinType)$this$getArrayElementType).getArrayElementType($this$getArrayElementType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"builtIns.getArrayElementType(this)");
        KotlinType type2 = kotlinType;
        if (KotlinBuiltIns.isArray((KotlinType)$this$getArrayElementType) && KotlinBuiltIns.isPrimitiveType((KotlinType)type2)) {
            return TypeUtilsKt.makeNullable((KotlinType)type2);
        }
        return type2;
    }

    @NotNull
    public static final PsiPrimitiveType toPsiPrimitiveType(@NotNull KotlinType $this$toPsiPrimitiveType) {
        PsiPrimitiveType psiPrimitiveType;
        FqNameUnsafe fqNameUnsafe;
        Intrinsics.checkNotNullParameter((Object)$this$toPsiPrimitiveType, (String)"$this$toPsiPrimitiveType");
        ClassifierDescriptor classifierDescriptor = $this$toPsiPrimitiveType.getConstructor().getDeclarationDescriptor();
        Object object = fqNameUnsafe = classifierDescriptor != null ? DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor)) : null;
        if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._int)) {
            PsiPrimitiveType psiPrimitiveType2 = PsiType.INT;
            psiPrimitiveType = psiPrimitiveType2;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType2, (String)"PsiType.INT");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._long)) {
            PsiPrimitiveType psiPrimitiveType3 = PsiType.LONG;
            psiPrimitiveType = psiPrimitiveType3;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType3, (String)"PsiType.LONG");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._short)) {
            PsiPrimitiveType psiPrimitiveType4 = PsiType.SHORT;
            psiPrimitiveType = psiPrimitiveType4;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType4, (String)"PsiType.SHORT");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._boolean)) {
            PsiPrimitiveType psiPrimitiveType5 = PsiType.BOOLEAN;
            psiPrimitiveType = psiPrimitiveType5;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType5, (String)"PsiType.BOOLEAN");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._byte)) {
            PsiPrimitiveType psiPrimitiveType6 = PsiType.BYTE;
            psiPrimitiveType = psiPrimitiveType6;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType6, (String)"PsiType.BYTE");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._char)) {
            PsiPrimitiveType psiPrimitiveType7 = PsiType.CHAR;
            psiPrimitiveType = psiPrimitiveType7;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType7, (String)"PsiType.CHAR");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._double)) {
            PsiPrimitiveType psiPrimitiveType8 = PsiType.DOUBLE;
            psiPrimitiveType = psiPrimitiveType8;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType8, (String)"PsiType.DOUBLE");
        } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._float)) {
            PsiPrimitiveType psiPrimitiveType9 = PsiType.FLOAT;
            psiPrimitiveType = psiPrimitiveType9;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType9, (String)"PsiType.FLOAT");
        } else {
            throw (Throwable)new IllegalArgumentException("Not a primitive analog: " + $this$toPsiPrimitiveType);
        }
        return psiPrimitiveType;
    }

    @Nullable
    public static final RelationType relationFromToken(@NotNull IElementType token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        IElementType iElementType = token;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) ? RelationType.LT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) ? RelationType.GT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ) ? RelationType.LE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) ? RelationType.GE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) ? RelationType.EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ) ? RelationType.NE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ) ? RelationType.EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ) ? RelationType.NE : null)))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final LongRangeBinOp mathOpFromToken(@NotNull KtOperationReferenceExpression ref2) {
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        String string = ref2.getText();
        if (string == null) return null;
        switch (string) {
            case "+": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.PLUS;
                return longRangeBinOp;
            }
            case "-": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MINUS;
                return longRangeBinOp;
            }
            case "*": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MUL;
                return longRangeBinOp;
            }
            case "/": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.DIV;
                return longRangeBinOp;
            }
            case "%": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MOD;
                return longRangeBinOp;
            }
            case "and": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.AND;
                return longRangeBinOp;
            }
            case "or": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.OR;
                return longRangeBinOp;
            }
            case "xor": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.XOR;
                return longRangeBinOp;
            }
            case "shl": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.SHL;
                return longRangeBinOp;
            }
            case "shr": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.SHR;
                return longRangeBinOp;
            }
            case "ushr": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.USHR;
                return longRangeBinOp;
            }
            default: {
                return null;
            }
        }
    }

    @Nullable
    public static final LongRangeBinOp mathOpFromAssignmentToken(@NotNull IElementType token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        IElementType iElementType = token;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ) ? LongRangeBinOp.PLUS : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ) ? LongRangeBinOp.MINUS : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ) ? LongRangeBinOp.MUL : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ) ? LongRangeBinOp.DIV : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ) ? LongRangeBinOp.MOD : null))));
    }

    @Nullable
    public static final LambdaAndParameter getInlineableLambda(@NotNull KtCallExpression expr) {
        ArgumentMatch argumentMatch;
        FunctionDescriptor descriptor2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        List list2 = expr.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expr.lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        if (ktLambdaArgument == null) {
            return null;
        }
        KtLambdaArgument lambdaArgument = ktLambdaArgument;
        KtLambdaExpression ktLambdaExpression2 = lambdaArgument.getLambdaExpression();
        if (ktLambdaExpression2 == null) {
            return null;
        }
        KtLambdaExpression lambdaExpression2 = ktLambdaExpression2;
        int index2 = expr.getValueArguments().indexOf(lambdaArgument);
        boolean bl2 = bl = index2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)expr, null, 1, null);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        if ((descriptor2 = (FunctionDescriptor)callableDescriptor) == null || !descriptor2.isInline()) {
            return null;
        }
        ArgumentMapping argumentMapping = resolvedCall3.getArgumentMapping((ValueArgument)lambdaArgument);
        if (!(argumentMapping instanceof ArgumentMatch)) {
            argumentMapping = null;
        }
        if ((argumentMatch = (ArgumentMatch)argumentMapping) == null || (argumentMatch = argumentMatch.getValueParameter()) == null) {
            return null;
        }
        ArgumentMatch parameterDescriptor = argumentMatch;
        if (parameterDescriptor.isNoinline()) {
            return null;
        }
        return new LambdaAndParameter(lambdaExpression2, (ValueParameterDescriptor)parameterDescriptor);
    }
}

